/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network;

import com.aetherteam.aether.network.AetherPacket;
import com.aetherteam.aether.network.packet.AetherPlayerSyncPacket;
import com.aetherteam.aether.network.packet.AetherRankingsSyncPacket;
import com.aetherteam.aether.network.packet.client.AetherTravelPacket;
import com.aetherteam.aether.network.packet.client.BossInfoPacket;
import com.aetherteam.aether.network.packet.client.ClientGrabItemPacket;
import com.aetherteam.aether.network.packet.client.CloudMinionPacket;
import com.aetherteam.aether.network.packet.client.EternalDayPacket;
import com.aetherteam.aether.network.packet.client.ExplosionParticlePacket;
import com.aetherteam.aether.network.packet.client.HealthResetPacket;
import com.aetherteam.aether.network.packet.client.LeavingAetherPacket;
import com.aetherteam.aether.network.packet.client.MoaInteractPacket;
import com.aetherteam.aether.network.packet.client.OpenNpcDialoguePacket;
import com.aetherteam.aether.network.packet.client.OpenSunAltarPacket;
import com.aetherteam.aether.network.packet.client.PhoenixArrowPacket;
import com.aetherteam.aether.network.packet.client.PortalTravelSoundPacket;
import com.aetherteam.aether.network.packet.client.RemountAerbunnyPacket;
import com.aetherteam.aether.network.packet.client.SentryExplosionParticlePacket;
import com.aetherteam.aether.network.packet.client.SetVehiclePacket;
import com.aetherteam.aether.network.packet.client.SwetAttackPacket;
import com.aetherteam.aether.network.packet.client.SwetDeathParticlePacket;
import com.aetherteam.aether.network.packet.client.ToolDebuffPacket;
import com.aetherteam.aether.network.packet.client.ZephyrSnowballHitPacket;
import com.aetherteam.aether.network.packet.server.AerbunnyPuffPacket;
import com.aetherteam.aether.network.packet.server.ClearItemPacket;
import com.aetherteam.aether.network.packet.server.HittingPacket;
import com.aetherteam.aether.network.packet.server.JumpPacket;
import com.aetherteam.aether.network.packet.server.LoreExistsPacket;
import com.aetherteam.aether.network.packet.server.MovementPacket;
import com.aetherteam.aether.network.packet.server.NpcPlayerInteractPacket;
import com.aetherteam.aether.network.packet.server.OpenAccessoriesPacket;
import com.aetherteam.aether.network.packet.server.OpenInventoryPacket;
import com.aetherteam.aether.network.packet.server.RankingsForcePacket;
import com.aetherteam.aether.network.packet.server.StepHeightPacket;
import com.aetherteam.aether.network.packet.server.SunAltarUpdatePacket;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class AetherPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("aether", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int index;

    public static synchronized void register() {
        AetherPacketHandler.register(AetherTravelPacket.class, AetherTravelPacket::decode);
        AetherPacketHandler.register(BossInfoPacket.Display.class, BossInfoPacket.Display::decode);
        AetherPacketHandler.register(BossInfoPacket.Remove.class, BossInfoPacket.Remove::decode);
        AetherPacketHandler.register(CloudMinionPacket.class, CloudMinionPacket::decode);
        AetherPacketHandler.register(ClientGrabItemPacket.class, ClientGrabItemPacket::decode);
        AetherPacketHandler.register(EternalDayPacket.class, EternalDayPacket::decode);
        AetherPacketHandler.register(ExplosionParticlePacket.class, ExplosionParticlePacket::decode);
        AetherPacketHandler.register(HealthResetPacket.class, HealthResetPacket::decode);
        AetherPacketHandler.register(LeavingAetherPacket.class, LeavingAetherPacket::decode);
        AetherPacketHandler.register(MoaInteractPacket.class, MoaInteractPacket::decode);
        AetherPacketHandler.register(OpenNpcDialoguePacket.class, OpenNpcDialoguePacket::decode);
        AetherPacketHandler.register(OpenSunAltarPacket.class, OpenSunAltarPacket::decode);
        AetherPacketHandler.register(PhoenixArrowPacket.class, PhoenixArrowPacket::decode);
        AetherPacketHandler.register(PortalTravelSoundPacket.class, PortalTravelSoundPacket::decode);
        AetherPacketHandler.register(RemountAerbunnyPacket.class, RemountAerbunnyPacket::decode);
        AetherPacketHandler.register(SentryExplosionParticlePacket.class, SentryExplosionParticlePacket::decode);
        AetherPacketHandler.register(SetVehiclePacket.class, SetVehiclePacket::decode);
        AetherPacketHandler.register(SwetAttackPacket.class, SwetAttackPacket::decode);
        AetherPacketHandler.register(SwetDeathParticlePacket.class, SwetDeathParticlePacket::decode);
        AetherPacketHandler.register(ToolDebuffPacket.class, ToolDebuffPacket::decode);
        AetherPacketHandler.register(ZephyrSnowballHitPacket.class, ZephyrSnowballHitPacket::decode);
        AetherPacketHandler.register(AerbunnyPuffPacket.class, AerbunnyPuffPacket::decode);
        AetherPacketHandler.register(ClearItemPacket.class, ClearItemPacket::decode);
        AetherPacketHandler.register(HittingPacket.class, HittingPacket::decode);
        AetherPacketHandler.register(JumpPacket.class, JumpPacket::decode);
        AetherPacketHandler.register(LoreExistsPacket.class, LoreExistsPacket::decode);
        AetherPacketHandler.register(MovementPacket.class, MovementPacket::decode);
        AetherPacketHandler.register(NpcPlayerInteractPacket.class, NpcPlayerInteractPacket::decode);
        AetherPacketHandler.register(OpenAccessoriesPacket.class, OpenAccessoriesPacket::decode);
        AetherPacketHandler.register(OpenInventoryPacket.class, OpenInventoryPacket::decode);
        AetherPacketHandler.register(RankingsForcePacket.class, RankingsForcePacket::decode);
        AetherPacketHandler.register(StepHeightPacket.class, StepHeightPacket::decode);
        AetherPacketHandler.register(SunAltarUpdatePacket.class, SunAltarUpdatePacket::decode);
        AetherPacketHandler.register(AetherPlayerSyncPacket.class, AetherPlayerSyncPacket::decode);
        AetherPacketHandler.register(AetherRankingsSyncPacket.class, AetherRankingsSyncPacket::decode);
    }

    private static <MSG extends AetherPacket> void register(Class<MSG> packet, Function<FriendlyByteBuf, MSG> decoder) {
        INSTANCE.messageBuilder(packet, index++).encoder(AetherPacket::encode).decoder(decoder).consumerMainThread(AetherPacket::handle).add();
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToNear(MSG message, double x, double y, double z, double radius, ResourceKey<Level> dimension) {
        INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)x, (double)y, (double)z, (double)radius, dimension)), message);
    }

    public static <MSG> void sendToAll(MSG message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToDimension(MSG message, ResourceKey<Level> dimension) {
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> dimension), message);
    }
}

