/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin.mixins.client;

import com.aetherteam.aether.item.accessories.cape.CapeItem;
import com.aetherteam.aether.mixin.AetherMixinHooks;
import com.aetherteam.aether.util.EquipmentUtil;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.SlotResult;

@Mixin(value={AbstractClientPlayer.class})
public class AbstractClientPlayerMixin {
    @Unique
    private static final ResourceLocation SWUFF_CAPE_LOCATION = new ResourceLocation("aether", "textures/models/accessory/capes/swuff_accessory.png");

    @Inject(at={@At(value="HEAD")}, method={"isCapeLoaded"}, cancellable=true)
    private void isCapeLoaded(CallbackInfoReturnable<Boolean> cir) {
        AbstractClientPlayer player = (AbstractClientPlayer)this;
        if (EquipmentUtil.hasCape((LivingEntity)player) && AetherMixinHooks.isCapeVisible(player)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getCloakTextureLocation"}, cancellable=true)
    private void getCloakTextureLocation(CallbackInfoReturnable<ResourceLocation> cir) {
        Item item;
        AbstractClientPlayer player = (AbstractClientPlayer)this;
        SlotResult result = EquipmentUtil.getCape((LivingEntity)player);
        if (AetherMixinHooks.isCapeVisible(player) && result != null && (item = result.stack().m_41720_()) instanceof CapeItem) {
            CapeItem capeItem = (CapeItem)item;
            if (result.stack().m_41786_().getString().equalsIgnoreCase("swuff_'s cape")) {
                cir.setReturnValue((Object)SWUFF_CAPE_LOCATION);
            } else {
                cir.setReturnValue((Object)capeItem.getCapeTexture());
            }
        }
    }
}

