/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class AetherMixinConfig {
    private static final String MIXIN_PACKAGE_ROOT = "com.aetherteam.aether.core.mixin.";
    private static final Path DIRECTORY = FMLPaths.CONFIGDIR.get().resolve("aether");
    private static final File MIXIN_CONFIG = new File(DIRECTORY.toString(), "mixin_config.json");
    private static final ImmutableList<Entry> configEntries = ImmutableList.of((Object)new Entry("com.aetherteam.aether.core.mixin.client.AdvancementToastMixin", true), (Object)new Entry("com.aetherteam.aether.core.mixin.client.MinecraftMixin", true), (Object)new Entry("com.aetherteam.aether.core.mixin.client.SplashManagerMixin", true), (Object)new Entry("com.aetherteam.aether.core.mixin.client.TippableArrowRendererMixin", true));

    public static void save() {
        if (!DIRECTORY.toFile().exists()) {
            DIRECTORY.toFile().mkdirs();
        }
        if (!MIXIN_CONFIG.exists()) {
            try (FileWriter fileWriter = new FileWriter(MIXIN_CONFIG);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("comment", "Disabling these is not advised unless necessary");
                for (Entry entry : configEntries) {
                    jsonObject.addProperty(entry.path(), Boolean.valueOf(entry.defaultValue()));
                }
                gson.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Entry load(String mixinClassName) {
        if (!MIXIN_CONFIG.exists()) return null;
        try (FileReader fileReader = new FileReader(MIXIN_CONFIG);){
            Map.Entry property;
            Gson gson = new Gson();
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)fileReader, JsonObject.class);
            Iterator iterator = jsonObject.entrySet().iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!((String)(property = (Map.Entry)iterator.next()).getKey()).equals(mixinClassName));
            Entry entry = new Entry((String)property.getKey(), ((JsonElement)property.getValue()).getAsBoolean());
            return entry;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public record Entry(String path, boolean defaultValue) {
    }
}

