/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat.abilities.armor;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.util.EquipmentUtil;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public interface PhoenixArmor {
    public static void boostLavaSwimming(LivingEntity entity) {
        Player player;
        if (EquipmentUtil.hasFullPhoenixSet(entity)) {
            Level level;
            entity.m_20095_();
            if (entity.m_20077_()) {
                entity.m_183634_();
                if (entity instanceof Player) {
                    player = (Player)entity;
                    AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                        float defaultBoost = PhoenixArmor.boostWithDepthStrider(entity, 1.75f, 1.0f);
                        aetherPlayer.setPhoenixSubmergeLength(Math.min(aetherPlayer.getPhoenixSubmergeLength() + 0.1, 1.0));
                        defaultBoost = (float)((double)defaultBoost * aetherPlayer.getPhoenixSubmergeLength());
                        entity.m_19920_(0.04f * defaultBoost, new Vec3((double)entity.f_20900_, (double)entity.f_20901_, (double)entity.f_20902_));
                    });
                } else {
                    float defaultBoost = PhoenixArmor.boostWithDepthStrider(entity, 1.75f, 1.0f);
                    entity.m_19920_(0.04f * defaultBoost, new Vec3((double)entity.f_20900_, (double)entity.f_20901_, (double)entity.f_20902_));
                }
            }
            if ((level = entity.m_9236_()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20185_() + level2.m_213780_().m_188583_() / 5.0, entity.m_20186_() + level2.m_213780_().m_188583_() / 3.0, entity.m_20189_() + level2.m_213780_().m_188583_() / 5.0, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (!(EquipmentUtil.hasFullPhoenixSet(entity) && entity.m_20077_() || !(entity instanceof Player))) {
            player = (Player)entity;
            AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setPhoenixSubmergeLength(0.0));
        }
    }

    public static void boostVerticalLavaSwimming(LivingEntity entity) {
        if (EquipmentUtil.hasFullPhoenixSet(entity)) {
            entity.m_20095_();
            if (entity.m_20077_()) {
                entity.m_183634_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                        float defaultBoost = PhoenixArmor.boostWithDepthStrider(entity, 1.5f, 0.05f);
                        aetherPlayer.setPhoenixSubmergeLength(Math.min(aetherPlayer.getPhoenixSubmergeLength() + 0.1, 1.0));
                        defaultBoost = (float)((double)defaultBoost * aetherPlayer.getPhoenixSubmergeLength());
                        if (entity.m_20184_().m_7098_() > 0.0 || entity.m_6047_()) {
                            entity.m_20256_(entity.m_20184_().m_82542_(1.0, (double)defaultBoost, 1.0));
                        }
                    });
                } else {
                    float defaultBoost = PhoenixArmor.boostWithDepthStrider(entity, 1.5f, 0.05f);
                    if (entity.m_20184_().m_7098_() > 0.0 || entity.m_6047_()) {
                        entity.m_20256_(entity.m_20184_().m_82542_(1.0, (double)defaultBoost, 1.0));
                    }
                }
            }
        }
    }

    private static float boostWithDepthStrider(LivingEntity entity, float start, float increment) {
        float defaultBoost = start;
        float depthStriderModifier = Math.min((float)EnchantmentHelper.m_44922_((LivingEntity)entity), 3.0f);
        if (depthStriderModifier > 0.0f) {
            defaultBoost += depthStriderModifier * increment;
        }
        return defaultBoost;
    }

    public static void damageArmor(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                if (EquipmentUtil.hasAnyPhoenixArmor(entity) && entity.m_20071_()) {
                    if (entity.m_9236_().m_46467_() % 15L == 0L) {
                        aetherPlayer.setObsidianConversionTime(aetherPlayer.getObsidianConversionTime() + 1);
                        entity.m_9236_().m_46796_(1501, entity.m_20183_(), 0);
                    }
                } else {
                    aetherPlayer.setObsidianConversionTime(0);
                }
                if (aetherPlayer.getObsidianConversionTime() >= aetherPlayer.getObsidianConversionTimerMax()) {
                    for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                        if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                        ItemStack equippedStack = entity.m_6844_(equipmentSlot);
                        if (equippedStack.m_150930_((Item)AetherItems.PHOENIX_HELMET.get())) {
                            PhoenixArmor.breakPhoenixArmor(entity, equippedStack, new ItemStack((ItemLike)AetherItems.OBSIDIAN_HELMET.get()), equipmentSlot);
                            continue;
                        }
                        if (equippedStack.m_150930_((Item)AetherItems.PHOENIX_CHESTPLATE.get())) {
                            PhoenixArmor.breakPhoenixArmor(entity, equippedStack, new ItemStack((ItemLike)AetherItems.OBSIDIAN_CHESTPLATE.get()), equipmentSlot);
                            continue;
                        }
                        if (equippedStack.m_150930_((Item)AetherItems.PHOENIX_LEGGINGS.get())) {
                            PhoenixArmor.breakPhoenixArmor(entity, equippedStack, new ItemStack((ItemLike)AetherItems.OBSIDIAN_LEGGINGS.get()), equipmentSlot);
                            continue;
                        }
                        if (!equippedStack.m_150930_((Item)AetherItems.PHOENIX_BOOTS.get())) continue;
                        PhoenixArmor.breakPhoenixArmor(entity, equippedStack, new ItemStack((ItemLike)AetherItems.OBSIDIAN_BOOTS.get()), equipmentSlot);
                    }
                    SlotResult slotResult = EquipmentUtil.getCurio(entity, (Item)AetherItems.PHOENIX_GLOVES.get());
                    if (slotResult != null) {
                        PhoenixArmor.breakPhoenixGloves(entity, slotResult, new ItemStack((ItemLike)AetherItems.OBSIDIAN_GLOVES.get()));
                    }
                }
            });
        }
    }

    private static void breakPhoenixArmor(LivingEntity entity, ItemStack equippedStack, ItemStack outcomeStack, EquipmentSlot slot) {
        EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)equippedStack), (ItemStack)outcomeStack);
        if (equippedStack.m_41782_()) {
            outcomeStack.m_41751_(equippedStack.m_41783_());
        }
        entity.m_8061_(slot, outcomeStack);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.f_10571_.m_43149_(serverPlayer, serverPlayer.m_150109_(), outcomeStack);
        }
    }

    private static void breakPhoenixGloves(LivingEntity entity, SlotResult slotResult, ItemStack outcomeStack) {
        EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)slotResult.stack()), (ItemStack)outcomeStack);
        if (slotResult.stack().m_41782_()) {
            outcomeStack.m_41751_(slotResult.stack().m_41783_());
        }
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(iCuriosItemHandler -> {
            Map curios = iCuriosItemHandler.getCurios();
            ICurioStacksHandler inv = (ICurioStacksHandler)curios.get(slotResult.slotContext().identifier());
            if (inv != null) {
                IDynamicStackHandler stackHandler = inv.getStacks();
                stackHandler.setStackInSlot(slotResult.slotContext().index(), outcomeStack);
            }
        });
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.f_10571_.m_43149_(serverPlayer, serverPlayer.m_150109_(), outcomeStack);
        }
    }

    public static boolean extinguishUser(LivingEntity entity, DamageSource source) {
        return EquipmentUtil.hasFullPhoenixSet(entity) && source.m_269533_(DamageTypeTags.f_268745_);
    }
}

