/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.projectile.dart.AbstractDart;
import com.aetherteam.aether.item.combat.DartItem;
import com.google.common.collect.ImmutableSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class DartShooterItem
extends ProjectileWeaponItem
implements Vanishable {
    private final Supplier<? extends Item> dartType;

    public DartShooterItem(Supplier<? extends Item> dartType, Item.Properties properties) {
        super(properties);
        this.dartType = dartType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack;
        boolean hasAmmo = !player.m_6298_(heldStack = player.m_21120_(hand)).m_41619_();
        InteractionResultHolder result = ForgeEventFactory.onArrowNock((ItemStack)heldStack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (result == null) {
            if (player.m_150110_().f_35937_ || hasAmmo) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)heldStack);
            }
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        return result;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            ItemStack ammoItem = player.m_6298_(stack);
            boolean creativeOrShooterIsInfinite = player.m_150110_().f_35937_ || stack.getEnchantmentLevel(Enchantments.f_44952_) > 0;
            boolean stillHasAmmo = !ammoItem.m_41619_() || creativeOrShooterIsInfinite;
            ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)0, (boolean)stillHasAmmo);
            if (stillHasAmmo) {
                DartItem dartItem;
                Item item;
                boolean creativeOrDartIsInfinite;
                if (ammoItem.m_41619_()) {
                    ammoItem = new ItemStack((ItemLike)this.getDartType().get());
                }
                boolean bl = creativeOrDartIsInfinite = player.m_150110_().f_35937_ || (item = ammoItem.m_41720_()) instanceof DartItem && (dartItem = (DartItem)item).isInfinite(stack);
                if (!level.m_5776_()) {
                    int punchModifier;
                    Object dart;
                    Item item2 = ammoItem.m_41720_();
                    dartItem = item2 instanceof DartItem ? (dart = (DartItem)item2) : this.getDartType().get();
                    dart = dartItem.createDart(level, (LivingEntity)player);
                    dart = this.customDart((AbstractDart)((Object)dart));
                    dart.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 1.0f);
                    dart.m_20242_(true);
                    int powerModifier = stack.getEnchantmentLevel(Enchantments.f_44988_);
                    if (powerModifier > 0) {
                        dart.m_36781_(dart.m_36789_() + (double)powerModifier * 0.5 + 0.5);
                    }
                    if ((punchModifier = stack.getEnchantmentLevel(Enchantments.f_44989_)) > 0) {
                        dart.m_36735_(punchModifier);
                    }
                    if (creativeOrDartIsInfinite || player.m_150110_().f_35937_) {
                        ((AbstractDart)((Object)dart)).f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    level.m_7967_((Entity)dart);
                }
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)AetherSoundEvents.ITEM_DART_SHOOTER_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                if (!creativeOrDartIsInfinite && !player.m_150110_().f_35937_) {
                    ammoItem.m_41774_(1);
                    if (ammoItem.m_41619_()) {
                        player.m_150109_().m_36057_(ammoItem);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 4;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_150930_(this.getDartType().get());
    }

    public AbstractDart customDart(AbstractDart dart) {
        return dart;
    }

    public int m_6615_() {
        return 15;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ImmutableSet.of((Object)Enchantments.f_44988_, (Object)Enchantments.f_44989_).contains((Object)enchantment);
    }

    public Supplier<? extends Item> getDartType() {
        return this.dartType;
    }
}

