/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.accessories.gloves;

import com.aetherteam.aether.item.accessories.AccessoryItem;
import com.aetherteam.aether.item.accessories.gloves.LeatherGlovesItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class GlovesItem
extends AccessoryItem {
    protected final double damage;
    protected ResourceLocation GLOVES_TEXTURE;
    protected final Supplier<? extends SoundEvent> equipSound;

    public GlovesItem(double punchDamage, String glovesName, Supplier<? extends SoundEvent> glovesSound, Item.Properties properties) {
        super(properties);
        this.damage = punchDamage;
        this.setRenderTexture("aether", glovesName);
        this.equipSound = glovesSound;
    }

    public GlovesItem(double punchDamage, ResourceLocation glovesName, Supplier<? extends SoundEvent> glovesSound, Item.Properties properties) {
        super(properties);
        this.damage = punchDamage;
        this.setRenderTexture(glovesName.m_135827_(), glovesName.m_135815_());
        this.equipSound = glovesSound;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "Gloves Damage Bonus", this.damage, AttributeModifier.Operation.ADDITION));
        return attributes;
    }

    @Override
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(this.equipSound.get(), 1.0f, 1.0f);
    }

    public void setRenderTexture(String modId, String registryName) {
        this.GLOVES_TEXTURE = new ResourceLocation(modId, "textures/models/accessory/gloves/" + registryName + "_accessory.png");
    }

    public ResourceLocation getGlovesTexture() {
        return this.GLOVES_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ImmutableTriple<Float, Float, Float> getColors(ItemStack stack) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        Item item = stack.m_41720_();
        if (item instanceof LeatherGlovesItem) {
            LeatherGlovesItem leatherGlovesItem = (LeatherGlovesItem)item;
            int i = leatherGlovesItem.m_41121_(stack);
            red = (float)(i >> 16 & 0xFF) / 255.0f;
            green = (float)(i >> 8 & 0xFF) / 255.0f;
            blue = (float)(i & 0xFF) / 255.0f;
        }
        return new ImmutableTriple((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }
}

