/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jei.categories.fuel;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.integration.jei.categories.fuel.AetherFuelRecipe;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class AetherFuelCategory
implements IRecipeCategory<AetherFuelRecipe> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("aether", "textures/gui/menu/altar.png");
    public static final RecipeType<AetherFuelRecipe> RECIPE_TYPE = RecipeType.create((String)"aether", (String)"fueling", AetherFuelRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> cachedFuelIndicator;

    public AetherFuelCategory(final IGuiHelper helper) {
        List<String> craftingStations = List.of(((Block)AetherBlocks.ALTAR.get()).m_49954_().getString(), ((Block)AetherBlocks.FREEZER.get()).m_49954_().getString(), ((Block)AetherBlocks.INCUBATOR.get()).m_49954_().getString());
        String longestString = craftingStations.stream().max(Comparator.comparingInt(String::length)).get();
        MutableComponent longestStationName = Component.m_237113_((String)longestString);
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        Component maxBurnTimeText = AetherFuelCategory.createBurnTimeText(10000, (Component)longestStationName);
        int maxStringWidth = fontRenderer.m_92895_(maxBurnTimeText.getString());
        int backgroundHeight = 34;
        int textPadding = 20;
        this.background = helper.drawableBuilder(TEXTURE, 55, 36, 18, backgroundHeight).addPadding(0, 0, 0, textPadding + maxStringWidth).build();
        this.icon = helper.createDrawable(TEXTURE, 176, 0, 14, 13);
        this.cachedFuelIndicator = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer burnTime) {
                return helper.drawableBuilder(TEXTURE, 176, 0, 14, 13).buildAnimated(burnTime.intValue(), IDrawableAnimated.StartDirection.TOP, true);
            }
        });
    }

    public RecipeType<AetherFuelRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.aether.jei.fuel");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AetherFuelRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addItemStacks(recipe.getInput());
    }

    public void draw(AetherFuelRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        int burnTime = recipe.getBurnTime();
        IDrawableAnimated fuelIndicator = (IDrawableAnimated)this.cachedFuelIndicator.getUnchecked((Object)burnTime);
        fuelIndicator.draw(stack, 1, 0);
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        Component burnTimeText = AetherFuelCategory.createBurnTimeText(recipe.getBurnTime(), (Component)recipe.getUsage().m_49954_());
        int stringWidth = font.m_92852_((FormattedText)burnTimeText);
        font.m_92889_(stack, burnTimeText, (float)(this.background.getWidth() - stringWidth), 14.0f, -8355712);
    }

    private static Component createBurnTimeText(int burnTime, Component usage) {
        return Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{burnTime / 20}).m_130946_(" (").m_7220_(usage).m_130946_(")");
    }
}

