/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jei.categories.block;

import com.aetherteam.aether.integration.jei.BlockStateRenderer;
import com.aetherteam.aether.integration.jei.FluidStateRenderer;
import com.aetherteam.aether.integration.jei.categories.AbstractAetherRecipeCategory;
import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.aetherteam.aether.recipe.BlockStateIngredient;
import com.aetherteam.aether.recipe.recipes.block.AbstractBlockStateRecipe;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.common.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public abstract class AbstractBlockStateRecipeCategory<T extends AbstractBlockStateRecipe>
extends AbstractAetherRecipeCategory<T> {
    protected final IPlatformFluidHelper<?> fluidHelper;

    public AbstractBlockStateRecipeCategory(String id, ResourceLocation uid, IDrawable background, IDrawable icon, RecipeType<T> recipeType, IPlatformFluidHelper<?> fluidHelper) {
        super(id, uid, background, icon, recipeType);
        this.fluidHelper = fluidHelper;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focusGroup) {
        Object ingredient;
        BlockStateIngredient recipeIngredients = ((AbstractBlockStateRecipe)recipe).getIngredient();
        BlockPropertyPair recipeResult = ((AbstractBlockStateRecipe)recipe).getResult();
        BlockPropertyPair[] pairs = recipeIngredients.getPairs();
        ArrayList<Object> ingredients = new ArrayList<Object>();
        for (BlockPropertyPair pair : pairs) {
            Block block = pair.block();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                ingredients.add(this.fluidHelper.create((Fluid)liquidBlock.getFluid(), 1000L));
                continue;
            }
            BlockState state = pair.block().m_49966_();
            for (Map.Entry<Property<?>, Comparable<?>> propertyEntry : pair.properties().entrySet()) {
                state = BlockStateRecipeUtil.setHelper(propertyEntry, state);
            }
            ItemStack stack = pair.block().m_7397_((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_, state);
            stack = stack.m_41619_() ? new ItemStack((ItemLike)Blocks.f_50069_) : stack;
            ingredients.add(stack);
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 8, 6).addIngredientsUnsafe(ingredients)).addTooltipCallback((recipeSlotView, tooltip) -> this.populateAdditionalInformation(recipe, tooltip)).setCustomRenderer((IIngredientType)Services.PLATFORM.getFluidHelper().getFluidIngredientType(), new FluidStateRenderer(Services.PLATFORM.getFluidHelper())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new BlockStateRenderer(pairs));
        Block block = recipeResult.block();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            ingredient = this.fluidHelper.create((Fluid)liquidBlock.getFluid(), 1000L);
        } else {
            BlockState resultState = recipeResult.block().m_49966_();
            for (Map.Entry entry : recipeResult.properties().entrySet()) {
                resultState = BlockStateRecipeUtil.setHelper(entry, resultState);
            }
            ItemStack stack = recipeResult.block().m_7397_((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_, resultState);
            ingredient = stack.m_41619_() ? new ItemStack((ItemLike)Blocks.f_50069_) : stack;
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 60, 6).addIngredientsUnsafe(List.of(ingredient))).setCustomRenderer((IIngredientType)Services.PLATFORM.getFluidHelper().getFluidIngredientType(), new FluidStateRenderer(Services.PLATFORM.getFluidHelper())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new BlockStateRenderer(recipeResult));
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
    }

    protected void populateAdditionalInformation(T recipe, List<Component> tooltip) {
    }
}

