/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jei.categories.ban;

import com.aetherteam.aether.integration.jei.BlockStateRenderer;
import com.aetherteam.aether.integration.jei.FluidStateRenderer;
import com.aetherteam.aether.integration.jei.categories.ban.AbstractPlacementBanRecipeCategory;
import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.aetherteam.aether.recipe.BlockStateIngredient;
import com.aetherteam.aether.recipe.recipes.ban.BlockBanRecipe;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import java.util.ArrayList;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.common.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public class BlockBanRecipeCategory
extends AbstractPlacementBanRecipeCategory<BlockState, BlockStateIngredient, BlockBanRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("aether", "block_placement_ban");
    public static final ResourceLocation TEXTURE = new ResourceLocation("aether", "textures/gui/menu/jei_render.png");
    public static final RecipeType<BlockBanRecipe> RECIPE_TYPE = RecipeType.create((String)"aether", (String)"block_placement_ban", BlockBanRecipe.class);

    public BlockBanRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<?> fluidHelper) {
        super(guiHelper, "block_placement_ban", UID, (IDrawable)guiHelper.createBlankDrawable(116, 18), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50081_)), RECIPE_TYPE, fluidHelper);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, BlockBanRecipe recipe, IFocusGroup focusGroup) {
        BlockStateIngredient ingredient = (BlockStateIngredient)recipe.getIngredient();
        BlockPropertyPair[] pairs = ingredient.getPairs();
        ArrayList<Object> ingredients = new ArrayList<Object>();
        for (BlockPropertyPair pair : pairs) {
            Block block = pair.block();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                ingredients.add(this.fluidHelper.create((Fluid)liquidBlock.getFluid(), 1000L));
                continue;
            }
            BlockState state = pair.block().m_49966_();
            for (Map.Entry<Property<?>, Comparable<?>> propertyEntry : pair.properties().entrySet()) {
                state = BlockStateRecipeUtil.setHelper(propertyEntry, state);
            }
            ItemStack stack = pair.block().m_7397_((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_, state);
            stack = stack.m_41619_() ? new ItemStack((ItemLike)Blocks.f_50069_) : stack;
            ingredients.add(stack);
        }
        if (recipe.getBypassBlock() == null || recipe.getBypassBlock().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredientsUnsafe(ingredients)).setCustomRenderer((IIngredientType)Services.PLATFORM.getFluidHelper().getFluidIngredientType(), new FluidStateRenderer(Services.PLATFORM.getFluidHelper())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new BlockStateRenderer(pairs));
        } else {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredientsUnsafe(ingredients)).setCustomRenderer((IIngredientType)Services.PLATFORM.getFluidHelper().getFluidIngredientType(), new FluidStateRenderer(Services.PLATFORM.getFluidHelper())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new BlockStateRenderer(pairs));
        }
        super.setRecipe(builder, recipe, focusGroup);
    }
}

