/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jei.categories.ban;

import com.aetherteam.aether.integration.jei.BlockStateRenderer;
import com.aetherteam.aether.integration.jei.FluidStateRenderer;
import com.aetherteam.aether.integration.jei.categories.AbstractAetherRecipeCategory;
import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.aetherteam.aether.recipe.BlockStateIngredient;
import com.aetherteam.aether.recipe.recipes.ban.AbstractPlacementBanRecipe;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.Translator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public abstract class AbstractPlacementBanRecipeCategory<T, S extends Predicate<T>, R extends AbstractPlacementBanRecipe<T, S>>
extends AbstractAetherRecipeCategory<R> {
    protected final IPlatformFluidHelper<?> fluidHelper;
    private final IDrawable slot;

    public AbstractPlacementBanRecipeCategory(IGuiHelper guiHelper, String id, ResourceLocation uid, IDrawable background, IDrawable icon, RecipeType<R> recipeType, IPlatformFluidHelper<?> fluidHelper) {
        super(id, uid, background, icon, recipeType);
        this.fluidHelper = fluidHelper;
        this.slot = guiHelper.getSlotDrawable();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, R recipe, IFocusGroup focusGroup) {
        BlockStateIngredient bypassBlockIngredient = ((AbstractPlacementBanRecipe)recipe).getBypassBlock();
        BlockPropertyPair[] pairs = bypassBlockIngredient.getPairs();
        ArrayList<Object> ingredients = new ArrayList<Object>();
        for (BlockPropertyPair pair : pairs) {
            Block block = pair.block();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                ingredients.add(this.fluidHelper.create((Fluid)liquidBlock.getFluid(), 1000L));
                continue;
            }
            BlockState state = pair.block().m_49966_();
            for (Map.Entry<Property<?>, Comparable<?>> propertyEntry : pair.properties().entrySet()) {
                state = BlockStateRecipeUtil.setHelper(propertyEntry, state);
            }
            ItemStack stack = pair.block().m_7397_((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_, state);
            stack = stack.m_41619_() ? new ItemStack((ItemLike)Blocks.f_50069_) : stack;
            ingredients.add(stack);
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 99, 1).addIngredientsUnsafe(ingredients)).setCustomRenderer((IIngredientType)Services.PLATFORM.getFluidHelper().getFluidIngredientType(), new FluidStateRenderer(Services.PLATFORM.getFluidHelper())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new BlockStateRenderer(pairs));
    }

    public void draw(R recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        if (((AbstractPlacementBanRecipe)recipe).getBypassBlock() == null || ((AbstractPlacementBanRecipe)recipe).getBypassBlock().isEmpty()) {
            this.slot.draw(poseStack, 49, 0);
        } else {
            this.slot.draw(poseStack);
            this.slot.draw(poseStack, 98, 0);
            String text = Translator.translateToLocalFormatted((String)"gui.aether.jei.bypass", (Object[])new Object[0]);
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            font.m_92883_(poseStack, text, 24.0f, 5.0f, -8355712);
        }
    }

    protected void populateAdditionalInformation(R recipe, List<Component> tooltip) {
        if (((AbstractPlacementBanRecipe)recipe).getBiomeKey() != null || ((AbstractPlacementBanRecipe)recipe).getBiomeTag() != null) {
            tooltip.add((Component)Component.m_237115_((String)"gui.aether.jei.biome.ban.tooltip").m_130940_(ChatFormatting.GRAY));
            if (((AbstractPlacementBanRecipe)recipe).getBiomeKey() != null) {
                tooltip.add((Component)Component.m_237115_((String)"gui.aether.jei.biome.tooltip.biome").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237113_((String)((AbstractPlacementBanRecipe)recipe).getBiomeKey().m_135782_().toString()).m_130940_(ChatFormatting.DARK_GRAY));
            } else if (((AbstractPlacementBanRecipe)recipe).getBiomeTag() != null) {
                tooltip.add((Component)Component.m_237115_((String)"gui.aether.jei.biome.tooltip.tag").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237113_((String)("#" + ((AbstractPlacementBanRecipe)recipe).getBiomeTag().f_203868_())).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"gui.aether.jei.biome.tooltip.biomes").m_130940_(ChatFormatting.DARK_GRAY));
                Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_206058_(((AbstractPlacementBanRecipe)recipe).getBiomeTag()).forEach(biomeHolder -> tooltip.add((Component)Component.m_237113_((String)((ResourceKey)biomeHolder.m_203543_().get()).m_135782_().toString()).m_130940_(ChatFormatting.DARK_GRAY)));
            }
        }
    }
}

