/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jei;

import com.aetherteam.aether.Aether;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class FluidStateRenderer<T>
implements IIngredientRenderer<T> {
    private final IPlatformFluidHelperInternal<T> fluidHelper;

    public FluidStateRenderer(IPlatformFluidHelperInternal<T> fluidHelper) {
        this.fluidHelper = fluidHelper;
    }

    public void render(PoseStack poseStack, T ingredient) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher blockRenderDispatcher = minecraft.m_91289_();
        poseStack.m_85836_();
        poseStack.m_85837_(15.0, 12.33, 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        poseStack.m_85841_(-9.9f, -9.9f, -9.9f);
        IIngredientTypeWithSubtypes type = this.fluidHelper.getFluidIngredientType();
        Fluid fluidType = (Fluid)type.getBase(ingredient);
        FluidState fluidState = fluidType.m_76145_();
        RenderType renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
        PoseStack worldStack = RenderSystem.m_157191_();
        renderType.m_110185_();
        worldStack.m_85836_();
        worldStack.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.m_157182_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(renderType.m_173186_(), renderType.m_110508_());
        blockRenderDispatcher.m_234363_(BlockPos.f_121853_, (BlockAndTintGetter)new FakeWorld(fluidState), (VertexConsumer)builder, fluidState.m_76188_(), fluidState);
        if (builder.m_85732_()) {
            tesselator.m_85914_();
        }
        renderType.m_110188_();
        worldStack.m_85849_();
        RenderSystem.m_157182_();
        poseStack.m_85849_();
    }

    public List<Component> getTooltip(T ingredient, TooltipFlag tooltipFlag) {
        try {
            return this.fluidHelper.getTooltip(ingredient, tooltipFlag);
        }
        catch (LinkageError | RuntimeException e) {
            Component displayName = this.fluidHelper.getDisplayName(ingredient);
            Aether.LOGGER.error("Failed to get tooltip for fluid: " + displayName, e);
            return new ArrayList<Component>();
        }
    }

    private static class FakeWorld
    implements BlockAndTintGetter {
        private final FluidState fluidState;

        public FakeWorld(FluidState fluidState) {
            this.fluidState = fluidState;
        }

        public float m_7717_(Direction direction, boolean bl) {
            return 1.0f;
        }

        public LevelLightEngine m_5518_() {
            throw new UnsupportedOperationException();
        }

        public int m_45517_(LightLayer lightLayer, BlockPos pos) {
            return 15;
        }

        public int m_45524_(BlockPos pos, int i) {
            return 15;
        }

        public int m_6171_(BlockPos pos, ColorResolver colorResolver) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                Holder biome = Minecraft.m_91087_().f_91073_.m_204166_(pos);
                return colorResolver.m_130045_((Biome)biome.m_203334_(), 0.0, 0.0);
            }
            return -1;
        }

        public BlockEntity m_7702_(BlockPos pos) {
            return null;
        }

        public BlockState m_8055_(BlockPos pos) {
            if (pos.equals((Object)BlockPos.f_121853_)) {
                return this.fluidState.m_76188_();
            }
            return Blocks.f_50016_.m_49966_();
        }

        public FluidState m_6425_(BlockPos pos) {
            if (pos.equals((Object)BlockPos.f_121853_)) {
                return this.fluidState;
            }
            return Fluids.f_76191_.m_76145_();
        }

        public int m_141928_() {
            return 0;
        }

        public int m_141937_() {
            return 0;
        }
    }
}

