/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jei;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BlockStateRenderer
implements IIngredientRenderer<ItemStack> {
    private final BlockPropertyPair[] pairs;

    public BlockStateRenderer(BlockPropertyPair ... pairs) {
        this.pairs = pairs;
    }

    public void render(PoseStack poseStack, @Nullable ItemStack ingredient) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher blockRenderDispatcher = minecraft.m_91289_();
        BlockPropertyPair pair = this.getMatchingPair(ingredient);
        if (pair.block() != null && pair.properties() != null) {
            BlockState blockState = pair.block().m_49966_();
            for (Map.Entry<Property<?>, Comparable<?>> propertyEntry : pair.properties().entrySet()) {
                blockState = BlockStateRecipeUtil.setHelper(propertyEntry, blockState);
            }
            poseStack.m_85836_();
            poseStack.m_85837_(15.0, 12.33, 5.0);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            poseStack.m_85841_(-9.9f, -9.9f, -9.9f);
            RenderSystem.m_253114_((Vector3f)new Vector3f(0.4f, 0.0f, 1.0f).normalize(), (Vector3f)new Vector3f(-0.4f, 1.0f, -0.2f).normalize());
            ModelBlockRenderer modelBlockRenderer = blockRenderDispatcher.m_110937_();
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            BakedModel model = blockRenderDispatcher.m_110910_(blockState);
            RenderType renderType = (RenderType)model.getRenderTypes(blockState, minecraft.f_91073_.m_213780_(), ModelData.EMPTY).asList().get(0);
            modelBlockRenderer.tesselateBlock((BlockAndTintGetter)new FakeWorld(blockState), model, blockState, BlockPos.f_121853_, poseStack, bufferSource.m_6299_(Sheets.m_110792_()), false, minecraft.f_91073_.m_213780_(), 0xF000F0L, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
            bufferSource.m_109911_();
            Lighting.m_84931_();
            poseStack.m_85849_();
        }
    }

    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        try {
            BlockPropertyPair pair = this.getMatchingPair(ingredient);
            Block block = pair.block();
            Map<Property<?>, Comparable<?>> properties = pair.properties();
            ArrayList list = Lists.newArrayList();
            MutableComponent mutablecomponent = Component.m_237119_().m_7220_((Component)block.m_49954_()).m_130938_(ingredient.m_41791_().getStyleModifier());
            list.add(mutablecomponent);
            if (tooltipFlag.m_7050_()) {
                list.add(Component.m_237113_((String)BuiltInRegistries.f_256975_.m_7981_((Object)block).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (player != null && !ingredient.m_41720_().m_245993_(player.m_9236_().m_246046_())) {
                list.add(Component.m_237115_((String)"item.disabled").m_130940_(ChatFormatting.RED));
            }
            if (!properties.isEmpty()) {
                list.add(Component.m_237115_((String)"gui.aether.jei.properties.tooltip").m_130940_(ChatFormatting.GRAY));
                for (Map.Entry<Property<?>, Comparable<?>> entry : properties.entrySet()) {
                    list.add(Component.m_237113_((String)(entry.getKey().m_61708_() + ": " + entry.getValue().toString())).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
            return list;
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo((ItemStack)ingredient);
            Aether.LOGGER.error("Failed to get tooltip: {}", (Object)itemStackInfo, (Object)e);
            ArrayList<Component> list = new ArrayList<Component>();
            MutableComponent crash = Component.m_237115_((String)"jei.tooltip.error.crash");
            list.add((Component)crash.m_130940_(ChatFormatting.RED));
            return list;
        }
    }

    public Font getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getFontRenderer(minecraft, ingredient);
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    private BlockPropertyPair getMatchingPair(ItemStack ingredient) {
        Map<Block, Map> pairsMap = Stream.of(this.pairs).collect(Collectors.toMap(BlockPropertyPair::block, BlockPropertyPair::properties));
        Block block = null;
        Map propertiesMap = null;
        for (Map.Entry<Block, Map> entry : pairsMap.entrySet()) {
            ItemStack stack = entry.getKey().m_7397_((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_, entry.getKey().m_49966_());
            stack = stack.m_41619_() ? new ItemStack((ItemLike)Blocks.f_50069_) : stack;
            if (stack.m_41720_() != ingredient.m_41720_()) continue;
            block = entry.getKey();
            propertiesMap = entry.getValue();
        }
        return BlockPropertyPair.of(block, propertiesMap);
    }

    private static class FakeWorld
    implements BlockAndTintGetter {
        private final BlockState blockState;

        public FakeWorld(BlockState blockState) {
            this.blockState = blockState;
        }

        public float m_7717_(Direction direction, boolean bl) {
            return 1.0f;
        }

        public LevelLightEngine m_5518_() {
            throw new UnsupportedOperationException();
        }

        public int m_45517_(LightLayer lightLayer, BlockPos pos) {
            return 15;
        }

        public int m_45524_(BlockPos pos, int i) {
            return 15;
        }

        public int m_6171_(BlockPos pos, ColorResolver colorResolver) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                Holder biome = Minecraft.m_91087_().f_91073_.m_204166_(pos);
                return colorResolver.m_130045_((Biome)biome.m_203334_(), 0.0, 0.0);
            }
            return -1;
        }

        public BlockEntity m_7702_(BlockPos pos) {
            return null;
        }

        public BlockState m_8055_(BlockPos pos) {
            if (pos.equals((Object)BlockPos.f_121853_)) {
                return this.blockState;
            }
            return Blocks.f_50016_.m_49966_();
        }

        public FluidState m_6425_(BlockPos pos) {
            return Fluids.f_76191_.m_76145_();
        }

        public int m_141928_() {
            return 0;
        }

        public int m_141937_() {
            return 0;
        }
    }
}

