/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jade;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import com.aetherteam.aether.block.dungeon.TrappedBlock;
import com.aetherteam.aether.block.dungeon.TreasureDoorwayBlock;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;

@WailaPlugin
public class AetherJadePlugin
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.addRayTraceCallback(this::registerAetherOverrides);
    }

    @Nullable
    public Accessor<?> registerAetherOverrides(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor target = (BlockAccessor)accessor;
            Player player = accessor.getPlayer();
            if (player.m_7500_() || player.m_5833_()) {
                return accessor;
            }
            IWailaClientRegistration client = VanillaPlugin.CLIENT_REGISTRATION;
            Block block = target.getBlock();
            if (block instanceof TrappedBlock) {
                TrappedBlock trapped = (TrappedBlock)block;
                return client.blockAccessor().from(target).blockState(trapped.getFacadeBlock()).build();
            }
            block = target.getBlock();
            if (block instanceof DoorwayBlock) {
                DoorwayBlock door = (DoorwayBlock)block;
                return client.blockAccessor().from(target).blockState(this.getLockedDungeonBlock(ForgeRegistries.BLOCKS.getKey((Object)door).m_135815_()).m_49966_()).build();
            }
            block = target.getBlock();
            if (block instanceof TreasureDoorwayBlock) {
                TreasureDoorwayBlock door = (TreasureDoorwayBlock)block;
                return client.blockAccessor().from(target).blockState(this.getLockedDungeonBlock(ForgeRegistries.BLOCKS.getKey((Object)door).m_135815_()).m_49966_()).build();
            }
            if (target.getBlock() == AetherBlocks.CHEST_MIMIC.get()) {
                return client.blockAccessor().from(target).serverData(this.createFakeChestData(target)).blockState(Blocks.f_50087_.m_49966_()).build();
            }
        }
        return accessor;
    }

    private CompoundTag createFakeChestData(BlockAccessor target) {
        CompoundTag tag = new CompoundTag();
        if (!target.getServerData().m_128456_()) {
            tag.m_128379_("Loot", true);
        }
        return tag;
    }

    @Nullable
    private Block getLockedDungeonBlock(String name) {
        if (name.startsWith("boss_doorway_")) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("aether", "locked_" + name.substring(13)));
        }
        if (name.startsWith("treasure_doorway_")) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("aether", "locked_" + name.substring(17)));
        }
        return null;
    }
}

