/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners;

import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.event.events.PlacementBanEvent;
import com.aetherteam.aether.event.events.PlacementConvertEvent;
import com.aetherteam.aether.event.hooks.DimensionHooks;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerLevelAccessor;
import com.aetherteam.aether.world.AetherLevelData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DimensionListener {
    @SubscribeEvent
    public static void onInteractWithPortalFrame(PlayerInteractEvent.RightClickBlock event) {
        InteractionHand interactionHand;
        ItemStack itemStack;
        Direction direction;
        BlockPos blockPos;
        Level level;
        Player player = event.getEntity();
        if (DimensionHooks.createPortal(player, level = event.getLevel(), blockPos = event.getPos(), direction = event.getFace(), itemStack = event.getItemStack(), interactionHand = event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWaterExistsInsidePortalFrame(BlockEvent.NeighborNotifyEvent event) {
        FluidState fluidState;
        BlockState blockState;
        BlockPos blockPos;
        LevelAccessor level = event.getLevel();
        if (DimensionHooks.detectWaterInFrame(level, blockPos = event.getPos(), blockState = level.m_8055_(blockPos), fluidState = level.m_6425_(blockPos))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void checkBanned(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos blockPos = event.getPos();
        Direction direction = event.getFace();
        InteractionHand interactionHand = event.getHand();
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_41619_()) {
            itemStack = player.m_21120_(interactionHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        }
        BlockState blockState = level.m_8055_(blockPos);
        event.setCanceled(DimensionHooks.checkInteractionBanned(player, level, blockPos, direction, itemStack, blockState, !player.m_21120_(interactionHand).m_41619_()));
    }

    @SubscribeEvent
    public static void onNeighborNotified(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        BlockPos blockPos = event.getPos();
        DimensionHooks.checkExistenceBanned(levelAccessor, blockPos);
        DimensionHooks.sendIcestoneFreezableUpdateEvent(levelAccessor, blockPos);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConvert(PlacementConvertEvent event) {
        LevelAccessor levelAccessor = event.getWorld();
        BlockPos blockPos = event.getPos();
        if (!event.isCanceled()) {
            DimensionHooks.banOrConvert(levelAccessor, blockPos);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBanned(PlacementBanEvent.SpawnParticles event) {
        LevelAccessor levelAccessor = event.getWorld();
        BlockPos blockPos = event.getPos();
        if (!event.isCanceled()) {
            DimensionHooks.banOrConvert(levelAccessor, blockPos);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            DimensionHooks.tickTime(level);
            DimensionHooks.fallFromAether(level);
            DimensionHooks.checkEternalDayConfig(level);
        }
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        ResourceKey dimension = event.getDimension();
        DimensionHooks.dimensionTravel(entity, (ResourceKey<Level>)dimension);
    }

    @SubscribeEvent
    public static void onPlayerTraveling(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        DimensionHooks.travelling(player);
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_())) {
            AetherTime.get((Level)level).ifPresent(cap -> {
                AetherLevelData levelData = new AetherLevelData(level.m_7654_().m_129910_(), level.m_7654_().m_129910_().m_5996_(), cap.getDayTime());
                ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
                com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor levelAccessor = (com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor)event.getLevel();
                serverLevelAccessor.aether$setServerLevelData((ServerLevelData)levelData);
                levelAccessor.aether$setLevelData((WritableLevelData)levelData);
            });
        }
    }

    @SubscribeEvent
    public static void onSleepFinish(SleepFinishedTimeEvent event) {
        ServerLevel level = (ServerLevel)event.getLevel();
        if (level.m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_())) {
            long time = event.getNewTime() + 48000L;
            event.setTimeAddition(time - time % 72000L);
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
            serverLevelAccessor.aether$getServerLevelData().m_6399_(0);
            serverLevelAccessor.aether$getServerLevelData().m_5565_(false);
            serverLevelAccessor.aether$getServerLevelData().m_6398_(0);
            serverLevelAccessor.aether$getServerLevelData().m_5557_(false);
        }
    }

    @SubscribeEvent
    public static void onTriedToSleep(SleepingTimeCheckEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_())) {
            AetherTime.get(player.m_9236_()).ifPresent(aetherTime -> {
                if (aetherTime.getEternalDay()) {
                    event.setResult(Event.Result.DENY);
                }
            });
        }
    }
}

