/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.capability.item.DroppedItem;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.ai.goal.BeeGrowBerryBushGoal;
import com.aetherteam.aether.entity.ai.goal.FoxEatBerryBushGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.Slider;
import com.aetherteam.aether.entity.passive.FlyingCow;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.miscellaneous.bucket.SkyrootBucketItem;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityHooks {
    public static void addGoals(Entity entity) {
        if (entity.getClass() == Bee.class) {
            Bee bee = (Bee)entity;
            bee.f_21345_.m_25352_(7, (Goal)new BeeGrowBerryBushGoal(bee));
        } else if (entity.getClass() == Fox.class) {
            Fox fox = (Fox)entity;
            fox.f_21345_.m_25352_(10, (Goal)new FoxEatBerryBushGoal(fox, 1.2f, 12, 1));
        }
    }

    public static void launchMount(Player player) {
        Entity mount = player.m_20202_();
        if (player.m_20159_() && mount != null && mount.m_9236_().m_45556_(mount.m_20191_()).anyMatch(state -> state.m_60713_((Block)AetherBlocks.BLUE_AERCLOUD.get())) && player.m_9236_().m_5776_()) {
            mount.m_20334_(mount.m_20184_().m_7096_(), 2.0, mount.m_20184_().m_7094_());
        }
    }

    public static void skyrootBucketMilking(Entity target, Player player, InteractionHand hand) {
        ItemStack heldStack;
        if ((target instanceof Cow || target instanceof FlyingCow) && !((Animal)target).m_6162_() && (heldStack = player.m_21120_(hand)).m_150930_((Item)AetherItems.SKYROOT_BUCKET.get())) {
            if (target instanceof FlyingCow) {
                player.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_FLYING_COW_MILK.get(), 1.0f, 1.0f);
            } else {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            }
            ItemStack filledBucket = ItemUtils.m_41813_((ItemStack)heldStack, (Player)player, (ItemStack)((Item)AetherItems.SKYROOT_MILK_BUCKET.get()).m_7968_());
            player.m_6674_(hand);
            player.m_21008_(hand, filledBucket);
        }
    }

    public static Optional<InteractionResult> pickupBucketable(Entity target, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        Optional<InteractionResult> interactionResult = Optional.empty();
        if (heldStack.m_150930_((Item)AetherItems.SKYROOT_WATER_BUCKET.get()) && target instanceof Bucketable) {
            LivingEntity livingEntity;
            Bucketable bucketable = (Bucketable)target;
            if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).m_6084_()) {
                ItemStack bucketStack = bucketable.m_28282_();
                if (!(bucketStack = SkyrootBucketItem.swapBucketType(bucketStack)).m_41619_()) {
                    target.m_5496_(bucketable.m_142623_(), 1.0f, 1.0f);
                    bucketable.m_6872_(bucketStack);
                    ItemStack filledStack = ItemUtils.m_41817_((ItemStack)heldStack, (Player)player, (ItemStack)bucketStack, (boolean)false);
                    player.m_21008_(hand, filledStack);
                    Level level = livingEntity.m_9236_();
                    if (!level.m_5776_()) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketStack);
                    }
                    target.m_146870_();
                    interactionResult = Optional.of(InteractionResult.m_19078_((boolean)level.m_5776_()));
                } else {
                    interactionResult = Optional.of(InteractionResult.FAIL);
                }
            }
        }
        return interactionResult;
    }

    public static boolean preventEntityHooked(Entity projectileEntity, HitResult rayTraceResult) {
        if (rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
            return entityHitResult.m_82443_().m_6095_().m_204039_(AetherTags.Entities.UNHOOKABLE) && projectileEntity instanceof FishingHook;
        }
        return false;
    }

    public static boolean preventSliderShieldBlock(DamageSource source) {
        return source.m_7639_() instanceof Slider;
    }

    public static boolean lightningHitKeys(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return itemEntity.m_32055_().m_204117_(AetherTags.Items.DUNGEON_KEYS);
        }
        return false;
    }

    public static void trackDrops(LivingEntity entity, Collection<ItemEntity> itemDrops) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            itemDrops.forEach(itemEntity -> DroppedItem.get(itemEntity).ifPresent(droppedItem -> droppedItem.setOwner((Entity)player)));
        }
    }
}

