/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.FreezingBlock;
import com.aetherteam.aether.block.portal.AetherPortalForcer;
import com.aetherteam.aether.block.portal.AetherPortalShape;
import com.aetherteam.aether.capability.item.DroppedItem;
import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.event.AetherGameEvents;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerLevelAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.AetherTravelPacket;
import com.aetherteam.aether.network.packet.client.LeavingAetherPacket;
import com.aetherteam.aether.network.packet.client.SetVehiclePacket;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.ban.BlockBanRecipe;
import com.aetherteam.aether.recipe.recipes.ban.ItemBanRecipe;
import com.aetherteam.aether.recipe.recipes.block.PlacementConversionRecipe;
import com.aetherteam.aether.util.LevelUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;

public class DimensionHooks {
    public static boolean playerLeavingAether;
    public static boolean displayAetherTravel;
    public static int teleportationTimer;

    public static boolean createPortal(Player player, Level level, BlockPos pos, Direction direction, ItemStack stack, InteractionHand hand) {
        if (direction != null) {
            Optional<AetherPortalShape> optional;
            BlockPos relativePos = pos.m_121945_(direction);
            if (stack.m_204117_(AetherTags.Items.AETHER_PORTAL_ACTIVATION_ITEMS) && (level.m_46472_() == LevelUtil.returnDimension() || level.m_46472_() == LevelUtil.destinationDimension()) && !((Boolean)AetherConfig.SERVER.disable_aether_portal.get()).booleanValue() && (optional = AetherPortalShape.findEmptyAetherPortalShape((LevelAccessor)level, relativePos, Direction.Axis.X)).isPresent()) {
                optional.get().createPortalBlocks();
                player.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
                player.m_6674_(hand);
                if (!player.m_7500_()) {
                    if (stack.m_41613_() > 1) {
                        stack.m_41774_(1);
                        player.m_36356_(stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.f_41583_);
                    } else if (stack.m_41763_()) {
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    } else {
                        player.m_21008_(hand, stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.f_41583_);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static boolean detectWaterInFrame(LevelAccessor levelAccessor, BlockPos pos, BlockState blockState, FluidState fluidState) {
        if (levelAccessor instanceof Level) {
            Optional<AetherPortalShape> optional;
            Level level = (Level)levelAccessor;
            if (fluidState.m_192917_((Fluid)Fluids.f_76193_) && fluidState.m_76188_().m_60734_() == blockState.m_60734_() && (level.m_46472_() == LevelUtil.returnDimension() || level.m_46472_() == LevelUtil.destinationDimension()) && !((Boolean)AetherConfig.SERVER.disable_aether_portal.get()).booleanValue() && (optional = AetherPortalShape.findEmptyAetherPortalShape((LevelAccessor)level, pos, Direction.Axis.X)).isPresent()) {
                optional.get().createPortalBlocks();
                return true;
            }
        }
        return false;
    }

    public static boolean checkInteractionBanned(Player player, Level level, BlockPos pos, Direction face, ItemStack stack, BlockState state, boolean spawnParticles) {
        if (DimensionHooks.isItemPlacementBanned(level, pos, face, stack, spawnParticles)) {
            return true;
        }
        if (level.m_204166_(pos).m_203656_(AetherTags.Biomes.ULTRACOLD) && ((Boolean)AetherConfig.SERVER.enable_bed_explosions.get()).booleanValue() && state.m_204336_(BlockTags.f_13038_) && state.m_60734_() != AetherBlocks.SKYROOT_BED.get()) {
            if (!level.m_5776_()) {
                BlockPos blockpos;
                if (state.m_61143_((Property)BedBlock.f_49440_) != BedPart.HEAD) {
                    pos = pos.m_121945_((Direction)state.m_61143_((Property)BedBlock.f_54117_));
                    state = level.m_8055_(pos);
                }
                if (level.m_8055_(blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122424_())).m_204336_(BlockTags.f_13038_) && level.m_8055_(blockpos).m_60734_() != AetherBlocks.SKYROOT_BED.get()) {
                    level.m_7471_(blockpos, false);
                }
                Vec3 vec3 = pos.m_252807_();
                level.m_254877_(null, level.m_269111_().m_269488_(vec3), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            return true;
        }
        return false;
    }

    public static boolean isItemPlacementBanned(Level level, BlockPos pos, Direction face, ItemStack stack, boolean spawnParticles) {
        for (Recipe recipe : level.m_7465_().m_44013_((RecipeType)AetherRecipeTypes.ITEM_PLACEMENT_BAN.get())) {
            ItemBanRecipe banRecipe;
            if (!(recipe instanceof ItemBanRecipe) || !(banRecipe = (ItemBanRecipe)recipe).banItem(level, pos, face, stack, spawnParticles)) continue;
            return true;
        }
        return false;
    }

    public static void checkExistenceBanned(LevelAccessor levelAccessor, BlockPos pos) {
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            BlockState state = levelAccessor.m_8055_(pos);
            if (DimensionHooks.isBlockPlacementBanned(level, pos, state)) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                if (state.m_60734_().m_5456_() != Items.f_41852_) {
                    Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
                }
            } else {
                DimensionHooks.isBlockPlacementConvertable(level, pos, state);
            }
        }
    }

    private static boolean isBlockPlacementBanned(Level level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            for (Recipe recipe : level.m_7465_().m_44013_((RecipeType)AetherRecipeTypes.BLOCK_PLACEMENT_BAN.get())) {
                BlockBanRecipe banRecipe;
                if (!(recipe instanceof BlockBanRecipe) || !(banRecipe = (BlockBanRecipe)recipe).banBlock(level, pos, state)) continue;
                return true;
            }
        }
        return false;
    }

    private static void isBlockPlacementConvertable(Level level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            for (Recipe recipe : level.m_7465_().m_44013_((RecipeType)AetherRecipeTypes.PLACEMENT_CONVERSION.get())) {
                PlacementConversionRecipe conversionRecipe;
                if (!(recipe instanceof PlacementConversionRecipe) || !(conversionRecipe = (PlacementConversionRecipe)recipe).convert(level, pos, state)) continue;
                return;
            }
        }
    }

    public static void banOrConvert(LevelAccessor accessor, BlockPos pos) {
        if (accessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)accessor;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5;
            for (int i = 0; i < 10; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            serverLevel.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void tickTime(Level level) {
        if (level.m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_()) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)serverLevel;
            com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor levelAccessor = (com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor)level;
            long i = levelAccessor.aether$getLevelData().m_6793_() + 1L;
            serverLevelAccessor.aether$getServerLevelData().m_6253_(i);
            if (serverLevelAccessor.aether$getServerLevelData().m_5470_().m_46207_(GameRules.f_46140_)) {
                AetherTime.get(level).ifPresent(cap -> serverLevel.m_8615_(cap.tickTime(level)));
            }
        }
    }

    public static void fallFromAether(Level level) {
        block3: {
            if (!(level instanceof ServerLevel)) break block3;
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)AetherConfig.SERVER.disable_falling_to_overworld.get()).booleanValue()) break block3;
            for (Entity entity : serverLevel.m_143280_(EntityTypeTest.m_156916_(Entity.class), Objects::nonNull)) {
                ItemEntity itemEntity;
                LazyOptional<DroppedItem> droppedItem;
                block6: {
                    block5: {
                        block4: {
                            if (!level.m_204166_(entity.m_20183_()).m_203656_(AetherTags.Biomes.FALL_TO_OVERWORLD) || level.m_46472_() != LevelUtil.destinationDimension() || !(entity.m_20186_() <= (double)serverLevel.m_141937_()) || entity.m_20159_()) continue;
                            if (!(entity instanceof Player)) break block4;
                            Player player = (Player)entity;
                            if (!player.m_150110_().f_35935_) break block5;
                        }
                        if (!entity.m_20160_() && (!(entity instanceof Saddleable) || !((Saddleable)entity).m_6254_())) break block6;
                    }
                    DimensionHooks.entityFell(entity);
                    continue;
                }
                if (!(entity instanceof ItemEntity) || !(droppedItem = DroppedItem.get(itemEntity = (ItemEntity)entity)).isPresent() || !droppedItem.resolve().isPresent() || !(itemEntity.m_19749_() instanceof Player) && !(((DroppedItem)droppedItem.resolve().get()).getOwner() instanceof Player)) continue;
                DimensionHooks.entityFell(entity);
            }
        }
    }

    @Nullable
    private static Entity entityFell(Entity entity) {
        ServerLevel destination;
        Level serverLevel = entity.f_19853_;
        MinecraftServer minecraftserver = serverLevel.m_7654_();
        if (minecraftserver != null && (destination = minecraftserver.m_129880_(LevelUtil.returnDimension())) != null && LevelUtil.returnDimension() != LevelUtil.destinationDimension()) {
            List passengers = entity.m_20197_();
            entity.f_19853_.m_46473_().m_6180_("aether_fall");
            entity.m_20091_();
            Entity target = entity.changeDimension(destination, (ITeleporter)new AetherPortalForcer(destination, false));
            entity.f_19853_.m_46473_().m_7238_();
            if (target != null) {
                for (Entity passenger : passengers) {
                    passenger.m_8127_();
                    Entity nextPassenger = DimensionHooks.entityFell(passenger);
                    if (nextPassenger == null) continue;
                    nextPassenger.m_20329_(target);
                    if (!(target instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)target;
                    AetherPacketHandler.sendToPlayer(new SetVehiclePacket(nextPassenger.m_19879_(), target.m_19879_()), serverPlayer);
                }
                if (target instanceof ServerPlayer) {
                    teleportationTimer = 500;
                }
            }
            return target;
        }
        return null;
    }

    public static void checkEternalDayConfig(Level level) {
        if (!level.m_5776_()) {
            AetherTime.get(level).ifPresent(aetherTime -> {
                boolean eternalDay = aetherTime.getEternalDay();
                if (((Boolean)AetherConfig.SERVER.disable_eternal_day.get()).booleanValue() && eternalDay) {
                    aetherTime.setEternalDay(false);
                    aetherTime.updateEternalDay();
                }
            });
        }
    }

    public static void dimensionTravel(Entity entity, ResourceKey<Level> dimension) {
        if (entity.f_19853_.m_204166_(entity.m_20183_()).m_203656_(AetherTags.Biomes.DISPLAY_TRAVEL_TEXT)) {
            if (entity.f_19853_.m_46472_() == LevelUtil.destinationDimension() && dimension == LevelUtil.returnDimension()) {
                displayAetherTravel = true;
                playerLeavingAether = true;
                AetherPacketHandler.sendToAll(new AetherTravelPacket(true));
                AetherPacketHandler.sendToAll(new LeavingAetherPacket(true));
            } else if (entity.f_19853_.m_46472_() == LevelUtil.returnDimension() && dimension == LevelUtil.destinationDimension()) {
                displayAetherTravel = true;
                playerLeavingAether = false;
                AetherPacketHandler.sendToAll(new AetherTravelPacket(true));
                AetherPacketHandler.sendToAll(new LeavingAetherPacket(false));
            } else {
                displayAetherTravel = false;
                AetherPacketHandler.sendToAll(new AetherTravelPacket(false));
            }
        }
    }

    public static void travelling(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (teleportationTimer > 0) {
                ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_;
                serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                serverGamePacketListenerImplAccessor.aether$setAboveGroundVehicleTickCount(0);
                --teleportationTimer;
            }
            if (teleportationTimer < 0 || serverPlayer.f_201939_) {
                teleportationTimer = 0;
            }
        }
    }

    public static void sendIcestoneFreezableUpdateEvent(LevelAccessor accessor, BlockPos pos) {
        Level level;
        if (accessor instanceof Level && !(level = (Level)accessor).m_5776_()) {
            BlockState oldBlockState = level.m_8055_(pos);
            FreezingBlock.cacheRecipes(level);
            if (FreezingBlock.matchesCache(oldBlockState.m_60734_(), oldBlockState) != null) {
                level.m_142346_(null, (GameEvent)AetherGameEvents.ICESTONE_FREEZABLE_UPDATE.get(), pos);
            }
        }
    }
}

