/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.api.CustomizationsOptions;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.capability.player.AetherPlayerCapability;
import com.aetherteam.aether.capability.rankings.AetherRankings;
import com.aetherteam.aether.capability.rankings.AetherRankingsCapability;
import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.server.RankingsForcePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class CapabilityHooks {

    public static class AetherTimeHooks {
        public static void login(Player player) {
            AetherTimeHooks.syncAetherTime(player);
        }

        public static void changeDimension(Player player) {
            AetherTimeHooks.syncAetherTime(player);
        }

        public static void respawn(Player player) {
            AetherTimeHooks.syncAetherTime(player);
        }

        private static void syncAetherTime(Player player) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (player.f_19853_.m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_())) {
                    AetherTime.get(serverPlayer.f_19853_).ifPresent(cap -> cap.updateEternalDay(serverPlayer));
                }
            }
        }
    }

    public static class AetherRankingsHooks {
        public static void join(Entity entity) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.f_19853_.m_5776_()) {
                    CustomizationsOptions.INSTANCE.load();
                    CustomizationsOptions.INSTANCE.sync();
                    AetherPacketHandler.sendToServer(new RankingsForcePacket(player.m_19879_()));
                }
            }
        }

        public static void update(LivingEntity entity) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                AetherRankings.get(player).ifPresent(AetherRankings::onUpdate);
            }
        }

        public static void clone(Player originalPlayer, Player newPlayer) {
            originalPlayer.reviveCaps();
            AetherRankings originalAetherRankings = (AetherRankings)AetherRankings.get(originalPlayer).orElseThrow(() -> new IllegalStateException("Player " + originalPlayer.m_7755_().m_214077_() + " has no AetherRankings capability!"));
            AetherRankings newAetherRankings = (AetherRankings)AetherRankings.get(newPlayer).orElseThrow(() -> new IllegalStateException("Player " + newPlayer.m_7755_().m_214077_() + " has no AetherRankings capability!"));
            newAetherRankings.copyFrom(originalAetherRankings);
            originalPlayer.invalidateCaps();
        }

        public static void changeDimension(Player player) {
            if (!player.f_19853_.m_5776_()) {
                AetherRankings.get(player).ifPresent(aetherRankings -> {
                    if (aetherRankings instanceof AetherRankingsCapability) {
                        AetherRankingsCapability capability = (AetherRankingsCapability)aetherRankings;
                        capability.markForced(true);
                        capability.updateSyncableNBTFromServer(player.f_19853_);
                    }
                });
            }
        }
    }

    public static class AetherPlayerHooks {
        public static void login(Player player) {
            AetherPlayer.get(player).ifPresent(AetherPlayer::onLogin);
        }

        public static void logout(Player player) {
            AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                aetherPlayer.onLogout();
                AttributeInstance health = player.m_21051_(Attributes.f_22276_);
                if (health != null && health.m_22109_(aetherPlayer.getLifeShardHealthAttributeModifier())) {
                    aetherPlayer.setSavedHealth(player.m_21223_());
                }
            });
        }

        public static void update(LivingEntity entity) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                AetherPlayer.get(player).ifPresent(AetherPlayer::onUpdate);
            }
        }

        public static void clone(Player originalPlayer, Player newPlayer, boolean wasDeath) {
            originalPlayer.reviveCaps();
            AetherPlayer originalAetherPlayer = (AetherPlayer)AetherPlayer.get(originalPlayer).orElseThrow(() -> new IllegalStateException("Player " + originalPlayer.m_7755_().m_214077_() + " has no AetherPlayer capability!"));
            AetherPlayer newAetherPlayer = (AetherPlayer)AetherPlayer.get(newPlayer).orElseThrow(() -> new IllegalStateException("Player " + newPlayer.m_7755_().m_214077_() + " has no AetherPlayer capability!"));
            newAetherPlayer.copyFrom(originalAetherPlayer, wasDeath);
            if (!wasDeath) {
                newAetherPlayer.setSavedHealth(originalAetherPlayer.getPlayer().m_21223_());
            } else {
                newAetherPlayer.setSavedHealth(1024.0f);
            }
            originalPlayer.invalidateCaps();
        }

        public static void changeDimension(Player player) {
            if (!player.f_19853_.m_5776_()) {
                AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                    if (aetherPlayer instanceof AetherPlayerCapability) {
                        AetherPlayerCapability capability = (AetherPlayerCapability)aetherPlayer;
                        capability.markForced(true);
                        capability.updateSyncableNBTFromServer(player.f_19853_);
                    }
                });
            }
        }
    }
}

