/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.capability.arrow.PhoenixArrow;
import com.aetherteam.aether.capability.lightning.LightningTracker;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.entity.projectile.PoisonNeedle;
import com.aetherteam.aether.entity.projectile.dart.EnchantedDart;
import com.aetherteam.aether.entity.projectile.dart.GoldenDart;
import com.aetherteam.aether.entity.projectile.dart.PoisonDart;
import com.aetherteam.aether.item.accessories.abilities.ZaniteAccessory;
import com.aetherteam.aether.item.tools.abilities.HolystoneTool;
import com.aetherteam.aether.item.tools.abilities.ValkyrieTool;
import com.aetherteam.aether.item.tools.abilities.ZaniteTool;
import com.aetherteam.aether.loot.AetherLoot;
import com.aetherteam.aether.loot.AetherLootContexts;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.ToolDebuffPacket;
import com.aetherteam.aether.util.EquipmentUtil;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class AbilityHooks {

    public static class WeaponHooks {
        public static void stickDart(LivingEntity entity, DamageSource source) {
            Player player;
            if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
                Entity sourceEntity = source.m_7640_();
                if (sourceEntity instanceof GoldenDart) {
                    AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setGoldenDartCount(aetherPlayer.getGoldenDartCount() + 1));
                } else if (sourceEntity instanceof PoisonDart || sourceEntity instanceof PoisonNeedle) {
                    AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setPoisonDartCount(aetherPlayer.getPoisonDartCount() + 1));
                } else if (sourceEntity instanceof EnchantedDart) {
                    AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setEnchantedDartCount(aetherPlayer.getEnchantedDartCount() + 1));
                }
            }
        }

        public static void phoenixArrowHit(HitResult result, Projectile projectile) {
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                if (projectile instanceof AbstractArrow) {
                    AbstractArrow abstractArrow = (AbstractArrow)projectile;
                    Entity impactedEntity = entityHitResult.m_82443_();
                    if (impactedEntity.m_6095_() == EntityType.f_20566_) {
                        return;
                    }
                    PhoenixArrow.get(abstractArrow).ifPresent(phoenixArrow -> {
                        if (phoenixArrow.isPhoenixArrow() && phoenixArrow.getFireTime() > 0) {
                            impactedEntity.m_20254_(phoenixArrow.getFireTime());
                        }
                    });
                }
            }
        }

        public static boolean lightningTracking(Entity entity, LightningBolt lightning) {
            if (entity instanceof LivingEntity) {
                LightningTracker lightningTracker;
                LivingEntity livingEntity = (LivingEntity)entity;
                Optional lightningTrackerOptional = LightningTracker.get(lightning).resolve();
                if (lightningTrackerOptional.isPresent() && (lightningTracker = (LightningTracker)lightningTrackerOptional.get()).getOwner() != null) {
                    return livingEntity == lightningTracker.getOwner() || livingEntity == lightningTracker.getOwner().m_20202_();
                }
            }
            return false;
        }

        public static float reduceWeaponEffectiveness(LivingEntity target, Entity source, float damage) {
            if (((Boolean)AetherConfig.SERVER.tools_debuff.get()).booleanValue() && !target.m_9236_().m_5776_()) {
                AbstractArrow abstractArrow;
                if (source instanceof LivingEntity) {
                    double value;
                    LivingEntity livingEntity = (LivingEntity)source;
                    ItemStack stack = livingEntity.m_21205_();
                    if (!(!target.m_6095_().m_20675_().startsWith("entity.aether") && !target.m_6095_().m_204039_(AetherTags.Entities.TREATED_AS_AETHER_ENTITY) || target.m_6095_().m_204039_(AetherTags.Entities.TREATED_AS_VANILLA_ENTITY) || stack.m_41619_() || stack.m_41638_(EquipmentSlot.MAINHAND).isEmpty() || stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).isEmpty() || !((value = stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().mapToDouble(AttributeModifier::m_22218_).sum()) > livingEntity.m_21172_(Attributes.f_22281_)) || stack.m_41720_().m_5524_().startsWith("item.aether.") || stack.m_204117_(AetherTags.Items.TREATED_AS_AETHER_ITEM))) {
                        damage = (float)Math.pow(damage, 0.5);
                    }
                } else if (!(!(source instanceof Projectile) || !target.m_6095_().m_20675_().startsWith("entity.aether") && !target.m_6095_().m_204039_(AetherTags.Entities.TREATED_AS_AETHER_ENTITY) || target.m_6095_().m_204039_(AetherTags.Entities.TREATED_AS_VANILLA_ENTITY) || source.m_6095_().m_20675_().startsWith("entity.aether") || source.m_6095_().m_204039_(AetherTags.Entities.TREATED_AS_AETHER_ENTITY) || source instanceof AbstractArrow && PhoenixArrow.get(abstractArrow = (AbstractArrow)source).isPresent() && !PhoenixArrow.get(abstractArrow).resolve().isEmpty() && ((PhoenixArrow)PhoenixArrow.get(abstractArrow).resolve().get()).isPhoenixArrow())) {
                    damage = (float)Math.pow(damage, 0.5);
                }
            }
            return damage;
        }

        public static float reduceArmorEffectiveness(LivingEntity target, Entity source, float damage) {
            if (source != null && (source.m_6095_().m_20675_().startsWith("entity.aether") || source.m_6095_().m_204039_(AetherTags.Entities.TREATED_AS_AETHER_ENTITY) && !source.m_6095_().m_204039_(AetherTags.Entities.TREATED_AS_VANILLA_ENTITY))) {
                for (ItemStack stack : target.m_6168_()) {
                    Item item = stack.m_41720_();
                    if (!(item instanceof ArmorItem)) continue;
                    ArmorItem armorItem = (ArmorItem)item;
                    if (stack.m_41720_().m_5524_().startsWith("item.aether.") || stack.m_204117_(AetherTags.Items.TREATED_AS_AETHER_ITEM) || stack.m_41638_(armorItem.m_40402_()).isEmpty() || stack.m_41638_(armorItem.m_40402_()).get((Object)Attributes.f_22284_).isEmpty()) continue;
                    double value = stack.m_41638_(armorItem.m_40402_()).get((Object)Attributes.f_22284_).stream().mapToDouble(attributeModifier -> attributeModifier.m_22218_() / 15.0).sum();
                    damage = (float)((double)damage + value);
                }
            }
            return damage;
        }
    }

    public static class ToolHooks {
        public static final Map<Block, Block> STRIPPABLES = new ImmutableMap.Builder().put((Object)((Block)AetherBlocks.SKYROOT_LOG.get()), (Object)((Block)AetherBlocks.STRIPPED_SKYROOT_LOG.get())).put((Object)((Block)AetherBlocks.GOLDEN_OAK_LOG.get()), (Object)((Block)AetherBlocks.STRIPPED_SKYROOT_LOG.get())).put((Object)((Block)AetherBlocks.SKYROOT_WOOD.get()), (Object)((Block)AetherBlocks.STRIPPED_SKYROOT_WOOD.get())).put((Object)((Block)AetherBlocks.GOLDEN_OAK_WOOD.get()), (Object)((Block)AetherBlocks.STRIPPED_SKYROOT_WOOD.get())).build();
        public static final Map<Block, Block> FLATTENABLES = new ImmutableMap.Builder().put((Object)((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()), (Object)((Block)AetherBlocks.AETHER_DIRT_PATH.get())).put((Object)((Block)AetherBlocks.ENCHANTED_AETHER_GRASS_BLOCK.get()), (Object)((Block)AetherBlocks.AETHER_DIRT_PATH.get())).put((Object)((Block)AetherBlocks.AETHER_DIRT.get()), (Object)((Block)AetherBlocks.AETHER_DIRT_PATH.get())).build();
        public static final Map<Block, Block> TILLABLES = new ImmutableMap.Builder().put((Object)((Block)AetherBlocks.AETHER_DIRT.get()), (Object)((Block)AetherBlocks.AETHER_FARMLAND.get())).put((Object)((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()), (Object)((Block)AetherBlocks.AETHER_FARMLAND.get())).put((Object)((Block)AetherBlocks.ENCHANTED_AETHER_GRASS_BLOCK.get()), (Object)((Block)AetherBlocks.AETHER_FARMLAND.get())).put((Object)((Block)AetherBlocks.AETHER_DIRT_PATH.get()), (Object)((Block)AetherBlocks.AETHER_FARMLAND.get())).build();
        public static boolean debuffTools;

        public static BlockState setupToolActions(LevelAccessor accessor, BlockPos pos, BlockState old, ToolAction action) {
            Block oldBlock = old.m_60734_();
            if (action == ToolActions.AXE_STRIP) {
                if (STRIPPABLES.containsKey(oldBlock)) {
                    return STRIPPABLES.get(oldBlock).m_152465_(old);
                }
            } else if (action == ToolActions.SHOVEL_FLATTEN) {
                if (FLATTENABLES.containsKey(oldBlock)) {
                    return FLATTENABLES.get(oldBlock).m_152465_(old);
                }
            } else if (action == ToolActions.HOE_TILL && accessor.m_8055_(pos.m_7494_()).m_60795_() && TILLABLES.containsKey(oldBlock)) {
                return TILLABLES.get(oldBlock).m_152465_(old);
            }
            return old;
        }

        public static void handleHolystoneToolAbility(Player player, Level level, BlockPos pos, ItemStack stack, BlockState blockState) {
            Item item = stack.m_41720_();
            if (item instanceof HolystoneTool) {
                HolystoneTool holystoneTool = (HolystoneTool)item;
                holystoneTool.dropAmbrosium(player, level, pos, stack, blockState);
            }
        }

        public static float handleZaniteToolAbility(ItemStack stack, float speed) {
            Item item = stack.m_41720_();
            if (item instanceof ZaniteTool) {
                ZaniteTool zaniteTool = (ZaniteTool)item;
                return zaniteTool.increaseSpeed(stack, speed);
            }
            return speed;
        }

        public static float reduceToolEffectiveness(Player player, BlockState state, ItemStack stack, float speed) {
            if (((Boolean)AetherConfig.SERVER.tools_debuff.get()).booleanValue() && !player.m_9236_().m_5776_()) {
                debuffTools = true;
                AetherPacketHandler.sendToNear(new ToolDebuffPacket(true), player.m_20185_(), player.m_20186_(), player.m_20189_(), 10.0, (ResourceKey<Level>)player.m_9236_().m_46472_());
            }
            if (debuffTools && (state.m_60734_().m_7705_().startsWith("block.aether.") || state.m_204336_(AetherTags.Blocks.TREATED_AS_AETHER_BLOCK)) && !state.m_204336_(AetherTags.Blocks.TREATED_AS_VANILLA_BLOCK) && !stack.m_41619_() && stack.m_41735_(state) && !stack.m_41720_().m_5524_().startsWith("item.aether.") && !stack.m_204117_(AetherTags.Items.TREATED_AS_AETHER_ITEM)) {
                speed = (float)Math.pow(speed, -0.2);
            }
            return speed;
        }

        public static void stripGoldenOak(LevelAccessor accessor, BlockState state, ItemStack stack, ToolAction action, UseOnContext context) {
            if (action == ToolActions.AXE_STRIP && accessor instanceof Level) {
                Level level = (Level)accessor;
                if (state.m_204336_(AetherTags.Blocks.GOLDEN_OAK_LOGS) && stack.m_204117_(AetherTags.Items.GOLDEN_AMBER_HARVESTERS) && level.m_7654_() != null && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Vec3 vector = context.m_43720_();
                    LootContext.Builder lootContext = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81463_, (Object)stack);
                    LootTable lootTable = level.m_7654_().m_129898_().m_79217_(AetherLoot.STRIP_GOLDEN_OAK);
                    ObjectArrayList list = lootTable.m_230922_(lootContext.m_78975_(AetherLootContexts.STRIPPING));
                    for (ItemStack itemStack : list) {
                        ItemEntity itemEntity = new ItemEntity(level, vector.m_7096_(), vector.m_7098_(), vector.m_7094_(), itemStack);
                        itemEntity.m_32060_();
                        level.m_7967_((Entity)itemEntity);
                    }
                }
            }
        }

        public static boolean entityTooFar(Entity target, Player player, InteractionHand hand) {
            AttributeModifier valkyrieModifier;
            AttributeInstance attackRange;
            if (hand == InteractionHand.OFF_HAND && ToolHooks.hasValkyrieItemInMainHandOnly(player) && (attackRange = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get())) != null && (valkyrieModifier = attackRange.m_22111_(ValkyrieTool.ATTACK_RANGE_MODIFIER_UUID)) != null) {
                double range = player.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) - valkyrieModifier.m_22218_();
                double trueReach = range == 0.0 ? 0.0 : range + (double)(player.m_7500_() ? 3 : 0);
                return !player.isCloseEnough(target, trueReach);
            }
            return false;
        }

        public static boolean blockTooFar(Player player, InteractionHand hand) {
            AttributeModifier valkyrieModifier;
            AttributeInstance reachDistance;
            if (hand == InteractionHand.OFF_HAND && ToolHooks.hasValkyrieItemInMainHandOnly(player) && (reachDistance = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get())) != null && (valkyrieModifier = reachDistance.m_22111_(ValkyrieTool.REACH_DISTANCE_MODIFIER_UUID)) != null) {
                double reach = player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) - valkyrieModifier.m_22218_();
                double trueReach = reach == 0.0 ? 0.0 : reach + (player.m_7500_() ? 0.5 : 0.0);
                return player.m_19907_(trueReach, 0.0f, false).m_6662_() != HitResult.Type.BLOCK;
            }
            return false;
        }

        public static boolean hasValkyrieItemInMainHandOnly(Player player) {
            ItemStack mainHandStack = player.m_21205_();
            ItemStack offHandStack = player.m_21206_();
            return mainHandStack.m_41720_() instanceof ValkyrieTool && !(offHandStack.m_41720_() instanceof ValkyrieTool);
        }
    }

    public static class ArmorHooks {
        public static boolean fallCancellation(LivingEntity entity) {
            return EquipmentUtil.hasSentryBoots(entity) || EquipmentUtil.hasFullGravititeSet(entity) || EquipmentUtil.hasFullValkyrieSet(entity);
        }
    }

    public static class AccessoryHooks {
        public static void damageGloves(Player player) {
            SlotResult slotResult = EquipmentUtil.getGloves((LivingEntity)player);
            if (slotResult != null) {
                slotResult.stack().m_41622_(1, (LivingEntity)player, wearer -> CuriosApi.getCuriosHelper().onBrokenCurio(slotResult.slotContext()));
            }
        }

        public static void damageZaniteRing(LivingEntity entity, LevelAccessor level, BlockState state, BlockPos pos) {
            List<SlotResult> slotResults = EquipmentUtil.getZaniteRings(entity);
            for (SlotResult slotResult : slotResults) {
                if (slotResult == null || !(state.m_60800_((BlockGetter)level, pos) > 0.0f) || entity.m_217043_().m_188503_(6) != 0) continue;
                slotResult.stack().m_41622_(1, entity, wearer -> CuriosApi.getCuriosHelper().onBrokenCurio(slotResult.slotContext()));
            }
        }

        public static void damageZanitePendant(LivingEntity entity, LevelAccessor level, BlockState state, BlockPos pos) {
            SlotResult slotResult = EquipmentUtil.getZanitePendant(entity);
            if (slotResult != null && state.m_60800_((BlockGetter)level, pos) > 0.0f && entity.m_217043_().m_188503_(6) == 0) {
                slotResult.stack().m_41622_(1, entity, wearer -> CuriosApi.getCuriosHelper().onBrokenCurio(slotResult.slotContext()));
            }
        }

        public static float handleZaniteRingAbility(LivingEntity entity, float speed) {
            float newSpeed = speed;
            List<SlotResult> slotResults = EquipmentUtil.getZaniteRings(entity);
            for (SlotResult slotResult : slotResults) {
                if (slotResult == null) continue;
                newSpeed = ZaniteAccessory.handleMiningSpeed(newSpeed, slotResult.stack());
            }
            return newSpeed;
        }

        public static float handleZanitePendantAbility(LivingEntity entity, float speed) {
            SlotResult slotResult = EquipmentUtil.getZanitePendant(entity);
            if (slotResult != null) {
                speed = ZaniteAccessory.handleMiningSpeed(speed, slotResult.stack());
            }
            return speed;
        }

        public static boolean preventTargeting(LivingEntity target, Entity lookingEntity) {
            Player player;
            return EquipmentUtil.hasInvisibilityCloak(target) && lookingEntity != null && !lookingEntity.m_6095_().m_204039_(AetherTags.Entities.IGNORE_INVISIBILITY) && (!(target instanceof Player) || !AetherPlayer.get(player = (Player)target).isPresent() || AetherPlayer.get(player).resolve().isEmpty() || !((AetherPlayer)AetherPlayer.get(player).resolve().get()).attackedWithInvisibility());
        }

        public static boolean recentlyAttackedWithInvisibility(LivingEntity target) {
            Player player;
            return EquipmentUtil.hasInvisibilityCloak(target) && target instanceof Player && AetherPlayer.get(player = (Player)target).isPresent() && AetherPlayer.get(player).resolve().isPresent() && ((AetherPlayer)AetherPlayer.get(player).resolve().get()).attackedWithInvisibility();
        }

        public static void setAttack(DamageSource source) {
            Entity entity = source.m_7640_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setAttackedWithInvisibility(true));
            }
        }

        public static boolean preventMagmaDamage(LivingEntity entity, DamageSource source) {
            return source == entity.m_9236_().m_269111_().m_269047_() && EquipmentUtil.hasFreezingAccessory(entity);
        }

        public static void setShoot(Entity entity) {
            Projectile projectile;
            Entity entity2;
            if (entity instanceof Projectile && (entity2 = (projectile = (Projectile)entity).m_19749_()) instanceof Player) {
                Player player = (Player)entity2;
                AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setAttackedWithInvisibility(true));
            }
        }
    }
}

