/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.weapon;

import com.aetherteam.aether.entity.AetherEntityTypes;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class HammerProjectile
extends ThrowableProjectile {
    private static final EntityDataAccessor<Boolean> DATA_JEB_ID = SynchedEntityData.m_135353_(HammerProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int ticksInAir = 0;

    public HammerProjectile(EntityType<? extends HammerProjectile> type, Level level) {
        super(type, level);
    }

    public HammerProjectile(LivingEntity owner, Level level) {
        super((EntityType)AetherEntityTypes.HAMMER_PROJECTILE.get(), owner, level);
    }

    public HammerProjectile(Level level) {
        super((EntityType)AetherEntityTypes.HAMMER_PROJECTILE.get(), level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_JEB_ID, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19861_) {
            ++this.ticksInAir;
        }
        if (this.ticksInAir > 500) {
            this.m_146870_();
        }
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void shoot(Player player, float rotationPitch, float rotationYaw, float v, float velocity, float inaccuracy) {
        float x = -Mth.m_14031_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)((rotationPitch + v) * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, velocity, inaccuracy);
        Vec3 playerMotion = player.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(playerMotion.f_82479_, player.m_20096_() ? 0.0 : playerMotion.f_82480_, playerMotion.f_82481_));
    }

    protected void m_6532_(@Nonnull HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
        } else {
            for (int j = 0; j < 8; ++j) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_5790_(@Nonnull EntityHitResult result) {
        if (!this.f_19853_.f_46443_) {
            Entity target = result.m_82443_();
            this.launchTarget(target);
        }
    }

    protected void m_8060_(@Nonnull BlockHitResult result) {
        super.m_8060_(result);
        if (!this.f_19853_.f_46443_) {
            List list = this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(5.0));
            for (Entity target : list) {
                this.launchTarget(target);
            }
        }
    }

    private void launchTarget(Entity target) {
        if (target != this.m_19749_() && (this.m_19749_() == null || target != this.m_19749_().m_20202_()) && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 5.0f);
            livingEntity.m_5997_(this.m_20184_().f_82479_, 0.6, this.m_20184_().f_82481_);
        }
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void setIsJeb(boolean isJeb) {
        this.f_19804_.m_135381_(DATA_JEB_ID, (Object)isJeb);
    }

    public boolean getIsJeb() {
        return (Boolean)this.f_19804_.m_135370_(DATA_JEB_ID);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

