/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.ai.controller.FallingMovementController;
import com.aetherteam.aether.entity.ai.goal.EatAetherGrassGoal;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.entity.ai.navigator.FallPathNavigation;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import com.aetherteam.aether.loot.AetherLoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.IForgeShearable;

public class Sheepuff
extends AetherAnimal
implements Shearable,
IForgeShearable {
    private static final EntityDataAccessor<Byte> DATA_WOOL_COLOR_ID = SynchedEntityData.m_135353_(Sheepuff.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_PUFFED_ID = SynchedEntityData.m_135353_(Sheepuff.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Map<DyeColor, ItemLike> ITEM_BY_DYE = (Map)Util.m_137469_(new EnumMap(DyeColor.class), p_203402_0_ -> {
        p_203402_0_.put(DyeColor.WHITE, Blocks.f_50041_);
        p_203402_0_.put(DyeColor.ORANGE, Blocks.f_50042_);
        p_203402_0_.put(DyeColor.MAGENTA, Blocks.f_50096_);
        p_203402_0_.put(DyeColor.LIGHT_BLUE, Blocks.f_50097_);
        p_203402_0_.put(DyeColor.YELLOW, Blocks.f_50098_);
        p_203402_0_.put(DyeColor.LIME, Blocks.f_50099_);
        p_203402_0_.put(DyeColor.PINK, Blocks.f_50100_);
        p_203402_0_.put(DyeColor.GRAY, Blocks.f_50101_);
        p_203402_0_.put(DyeColor.LIGHT_GRAY, Blocks.f_50102_);
        p_203402_0_.put(DyeColor.CYAN, Blocks.f_50103_);
        p_203402_0_.put(DyeColor.PURPLE, Blocks.f_50104_);
        p_203402_0_.put(DyeColor.BLUE, Blocks.f_50105_);
        p_203402_0_.put(DyeColor.BROWN, Blocks.f_50106_);
        p_203402_0_.put(DyeColor.GREEN, Blocks.f_50107_);
        p_203402_0_.put(DyeColor.RED, Blocks.f_50108_);
        p_203402_0_.put(DyeColor.BLACK, Blocks.f_50109_);
    });
    private static final Map<DyeColor, float[]> COLOR_ARRAY_BY_COLOR = new EnumMap<DyeColor, float[]>(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(p_200204_0_ -> p_200204_0_, Sheepuff::createSheepColor)));
    private int eatAnimationTick;
    private int amountEaten;
    private EatAetherGrassGoal eatBlockGoal;
    protected final FallPathNavigation fallNavigation;
    protected final GroundPathNavigation groundNavigation;

    private static float[] createSheepColor(DyeColor p_192020_0_) {
        if (p_192020_0_ == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = p_192020_0_.m_41068_();
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public static float[] getColorArray(DyeColor p_175513_0_) {
        return COLOR_ARRAY_BY_COLOR.get(p_175513_0_);
    }

    public Sheepuff(EntityType<? extends Sheepuff> type, Level level) {
        super(type, level);
        this.f_21342_ = new FallingMovementController((Mob)this);
        this.fallNavigation = new FallPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        this.eatBlockGoal = new EatAetherGrassGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(AetherTags.Items.SHEEPUFF_TEMPTATION_ITEMS), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)this.eatBlockGoal);
        this.f_21345_.m_25352_(6, (Goal)new FallingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.23);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WOOL_COLOR_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_PUFFED_ID, (Object)false);
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.setColor(Sheepuff.getRandomSheepuffColor(level.m_213780_()));
        return super.m_6518_(level, difficulty, reason, spawnData, tag);
    }

    protected void m_8024_() {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.m_8107_();
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(id);
        }
    }

    public float getHeadEatPositionScale(float pos) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - pos) / 4.0f : -((float)(this.eatAnimationTick - 40) - pos) / 4.0f;
    }

    public float getHeadEatAngleScale(float angle) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - angle) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getPuffed()) {
            double fallSpeed;
            this.m_183634_();
            AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            if (gravity != null && this.m_20184_().f_82480_ < (fallSpeed = Math.max(gravity.m_22135_() * -0.625, -0.05))) {
                this.m_20334_(this.m_20184_().f_82479_, fallSpeed, this.m_20184_().f_82481_);
            }
            this.f_21344_ = this.fallNavigation;
        } else {
            this.f_21344_ = this.groundNavigation;
        }
    }

    protected void m_6135_() {
        super.m_6135_();
        if (this.getPuffed()) {
            this.m_5997_(0.0, 1.8, 0.0);
        }
    }

    public void m_8035_() {
        ++this.amountEaten;
        if (!this.isSheared()) {
            if (this.amountEaten >= 2) {
                this.setPuffed(true);
                this.amountEaten = 0;
            }
        } else if (this.amountEaten == 1) {
            this.setSheared(false);
            this.amountEaten = 0;
        }
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    @Nonnull
    public InteractionResult m_6071_(Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            if (!this.isSheared()) {
                DyeColor color = dyeItem.m_41089_();
                if (this.getColor() != color) {
                    if (this.getPuffed() && itemstack.m_41613_() >= 2) {
                        player.m_6674_(hand);
                        if (!player.f_19853_.f_46443_) {
                            this.setColor(color);
                            if (!player.m_150110_().f_35937_) {
                                itemstack.m_41774_(2);
                            }
                        }
                    } else if (!this.getPuffed()) {
                        player.m_6674_(hand);
                        if (!player.f_19853_.f_46443_) {
                            this.setColor(color);
                            if (!player.m_150110_().f_35937_) {
                                itemstack.m_41774_(1);
                            }
                        }
                    }
                }
            }
        }
        return super.m_6071_(player, hand);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level level, BlockPos pos, int fortune) {
        level.m_6269_(null, (Entity)this, (SoundEvent)AetherSoundEvents.ENTITY_SHEEPUFF_SHEAR.get(), player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.m_5776_()) {
            this.amountEaten = 0;
            this.setSheared(true);
            this.setPuffed(false);
            int i = 1 + this.f_19796_.m_188503_(3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack(ITEM_BY_DYE.get(this.getColor())));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public void m_5851_(SoundSource source) {
        this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)AetherSoundEvents.ENTITY_SHEEPUFF_SHEAR.get(), source, 1.0f, 1.0f);
        this.amountEaten = 0;
        this.setSheared(true);
        this.setPuffed(false);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.m_20000_(ITEM_BY_DYE.get(this.getColor()), 1);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.m_6220_();
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public boolean isSheared() {
        return ((Byte)this.f_19804_.m_135370_(DATA_WOOL_COLOR_ID) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_WOOL_COLOR_ID);
        if (sheared) {
            this.f_19804_.m_135381_(DATA_WOOL_COLOR_ID, (Object)((byte)(b0 | 0x10)));
        } else {
            this.f_19804_.m_135381_(DATA_WOOL_COLOR_ID, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Byte)this.f_19804_.m_135370_(DATA_WOOL_COLOR_ID) & 0xF));
    }

    public void setColor(DyeColor dyeColor) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_WOOL_COLOR_ID);
        this.f_19804_.m_135381_(DATA_WOOL_COLOR_ID, (Object)((byte)(b0 & 0xF0 | dyeColor.m_41060_() & 0xF)));
    }

    public static DyeColor getRandomSheepuffColor(RandomSource random) {
        int i = random.m_188503_(100);
        if (i < 5) {
            return DyeColor.LIGHT_BLUE;
        }
        if (i < 10) {
            return DyeColor.CYAN;
        }
        if (i < 15) {
            return DyeColor.LIME;
        }
        if (i < 18) {
            return DyeColor.PINK;
        }
        return random.m_188503_(500) == 0 ? DyeColor.PURPLE : DyeColor.WHITE;
    }

    public boolean getPuffed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PUFFED_ID);
    }

    public void setPuffed(boolean flag) {
        this.f_19804_.m_135381_(DATA_PUFFED_ID, (Object)flag);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(AetherTags.Items.SHEEPUFF_TEMPTATION_ITEMS);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SHEEPUFF_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_SHEEPUFF_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SHEEPUFF_DEATH.get();
    }

    protected void m_7355_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AetherSoundEvents.ENTITY_SHEEPUFF_STEP.get(), SoundSource.NEUTRAL, 0.15f, 1.0f);
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return this.getPuffed() ? 0 : super.m_5639_(distance, damageMultiplier);
    }

    public int m_6056_() {
        return !this.m_20096_() && this.getPuffed() ? 20 : super.m_6056_();
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob entity) {
        Sheepuff sheepuffParent = (Sheepuff)entity;
        Sheepuff sheepuffBaby = (Sheepuff)((EntityType)AetherEntityTypes.SHEEPUFF.get()).m_20615_((Level)level);
        if (sheepuffBaby != null) {
            sheepuffBaby.setColor(this.getOffspringColor(this, sheepuffParent));
        }
        return sheepuffBaby;
    }

    private DyeColor getOffspringColor(Animal parent1, Animal parent2) {
        DyeColor dyeColor1 = ((Sheepuff)parent1).getColor();
        DyeColor dyeColor2 = ((Sheepuff)parent2).getColor();
        CraftingContainer craftingInventory = Sheepuff.makeContainer(dyeColor1, dyeColor2);
        return this.f_19853_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, this.f_19853_).map(p_213614_1_ -> p_213614_1_.m_5874_((Container)craftingInventory, this.f_19853_.m_9598_())).map(ItemStack::m_41720_).filter(DyeItem.class::isInstance).map(DyeItem.class::cast).map(DyeItem::m_41089_).orElseGet(() -> this.f_19853_.f_46441_.m_188499_() ? dyeColor1 : dyeColor2);
    }

    private static CraftingContainer makeContainer(DyeColor dyeColor1, DyeColor dyeColor2) {
        CraftingContainer craftingInventory = new CraftingContainer((AbstractContainerMenu)new SheepuffContainer(null, -1), 2, 1);
        craftingInventory.m_6836_(0, new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)dyeColor1)));
        craftingInventory.m_6836_(1, new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)dyeColor2)));
        return craftingInventory;
    }

    protected float m_6431_(@Nonnull Pose pose, EntityDimensions size) {
        return 0.95f * size.f_20378_;
    }

    @Nonnull
    public ResourceLocation m_7582_() {
        if (this.isSheared()) {
            return this.m_6095_().m_20677_();
        }
        return switch (this.getColor()) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> AetherLoot.ENTITIES_SHEEPUFF_WHITE;
            case DyeColor.ORANGE -> AetherLoot.ENTITIES_SHEEPUFF_ORANGE;
            case DyeColor.MAGENTA -> AetherLoot.ENTITIES_SHEEPUFF_MAGENTA;
            case DyeColor.LIGHT_BLUE -> AetherLoot.ENTITIES_SHEEPUFF_LIGHT_BLUE;
            case DyeColor.YELLOW -> AetherLoot.ENTITIES_SHEEPUFF_YELLOW;
            case DyeColor.LIME -> AetherLoot.ENTITIES_SHEEPUFF_LIME;
            case DyeColor.PINK -> AetherLoot.ENTITIES_SHEEPUFF_PINK;
            case DyeColor.GRAY -> AetherLoot.ENTITIES_SHEEPUFF_GRAY;
            case DyeColor.LIGHT_GRAY -> AetherLoot.ENTITIES_SHEEPUFF_LIGHT_GRAY;
            case DyeColor.CYAN -> AetherLoot.ENTITIES_SHEEPUFF_CYAN;
            case DyeColor.PURPLE -> AetherLoot.ENTITIES_SHEEPUFF_PURPLE;
            case DyeColor.BLUE -> AetherLoot.ENTITIES_SHEEPUFF_BLUE;
            case DyeColor.BROWN -> AetherLoot.ENTITIES_SHEEPUFF_BROWN;
            case DyeColor.GREEN -> AetherLoot.ENTITIES_SHEEPUFF_GREEN;
            case DyeColor.RED -> AetherLoot.ENTITIES_SHEEPUFF_RED;
            case DyeColor.BLACK -> AetherLoot.ENTITIES_SHEEPUFF_BLACK;
        };
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Sheared", this.isSheared());
        tag.m_128379_("Puffed", this.getPuffed());
        tag.m_128344_("Color", (byte)this.getColor().m_41060_());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Sheared")) {
            this.setSheared(tag.m_128471_("Sheared"));
        }
        if (tag.m_128441_("Puffed")) {
            this.setPuffed(tag.m_128471_("Puffed"));
        }
        if (tag.m_128441_("Color")) {
            this.setColor(DyeColor.m_41053_((int)tag.m_128445_("Color")));
        }
    }

    public static class SheepuffContainer
    extends AbstractContainerMenu {
        public SheepuffContainer(@Nullable MenuType<?> pMenuType, int pContainerId) {
            super(pMenuType, pContainerId);
        }

        @Nonnull
        public ItemStack m_7648_(@Nullable Player pPlayer, int pIndex) {
            return ItemStack.f_41583_;
        }

        public boolean m_6875_(@Nonnull Player player) {
            return false;
        }
    }
}

