/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.entity.MountableMob;
import com.aetherteam.aether.entity.NotGrounded;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class MountableAnimal
extends AetherAnimal
implements MountableMob,
Saddleable,
NotGrounded {
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.m_135353_(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_JUMPED_ID = SynchedEntityData.m_135353_(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_MOUNT_JUMPING_ID = SynchedEntityData.m_135353_(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_CROUCHED_ID = SynchedEntityData.m_135353_(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ENTITY_ON_GROUND_ID = SynchedEntityData.m_135353_(MountableAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected MountableAnimal(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SADDLE_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_PLAYER_JUMPED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_MOUNT_JUMPING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_PLAYER_CROUCHED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_ENTITY_ON_GROUND_ID, (Object)true);
    }

    public void m_8119_() {
        this.tick((Mob)this);
        this.riderTick();
        super.m_8119_();
        if (this.m_20096_()) {
            this.setEntityOnGround(true);
        }
        if (this.getPlayerJumped()) {
            this.setEntityOnGround(false);
        }
    }

    public void riderTick() {
        this.riderTick((Mob)this);
    }

    public void m_7023_(@Nonnull Vec3 vector3d) {
        this.travel((Mob)this, vector3d);
    }

    @Override
    public void travelWithInput(Vec3 travelVec) {
        super.m_7023_(travelVec);
    }

    protected void m_6135_() {
        super.m_6135_();
        this.setEntityOnGround(false);
    }

    @Nonnull
    public InteractionResult m_6071_(Player playerEntity, @Nonnull InteractionHand hand) {
        boolean flag = this.m_6898_(playerEntity.m_21120_(hand));
        if (!flag && this.m_6254_() && !this.m_20160_() && !playerEntity.m_36341_()) {
            if (!this.f_19853_.f_46443_) {
                playerEntity.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        InteractionResult actionresulttype = super.m_6071_(playerEntity, hand);
        if (!actionresulttype.m_19077_()) {
            ItemStack itemstack = playerEntity.m_21120_(hand);
            return itemstack.m_150930_(Items.f_42450_) ? itemstack.m_41647_(playerEntity, (LivingEntity)this, hand) : InteractionResult.PASS;
        }
        return actionresulttype;
    }

    @Nonnull
    public Vec3 m_7688_(@Nonnull LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() != Direction.Axis.Y) {
            int[][] aint = DismountHelper.m_38467_((Direction)direction);
            BlockPos blockPos = this.m_20183_();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (Pose pose : livingEntity.m_7431_()) {
                AABB axisalignedbb = livingEntity.m_21270_(pose);
                for (int[] aint1 : aint) {
                    Vec3 vector3d;
                    mutableBlockPos.m_122178_(blockPos.m_123341_() + aint1[0], blockPos.m_123342_(), blockPos.m_123343_() + aint1[1]);
                    double d0 = this.f_19853_.m_45573_((BlockPos)mutableBlockPos);
                    if (!DismountHelper.m_38439_((double)d0) || !DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)livingEntity, (AABB)axisalignedbb.m_82383_(vector3d = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)d0)))) continue;
                    livingEntity.m_20124_(pose);
                    return vector3d;
                }
            }
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_6254_()) {
                return livingEntity;
            }
        }
        return null;
    }

    protected boolean m_7341_(@Nonnull Entity entityIn) {
        return true;
    }

    public void m_5853_(@Nullable SoundSource soundCategory) {
        this.setSaddled(true);
        if (soundCategory != null && this.getSaddledSound() != null) {
            this.f_19853_.m_6269_(null, (Entity)this, this.getSaddledSound(), soundCategory, 0.5f, 1.0f);
        }
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLE_ID);
    }

    public void setSaddled(boolean isSaddled) {
        this.f_19804_.m_135381_(DATA_SADDLE_ID, (Object)isSaddled);
    }

    @Override
    public boolean getPlayerJumped() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLAYER_JUMPED_ID);
    }

    @Override
    public void setPlayerJumped(boolean playerJumped) {
        this.f_19804_.m_135381_(DATA_PLAYER_JUMPED_ID, (Object)playerJumped);
    }

    @Override
    public boolean isMountJumping() {
        return (Boolean)this.f_19804_.m_135370_(DATA_MOUNT_JUMPING_ID);
    }

    @Override
    public void setMountJumping(boolean isMountJumping) {
        this.f_19804_.m_135381_(DATA_MOUNT_JUMPING_ID, (Object)isMountJumping);
    }

    @Override
    public boolean canJump() {
        return this.m_6254_() && this.m_20096_();
    }

    @Override
    public double getMountJumpStrength() {
        return 1.8;
    }

    @Override
    public float getSteeringSpeed() {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.625f;
    }

    public float m_274460_() {
        return this.m_6688_() != null ? this.getSteeringSpeed() * 0.25f : 0.02f;
    }

    public boolean playerTriedToCrouch() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLAYER_CROUCHED_ID);
    }

    public void setPlayerTriedToCrouch(boolean playerTriedToCrouch) {
        this.f_19804_.m_135381_(DATA_PLAYER_CROUCHED_ID, (Object)playerTriedToCrouch);
    }

    @Override
    public boolean isEntityOnGround() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ENTITY_ON_GROUND_ID);
    }

    @Override
    public void setEntityOnGround(boolean onGround) {
        this.f_19804_.m_135381_(DATA_ENTITY_ON_GROUND_ID, (Object)onGround);
    }

    @Override
    public double jumpFactor() {
        return this.m_20098_();
    }

    @Nullable
    protected SoundEvent getSaddledSound() {
        return null;
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Saddled", this.m_6254_());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Saddled")) {
            this.setSaddled(tag.m_128471_("Saddled"));
        }
    }
}

