/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.WingedBird;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.entity.ai.goal.MoaFollowGoal;
import com.aetherteam.aether.entity.ai.navigator.FallPathNavigation;
import com.aetherteam.aether.entity.monster.AechorPlant;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.entity.passive.MountableAnimal;
import com.aetherteam.aether.event.dispatch.AetherEventDispatch;
import com.aetherteam.aether.event.events.EggLayEvent;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.miscellaneous.MoaEggItem;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.MoaInteractPacket;
import com.aetherteam.aether.util.EntityUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class Moa
extends MountableAnimal
implements WingedBird {
    private static final EntityDataAccessor<String> DATA_MOA_TYPE_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_RIDER_UUID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_LAST_RIDER_UUID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_JUMPS_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_HUNGRY_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_AMOUNT_FED_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_GROWN_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SITTING_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_FOLLOWING_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public float wingRotation;
    public float prevWingRotation;
    public float destPos;
    public float prevDestPos;
    private int jumpCooldown;
    private int flapCooldown;
    public int eggTime = this.getEggTime();

    public Moa(EntityType<? extends Moa> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 0.65));
        this.f_21345_.m_25352_(2, (Goal)new MoaFollowGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new FallingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Swet.class, false, livingEntity -> {
            Swet swet;
            return this.getFollowing() == null && this.isPlayerGrown() && !this.m_6162_() && livingEntity instanceof Swet && !(swet = (Swet)livingEntity).isFriendly();
        }));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AechorPlant.class, false, livingEntity -> this.getFollowing() == null && this.isPlayerGrown() && !this.m_6162_()));
    }

    @Nonnull
    protected PathNavigation m_6037_(@Nonnull Level level) {
        return new FallPathNavigation((Mob)this, level);
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_MOA_TYPE_ID, (Object)"");
        this.f_19804_.m_135372_(DATA_RIDER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_LAST_RIDER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_REMAINING_JUMPS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_HUNGRY_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_AMOUNT_FED_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_PLAYER_GROWN_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_SITTING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_FOLLOWING_ID, Optional.empty());
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        if (tag != null) {
            if (tag.m_128441_("IsBaby")) {
                this.m_6863_(tag.m_128471_("IsBaby"));
            }
            if (tag.m_128441_("MoaType")) {
                this.setMoaType(AetherMoaTypes.get(tag.m_128461_("MoaType")));
            }
            if (tag.m_128441_("Hungry")) {
                this.setHungry(tag.m_128471_("Hungry"));
            }
            if (tag.m_128441_("PlayerGrown")) {
                this.setPlayerGrown(tag.m_128471_("PlayerGrown"));
            }
        }
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        if (this.getMoaType() == null) {
            this.setMoaType(AetherMoaTypes.getWeightedChance(this.f_19796_));
        }
        return super.m_6518_(level, difficulty, reason, spawnData, tag);
    }

    public void m_8107_() {
        super.m_8107_();
        this.animateWings();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (gravity != null) {
            double max = this.m_20160_() ? -0.5 : -0.1;
            double fallSpeed = Math.max(gravity.m_22135_() * -1.25, max);
            if (this.m_20184_().f_82480_ < fallSpeed && !this.playerTriedToCrouch()) {
                this.m_20334_(this.m_20184_().f_82479_, fallSpeed, this.m_20184_().f_82481_);
                this.f_19812_ = true;
                this.setEntityOnGround(false);
            }
        }
        if (this.m_20096_()) {
            this.setRemainingJumps(this.getMaxJumps());
        }
        if (this.getJumpCooldown() > 0) {
            this.setJumpCooldown(this.getJumpCooldown() - 1);
            this.setPlayerJumped(false);
        } else if (this.getJumpCooldown() == 0) {
            this.setMountJumping(false);
        }
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            if (this.f_19796_.m_188503_(900) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (!this.m_6162_() && this.m_20197_().isEmpty() && --this.eggTime <= 0) {
                EggLayEvent eggLayEvent;
                MoaType moaType = this.getMoaType();
                if (moaType != null && !(eggLayEvent = AetherEventDispatch.onLayEgg((Entity)this, (SoundEvent)AetherSoundEvents.ENTITY_MOA_EGG.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f, this.getMoaType().getEgg())).isCanceled()) {
                    if (eggLayEvent.getSound() != null) {
                        this.m_5496_(eggLayEvent.getSound(), eggLayEvent.getVolume(), eggLayEvent.getPitch());
                    }
                    if (eggLayEvent.getItem() != null) {
                        this.m_19998_((ItemLike)eggLayEvent.getItem());
                    }
                }
                this.eggTime = this.getEggTime();
            }
        }
        if (this.m_6162_()) {
            if (!this.isHungry()) {
                if (!this.f_19853_.m_5776_() && this.f_19796_.m_188503_(2000) == 0) {
                    this.setHungry(true);
                }
            } else if (this.f_19796_.m_188503_(10) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 1.0, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
            }
        } else {
            this.setHungry(false);
            this.setAmountFed(0);
        }
    }

    @Override
    public void riderTick() {
        if (!this.isSitting()) {
            super.riderTick();
            if (this.m_6688_() instanceof Player) {
                if (this.getFlapCooldown() > 0) {
                    this.setFlapCooldown(this.getFlapCooldown() - 1);
                } else if (this.getFlapCooldown() == 0 && !this.m_20096_()) {
                    this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)AetherSoundEvents.ENTITY_MOA_FLAP.get(), SoundSource.NEUTRAL, 0.15f, Mth.m_14036_((float)this.f_19796_.m_188501_(), (float)0.7f, (float)1.0f) + Mth.m_14036_((float)this.f_19796_.m_188501_(), (float)0.0f, (float)0.3f));
                    this.setFlapCooldown(15);
                }
                this.m_183634_();
            }
        }
    }

    @Override
    public void m_7023_(@Nonnull Vec3 vector3d) {
        if (!this.isSitting()) {
            super.m_7023_(vector3d);
        } else if (this.m_6084_()) {
            LivingEntity entity = this.m_6688_();
            if (this.m_20160_() && entity != null) {
                EntityUtil.copyRotations((Entity)this, (Entity)entity);
                if (this.m_6109_()) {
                    this.travelWithInput(new Vec3(0.0, vector3d.m_7098_(), 0.0));
                    this.f_20903_ = 0;
                } else {
                    this.m_267651_(false);
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                this.travelWithInput(new Vec3(0.0, vector3d.m_7098_(), 0.0));
            }
        }
    }

    @Override
    public void onJump(Mob moa) {
        super.onJump(moa);
        this.setJumpCooldown(10);
        if (!this.m_20096_()) {
            this.setRemainingJumps(this.getRemainingJumps() - 1);
            this.spawnExplosionParticle();
        }
        this.setFlapCooldown(0);
    }

    @Override
    @Nonnull
    public InteractionResult m_6071_(Player playerEntity, @Nonnull InteractionHand hand) {
        ItemStack itemStack = playerEntity.m_21120_(hand);
        if (this.isPlayerGrown() && itemStack.m_150930_((Item)AetherItems.NATURE_STAFF.get())) {
            itemStack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(hand));
            this.setSitting(!this.isSitting());
            this.spawnExplosionParticle();
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.isPlayerGrown() && itemStack.m_41619_() && playerEntity.m_6144_()) {
            if (this.getFollowing() == null) {
                this.setFollowing(playerEntity.m_20148_());
            } else {
                this.setFollowing(null);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!this.f_19853_.m_5776_() && this.isPlayerGrown() && this.m_6162_() && this.isHungry() && this.getAmountFed() < 3 && itemStack.m_204117_(AetherTags.Items.MOA_FOOD_ITEMS)) {
            if (!playerEntity.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.setAmountFed(this.getAmountFed() + 1);
            if (this.getAmountFed() >= 3) {
                this.m_6863_(false);
            }
            this.setHungry(false);
            AetherPacketHandler.sendToAll(new MoaInteractPacket(playerEntity.m_19879_(), hand == InteractionHand.MAIN_HAND));
            return InteractionResult.CONSUME;
        }
        if (this.isPlayerGrown() && !this.m_6162_() && this.m_21223_() < this.m_21233_() && itemStack.m_204117_(AetherTags.Items.MOA_FOOD_ITEMS)) {
            if (!playerEntity.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.m_5634_(5.0f);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(playerEntity, hand);
    }

    public void spawnExplosionParticle() {
        for (int i = 0; i < 20; ++i) {
            EntityUtil.spawnMovementExplosionParticles((Entity)this);
        }
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            if (this.getFollowing() == null || this.getFollowing().toString().equals(player.m_20148_().toString())) {
                this.setFollowing(player.m_20148_());
            }
        }
    }

    @Nullable
    public MoaType getMoaType() {
        return AetherMoaTypes.get((String)this.f_19804_.m_135370_(DATA_MOA_TYPE_ID));
    }

    public void setMoaType(MoaType moaType) {
        this.f_19804_.m_135381_(DATA_MOA_TYPE_ID, (Object)moaType.toString());
    }

    @Nullable
    public UUID getRider() {
        return ((Optional)this.f_19804_.m_135370_(DATA_RIDER_UUID)).orElse(null);
    }

    public void setRider(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_RIDER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public UUID getLastRider() {
        return ((Optional)this.f_19804_.m_135370_(DATA_LAST_RIDER_UUID)).orElse(null);
    }

    public void setLastRider(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_LAST_RIDER_UUID, Optional.ofNullable(uuid));
    }

    public int getRemainingJumps() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_JUMPS_ID);
    }

    public void setRemainingJumps(int remainingJumps) {
        this.f_19804_.m_135381_(DATA_REMAINING_JUMPS_ID, (Object)remainingJumps);
    }

    public boolean isHungry() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HUNGRY_ID);
    }

    public void setHungry(boolean hungry) {
        this.f_19804_.m_135381_(DATA_HUNGRY_ID, (Object)hungry);
    }

    public int getAmountFed() {
        return (Integer)this.f_19804_.m_135370_(DATA_AMOUNT_FED_ID);
    }

    public void setAmountFed(int amountFed) {
        this.f_19804_.m_135381_(DATA_AMOUNT_FED_ID, (Object)amountFed);
    }

    public boolean isPlayerGrown() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLAYER_GROWN_ID);
    }

    public void setPlayerGrown(boolean playerGrown) {
        this.f_19804_.m_135381_(DATA_PLAYER_GROWN_ID, (Object)playerGrown);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SITTING_ID);
    }

    public void setSitting(boolean isSitting) {
        this.f_19804_.m_135381_(DATA_SITTING_ID, (Object)isSitting);
    }

    public UUID getFollowing() {
        return ((Optional)this.f_19804_.m_135370_(DATA_FOLLOWING_ID)).orElse(null);
    }

    public void setFollowing(UUID uuid) {
        this.f_19804_.m_135381_(DATA_FOLLOWING_ID, Optional.ofNullable(uuid));
    }

    @Override
    public float getWingRotation() {
        return this.wingRotation;
    }

    @Override
    public void setWingRotation(float rot) {
        this.wingRotation = rot;
    }

    @Override
    public float getPrevWingRotation() {
        return this.prevWingRotation;
    }

    @Override
    public void setPrevWingRotation(float rot) {
        this.prevWingRotation = rot;
    }

    @Override
    public float getDestPos() {
        return this.destPos;
    }

    @Override
    public void setDestPos(float pos) {
        this.destPos = pos;
    }

    @Override
    public float getPrevDestPos() {
        return this.prevDestPos;
    }

    @Override
    public void setPrevDestPos(float pos) {
        this.prevDestPos = pos;
    }

    public int getJumpCooldown() {
        return this.jumpCooldown;
    }

    public void setJumpCooldown(int jumpCooldown) {
        this.jumpCooldown = jumpCooldown;
    }

    public int getFlapCooldown() {
        return this.flapCooldown;
    }

    public void setFlapCooldown(int flapCooldown) {
        this.flapCooldown = flapCooldown;
    }

    public int getMaxJumps() {
        MoaType moaType = this.getMoaType();
        return moaType != null ? moaType.getMaxJumps() : ((MoaType)AetherMoaTypes.BLUE.get()).getMaxJumps();
    }

    public int getEggTime() {
        return this.f_19796_.m_188503_(6000) + 6000;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_MOA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_MOA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_MOA_DEATH.get();
    }

    @Override
    protected SoundEvent getSaddledSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_MOA_SADDLE.get();
    }

    protected void m_7355_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_MOA_STEP.get(), 0.15f, 1.0f);
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return (effect.m_19544_() != AetherEffects.INEBRIATION.get() || !this.isPlayerGrown()) && super.m_7301_(effect);
    }

    public float m_6113_() {
        MoaType moaType = this.getMoaType();
        return moaType != null ? moaType.getSpeed() : ((MoaType)AetherMoaTypes.BLUE.get()).getSpeed();
    }

    @Override
    public boolean canJump() {
        return this.getRemainingJumps() > 0 && this.getJumpCooldown() == 0;
    }

    @Override
    public boolean m_6741_() {
        return super.m_6741_() && this.isPlayerGrown();
    }

    @Override
    public double getMountJumpStrength() {
        return this.m_20096_() ? 0.95 : 0.9;
    }

    @Override
    public float getSteeringSpeed() {
        MoaType moaType = this.getMoaType();
        return moaType != null ? moaType.getSpeed() : ((MoaType)AetherMoaTypes.BLUE.get()).getSpeed();
    }

    @Override
    public float m_274460_() {
        if (this.m_20160_()) {
            return this.getSteeringSpeed() * 0.45f;
        }
        return this.getSteeringSpeed() * 0.025f;
    }

    public int m_6056_() {
        return this.m_20096_() ? super.m_6056_() : 14;
    }

    public double m_6048_() {
        return this.isSitting() ? 0.25 : 1.25;
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob entity) {
        return null;
    }

    public boolean m_35506_() {
        return false;
    }

    public void m_146762_(int age) {
        if (age == -24000 || age == 0 && this.getAmountFed() >= 3) {
            super.m_146762_(age);
        }
    }

    public ItemStack m_142340_() {
        MoaEggItem moaEggItem = MoaEggItem.byId(this.getMoaType());
        return moaEggItem == null ? null : new ItemStack((ItemLike)moaEggItem);
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("IsBaby")) {
            this.m_6863_(tag.m_128471_("IsBaby"));
        }
        if (tag.m_128441_("MoaType") && AetherMoaTypes.get(tag.m_128461_("MoaType")) != null) {
            this.setMoaType(AetherMoaTypes.get(tag.m_128461_("MoaType")));
        } else {
            this.setMoaType(AetherMoaTypes.getWeightedChance(this.f_19796_));
        }
        if (tag.m_128403_("Rider")) {
            this.setRider(tag.m_128342_("Rider"));
        }
        if (tag.m_128403_("LastRider")) {
            this.setLastRider(tag.m_128342_("LastRider"));
        }
        if (tag.m_128441_("RemainingJumps")) {
            this.setRemainingJumps(tag.m_128451_("RemainingJumps"));
        }
        if (tag.m_128441_("Hungry")) {
            this.setHungry(tag.m_128471_("Hungry"));
        }
        if (tag.m_128441_("AmountFed")) {
            this.setAmountFed(tag.m_128451_("AmountFed"));
        }
        if (tag.m_128441_("PlayerGrown")) {
            this.setPlayerGrown(tag.m_128471_("PlayerGrown"));
        }
        if (tag.m_128441_("Sitting")) {
            this.setSitting(tag.m_128471_("Sitting"));
        }
        if (tag.m_128441_("Following")) {
            this.setFollowing(tag.m_128342_("Following"));
        }
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsBaby", this.m_6162_());
        tag.m_128359_("MoaType", this.getMoaType().toString());
        if (this.getRider() != null) {
            tag.m_128362_("Rider", this.getRider());
        }
        if (this.getLastRider() != null) {
            tag.m_128362_("LastRider", this.getLastRider());
        }
        tag.m_128405_("RemainingJumps", this.getRemainingJumps());
        tag.m_128379_("Hungry", this.isHungry());
        tag.m_128405_("AmountFed", this.getAmountFed());
        tag.m_128379_("PlayerGrown", this.isPlayerGrown());
        tag.m_128379_("Sitting", this.isSitting());
        if (this.getFollowing() != null) {
            tag.m_128362_("Following", this.getFollowing());
        }
    }
}

