/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.AetherSoundEvents;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class Aerwhale
extends FlyingMob {
    public static final EntityDataAccessor<Float> DATA_X_ROT_ID = SynchedEntityData.m_135353_(Aerwhale.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_Y_ROT_ID = SynchedEntityData.m_135353_(Aerwhale.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Aerwhale(EntityType<? extends Aerwhale> type, Level level) {
        super(type, level);
        this.f_21365_ = new BlankLookControl((Mob)this);
        this.f_21342_ = new AerwhaleMoveControl(this);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SetTravelCourseGoal((Mob)this));
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return FlyingMob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22280_, 0.2).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 0.4);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_X_ROT_ID, (Object)Float.valueOf(this.m_146909_()));
        this.f_19804_.m_135372_(DATA_Y_ROT_ID, (Object)Float.valueOf(this.m_146908_()));
    }

    public static boolean checkAerwhaleSpawnRules(EntityType<? extends Aerwhale> aerwhale, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.m_6425_(pos).m_192917_(Fluids.f_76191_) && level.m_45524_(pos, 0) > 8 && Aerwhale.m_217057_(aerwhale, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && (reason != MobSpawnType.NATURAL || random.m_188503_(40) == 0) && level.m_45527_(pos);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_146926_(this.getXRotData());
        this.m_146922_(this.getYRotData());
        this.f_20883_ = this.getYRotData();
        this.f_20885_ = this.getYRotData();
    }

    public void m_7023_(@Nonnull Vec3 positionIn) {
        if (this.m_21515_() || this.m_6109_()) {
            List passengers = this.m_20197_();
            if (!passengers.isEmpty()) {
                Entity entity = (Entity)passengers.get(0);
                if (entity instanceof Player) {
                    float f4;
                    double d1;
                    double d0;
                    Player player = (Player)entity;
                    this.m_146922_(player.m_146908_() + 90.0f);
                    this.f_19859_ = this.m_146908_();
                    this.m_146926_(-player.m_146909_());
                    this.f_19860_ = this.m_146909_() * 0.5f;
                    this.f_20885_ = player.f_20885_;
                    positionIn = new Vec3((double)player.f_20900_, 0.0, player.f_20902_ <= 0.0f ? (double)(player.f_20902_ * 0.25f) : (double)player.f_20902_);
                    if (AetherPlayer.get(player).map(AetherPlayer::isJumping).orElse(false).booleanValue()) {
                        this.m_20256_(new Vec3(0.0, 0.0, 0.0));
                    } else {
                        d0 = Math.toRadians(this.m_146908_());
                        d1 = Math.toRadians(-player.m_146909_());
                        double d2 = Math.cos(d1);
                        this.m_20334_(0.98 * (this.m_20184_().f_82479_ + 0.05 * Math.cos(d0) * d2), 0.98 * (this.m_20184_().f_82480_ + 0.02 * Math.sin(d1)), 0.98 * (this.m_20184_().f_82481_ + 0.05 * Math.sin(d0) * d2));
                    }
                    if (!this.f_19853_.f_46443_) {
                        super.m_7023_(positionIn);
                    }
                    if ((f4 = 4.0f * Mth.m_14116_((float)((float)((d0 = this.m_20185_() - this.f_19854_) * d0 + (d1 = this.m_20189_() - this.f_19856_) * d1)))) > 1.0f) {
                        f4 = 1.0f;
                    }
                    this.f_267362_.m_267566_(f4, 0.4f);
                }
            } else {
                super.m_7023_(positionIn);
            }
        }
    }

    protected float m_274460_() {
        return this.m_20160_() ? this.m_6113_() * 0.6f : 0.02f;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20095_();
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (player.m_20148_().equals(UUID.fromString("031025bd-0a15-439b-9c55-06a20d0de76f"))) {
            player.m_20329_((Entity)this);
            if (!this.f_19853_.f_46443_) {
                MutableComponent msg = Component.m_237113_((String)"Serenity is the queen of W(h)ales!!");
                player.f_19853_.m_6907_().forEach(p -> p.m_213846_((Component)msg));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public int m_5792_() {
        return 1;
    }

    public void setXRotData(float rot) {
        this.f_19804_.m_135381_(DATA_X_ROT_ID, (Object)Float.valueOf(Mth.m_14177_((float)rot)));
    }

    public float getXRotData() {
        return ((Float)this.f_19804_.m_135370_(DATA_X_ROT_ID)).floatValue();
    }

    public void setYRotData(float rot) {
        this.f_19804_.m_135381_(DATA_Y_ROT_ID, (Object)Float.valueOf(Mth.m_14177_((float)rot)));
    }

    public float getYRotData() {
        return ((Float)this.f_19804_.m_135370_(DATA_Y_ROT_ID)).floatValue();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERWHALE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSourceIn) {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERWHALE_DEATH.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERWHALE_DEATH.get();
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public int m_213860_() {
        return 1 + this.f_19853_.f_46441_.m_188503_(3);
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(3.0);
    }

    public static class BlankLookControl
    extends LookControl {
        public BlankLookControl(Mob pMob) {
            super(pMob);
        }

        public void m_8128_() {
        }
    }

    public static class AerwhaleMoveControl
    extends MoveControl {
        protected final Aerwhale f_24974_;

        public AerwhaleMoveControl(Aerwhale pMob) {
            super((Mob)pMob);
            this.f_24974_ = pMob;
        }

        public void m_8126_() {
            if (this.f_24974_.m_20160_()) {
                return;
            }
            double x = this.m_25000_() - this.f_24974_.m_20185_();
            double y = this.m_25001_() - this.f_24974_.m_20186_();
            double z = this.m_25002_() - this.f_24974_.m_20189_();
            double distance = Math.sqrt(x * x + z * z);
            if (distance < 3.0 || this.isColliding(new Vec3(x, y, z).m_82541_())) {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
            float xRotTarget = (float)(Mth.m_14136_((double)y, (double)distance) * 57.2957763671875);
            float xRot = Mth.m_14177_((float)this.f_24974_.m_146909_());
            xRot = Mth.m_14148_((float)xRot, (float)xRotTarget, (float)0.2f);
            this.f_24974_.m_146926_(xRot);
            this.f_24974_.setXRotData(this.f_24974_.m_146909_());
            float yRotTarget = Mth.m_14177_((float)((float)Mth.m_14136_((double)z, (double)x) * 57.295776f));
            float yRot = Mth.m_14177_((float)(this.f_24974_.m_146908_() + 90.0f));
            yRot = Mth.m_14148_((float)yRot, (float)yRotTarget, (float)0.5f);
            this.f_24974_.m_146922_(yRot - 90.0f);
            this.f_24974_.setYRotData(this.f_24974_.m_146908_());
            this.f_24974_.f_20883_ = yRot;
            this.f_24974_.f_20885_ = yRot;
            x = this.f_24974_.m_21133_(Attributes.f_22280_) * (double)Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
            y = this.f_24974_.m_21133_(Attributes.f_22280_) * (double)Mth.m_14031_((float)(xRot * ((float)Math.PI / 180)));
            z = this.f_24974_.m_21133_(Attributes.f_22280_) * (double)Mth.m_14031_((float)(yRot * ((float)Math.PI / 180)));
            Vec3 motion = new Vec3(x, y, z);
            this.f_24974_.m_20256_(motion);
        }

        private boolean isColliding(Vec3 pos) {
            AABB axisalignedbb = this.f_24974_.m_20191_();
            for (int i = 1; i < 7; ++i) {
                if (this.f_24974_.f_19853_.m_45756_((Entity)this.f_24974_, axisalignedbb = axisalignedbb.m_82383_(pos))) continue;
                return true;
            }
            return false;
        }
    }

    public static class SetTravelCourseGoal
    extends Goal {
        private final Mob mob;

        public SetTravelCourseGoal(Mob mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl moveControl = this.mob.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d0 = moveControl.m_25000_() - this.mob.m_20185_();
            double d3 = d0 * d0 + (d1 = moveControl.m_25001_() - this.mob.m_20186_()) * d1 + (d2 = moveControl.m_25002_() - this.mob.m_20189_()) * d2;
            return d3 < 1.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.mob.m_217043_();
            double x = (random.m_188501_() * 2.0f - 1.0f) * 16.0f;
            double z = (random.m_188501_() * 2.0f - 1.0f) * 16.0f;
            double y = this.mob.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            x = x >= 0.0 ? x + 32.0 : x - 32.0;
            z = z >= 0.0 ? z + 32.0 : z - 32.0;
            y = Mth.m_14008_((double)y, (double)this.mob.f_19853_.m_141937_(), (double)this.mob.f_19853_.m_151558_());
            this.mob.m_21566_().m_6849_(x += this.mob.m_20185_(), y, z += this.mob.m_20189_(), 1.0);
        }
    }
}

