/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.ExplosionParticlePacket;
import com.aetherteam.aether.network.packet.server.AerbunnyPuffPacket;
import com.aetherteam.aether.util.EntityUtil;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class Aerbunny
extends AetherAnimal {
    public static final EntityDataAccessor<Integer> DATA_PUFFINESS_ID = SynchedEntityData.m_135353_(Aerbunny.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DATA_FAST_FALLING = SynchedEntityData.m_135353_(Aerbunny.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int puffSubtract;
    private boolean afraid;
    private Vec3 lastPos;

    public Aerbunny(EntityType<? extends Aerbunny> type, Level level) {
        super(type, level);
        this.f_21342_ = new AerbunnyMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RunLikeHellGoal(this, 1.3));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(AetherTags.Items.AERBUNNY_TEMPTATION_ITEMS), false));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new FallingRandomStrollGoal((PathfinderMob)this, 1.0, 80));
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.28);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PUFFINESS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FAST_FALLING, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isFastFalling()) {
            this.handleFallSpeed();
        } else if (this.f_19861_) {
            this.setFastFalling(false);
        }
        this.setPuffiness(this.getPuffiness() - this.puffSubtract);
        if (this.getPuffiness() > 0) {
            this.puffSubtract = 1;
        } else {
            this.puffSubtract = 0;
            this.setPuffiness(0);
        }
        this.handlePlayerInput();
        if (this.m_20202_() != null && (this.m_20202_().m_20096_() || this.m_20202_().isInFluidType())) {
            this.lastPos = null;
        }
    }

    protected float m_274460_() {
        return this.m_6113_() * 0.21600002f;
    }

    private void handleFallSpeed() {
        double fallSpeed;
        AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (gravity != null && this.m_20184_().f_82480_ < (fallSpeed = Math.max(gravity.m_22135_() * -1.25, -0.1))) {
            this.m_20334_(this.m_20184_().f_82479_, fallSpeed, this.m_20184_().f_82481_);
        }
    }

    private void handlePlayerInput() {
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_5833_()) {
                this.m_8127_();
            }
            EntityUtil.copyRotations((Entity)this, (Entity)player);
            player.m_183634_();
            if (!player.m_20096_() && !player.m_21255_()) {
                AttributeInstance playerGravity = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                if (playerGravity != null && !player.m_150110_().f_35935_ && !player.isInFluidType() && playerGravity.m_22135_() > 0.02) {
                    player.m_20256_(player.m_20184_().m_82520_(0.0, 0.05, 0.0));
                }
                AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                    if (this.f_19853_.f_46443_ && player.m_20184_().f_82480_ <= 0.0) {
                        if (this.lastPos == null) {
                            this.lastPos = this.m_20182_();
                        }
                        if (!player.m_20096_() && aetherPlayer.isJumping() && player.m_20184_().f_82480_ <= 0.0 && this.m_20182_().m_7098_() < this.lastPos.m_7098_() - 1.1) {
                            player.m_20334_(player.m_20184_().f_82479_, 0.125, player.m_20184_().f_82481_);
                            AetherPacketHandler.sendToServer(new AerbunnyPuffPacket(this.m_19879_()));
                            this.lastPos = null;
                        }
                    }
                });
            } else if (player.m_21255_()) {
                this.m_8127_();
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_;
                serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_6084_() && this.m_20159_() && this.m_20202_() != null && this.m_20202_().isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !this.f_19853_.m_8055_(BlockPos.m_274561_((double)this.m_20202_().m_20185_(), (double)this.m_20202_().m_20188_(), (double)this.m_20202_().m_20189_())).m_60713_(Blocks.f_50628_)) {
            this.m_8127_();
        }
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        Player vehicle;
        InteractionResult result = super.m_6071_(player, hand);
        Entity entity = this.m_20202_();
        if (!(entity instanceof Player && !(vehicle = (Player)entity).equals((Object)player) || !player.m_6144_() && result != InteractionResult.PASS && result != InteractionResult.FAIL || super.m_5830_())) {
            return this.ridePlayer(player);
        }
        return result;
    }

    private InteractionResult ridePlayer(Player player) {
        if (!this.m_6162_()) {
            if (this.m_20159_()) {
                this.m_8127_();
                this.setFastFalling(true);
                Vec3 playerMovement = player.m_20184_();
                this.m_20334_(playerMovement.f_82479_ * 5.0, playerMovement.f_82480_ * 0.5 + 0.5, playerMovement.f_82481_ * 5.0);
            } else if (this.m_20329_((Entity)player)) {
                AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setMountedAerbunny(this));
                this.f_19853_.m_6269_(player, (Entity)this, (SoundEvent)AetherSoundEvents.ENTITY_AERBUNNY_LIFT.get(), SoundSource.NEUTRAL, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8127_() {
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setMountedAerbunny(null));
        }
        super.m_8127_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean flag = super.m_6469_(pSource, pAmount);
        if (flag && pSource.m_7639_() instanceof Player) {
            this.setAfraid(true);
        }
        return flag;
    }

    protected void midairJump() {
        Vec3 motion = this.m_20184_();
        if (motion.f_82480_ < 0.0) {
            this.puff();
        }
        this.m_20256_(new Vec3(motion.f_82479_, 0.25, motion.f_82481_));
    }

    public void puff() {
        if (this.f_19853_ instanceof ServerLevel) {
            this.setPuffiness(11);
            this.spawnExplosionParticle();
        }
    }

    private void spawnExplosionParticle() {
        AetherPacketHandler.sendToNear(new ExplosionParticlePacket(this.m_19879_(), 5), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0, (ResourceKey<Level>)this.f_19853_.m_46472_());
    }

    public int getPuffiness() {
        return (Integer)this.f_19804_.m_135370_(DATA_PUFFINESS_ID);
    }

    public void setPuffiness(int i) {
        this.f_19804_.m_135381_(DATA_PUFFINESS_ID, (Object)i);
    }

    public boolean isFastFalling() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FAST_FALLING);
    }

    public void setFastFalling(boolean flag) {
        this.f_19804_.m_135381_(DATA_FAST_FALLING, (Object)flag);
    }

    public boolean isAfraid() {
        return this.afraid;
    }

    public void setAfraid(boolean fear) {
        this.afraid = fear;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(AetherTags.Items.AERBUNNY_TEMPTATION_ITEMS);
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERBUNNY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERBUNNY_DEATH.get();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public double m_6049_() {
        return this.m_20202_() != null && this.m_20202_().m_6047_() ? 0.4 : 0.575;
    }

    public boolean m_6087_() {
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_20191_().m_82369_(player.m_20252_(0.0f)).m_82390_(this.m_20191_().m_82399_().m_82520_(0.0, this.m_20191_().m_82309_() / 2.0, 0.0));
        }
        return true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Afraid", this.afraid);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.afraid = tag.m_128471_("Afraid");
    }

    public boolean m_6673_(@Nonnull DamageSource damageSource) {
        return this.m_20202_() != null && this.m_20202_() == damageSource.m_7639_() || super.m_6673_(damageSource);
    }

    public boolean m_5830_() {
        return !this.m_20159_() && super.m_5830_();
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob entity) {
        return (AgeableMob)((EntityType)AetherEntityTypes.AERBUNNY.get()).m_20615_((Level)level);
    }

    public static class AerbunnyMoveControl
    extends MoveControl {
        private final Aerbunny aerbunny;

        public AerbunnyMoveControl(Aerbunny aerbunny) {
            super((Mob)aerbunny);
            this.aerbunny = aerbunny;
        }

        public void m_8126_() {
            super.m_8126_();
            if (this.aerbunny.f_20902_ != 0.0f) {
                if (this.aerbunny.f_19861_) {
                    this.aerbunny.f_21343_.m_24901_();
                } else {
                    int z;
                    int y;
                    int x = Mth.m_14107_((double)this.aerbunny.m_20185_());
                    if (this.checkForSurfaces(this.aerbunny.f_19853_, x, y = Mth.m_14107_((double)this.aerbunny.m_20191_().f_82289_), z = Mth.m_14107_((double)this.aerbunny.m_20189_()))) {
                        this.aerbunny.midairJump();
                    }
                }
            }
        }

        private boolean checkForSurfaces(Level level, int x, int y, int z) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
            if (level.m_8055_((BlockPos)pos.m_142448_(y - 1)).m_60795_()) {
                return false;
            }
            return level.m_8055_((BlockPos)pos.m_142448_(y + 2)).m_60795_() && level.m_8055_((BlockPos)pos.m_142448_(y + 1)).m_60795_();
        }
    }

    public static class RunLikeHellGoal
    extends Goal {
        private final Aerbunny aerbunny;
        private final double speedModifier;

        public RunLikeHellGoal(Aerbunny aerbunny, double speedModifier) {
            this.aerbunny = aerbunny;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.aerbunny.isAfraid();
        }

        public boolean m_8045_() {
            return !this.aerbunny.m_21573_().m_26571_() && this.aerbunny.f_19796_.m_188503_(20) != 0;
        }

        public void m_8056_() {
            Player attacker = this.aerbunny.f_19853_.m_45930_((Entity)this.aerbunny, 12.0);
            if (attacker == null) {
                return;
            }
            Vec3 position = this.aerbunny.m_20182_();
            double angle = Mth.m_14136_((double)(position.m_7096_() - attacker.m_20185_()), (double)(position.m_7094_() - attacker.m_20189_()));
            float angleOffset = this.aerbunny.f_19796_.m_188501_() * 2.0f - 1.0f;
            double x = position.m_7096_() + Math.sin(angle += (double)angleOffset * 0.75) * 8.0;
            double z = position.m_7094_() + Math.cos(angle) * 8.0;
            boolean flag = this.aerbunny.f_21344_.m_26519_(x, this.aerbunny.m_20186_(), z, this.speedModifier);
            if (!flag) {
                this.aerbunny.m_21563_().m_24960_((Entity)attacker, 30.0f, 30.0f);
            }
        }

        public void m_8037_() {
            if (this.aerbunny.m_217043_().m_188503_(4) == 0) {
                ((ServerLevel)this.aerbunny.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.aerbunny.m_20208_(0.5), this.aerbunny.m_20187_(), this.aerbunny.m_20262_(0.5), 2, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

