/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss.slider;

import com.aetherteam.aether.entity.ai.brain.memory.AetherMemoryModuleTypes;
import com.aetherteam.aether.entity.ai.brain.sensing.AetherSensorTypes;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.AvoidObstacles;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.BackOffAfterAttack;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.Collide;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.Crush;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.Move;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.SetPathUpOrDown;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.Slider;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SliderAi {
    private static final ImmutableList<SensorType<? extends Sensor<Slider>>> SENSOR_TYPES = ImmutableList.of((Object)((SensorType)AetherSensorTypes.SLIDER_PLAYER_SENSOR.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26367_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26326_, (Object)((MemoryModuleType)AetherMemoryModuleTypes.AGGRO_TRACKER.get()), (Object)((MemoryModuleType)AetherMemoryModuleTypes.HAS_ATTACKED.get()), (Object)((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DELAY.get()), (Object)((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DIRECTION.get()), (Object)((MemoryModuleType)AetherMemoryModuleTypes.TARGET_POSITION.get()));
    private static final ImmutableList<Activity> ACTIVITY_PRIORITY = ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_);

    public static Brain<Slider> makeBrain(Dynamic<?> dynamic) {
        Brain brain = Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES).m_22073_(dynamic);
        SliderAi.initFightActivity((Brain<Slider>)brain);
        brain.m_21879_((MemoryModuleType)AetherMemoryModuleTypes.AGGRO_TRACKER.get(), (Object)new Object2DoubleOpenHashMap());
        return brain;
    }

    private static void initFightActivity(Brain<Slider> brain) {
        brain.m_21891_(Activity.f_37988_, 10, ImmutableList.of((Object)StartAttacking.m_257710_(SliderAi::findNearestValidAttackTarget), (Object)((Object)new Collide()), (Object)((Object)new Crush()), (Object)((Object)new BackOffAfterAttack()), (Object)((Object)new SetPathUpOrDown()), (Object)((Object)new AvoidObstacles()), (Object)((Object)new Move())));
    }

    public static void updateActivity(Slider slider) {
        slider.m_6274_().m_21926_(ACTIVITY_PRIORITY);
    }

    protected static void tick(Slider slider) {
        if (slider.f_19797_ % 20 != 0) {
            return;
        }
        Brain brain = slider.m_6274_();
        Optional optional = brain.m_21952_((MemoryModuleType)AetherMemoryModuleTypes.AGGRO_TRACKER.get());
        if (optional.isPresent()) {
            Object2DoubleMap attackers = (Object2DoubleMap)optional.get();
            attackers.forEach((target, oldAggro) -> {
                Player player;
                double aggro = oldAggro - 1.0;
                if (!target.m_6084_() || aggro <= 0.0 && !Sensor.m_148312_((LivingEntity)slider, (LivingEntity)target) || target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
                    attackers.removeDouble(target);
                } else {
                    attackers.put(target, aggro);
                }
            });
        }
    }

    protected static void wasHurtBy(Slider slider, LivingEntity attacker, float damage) {
        Brain brain = slider.m_6274_();
        Optional optional = brain.m_21952_((MemoryModuleType)AetherMemoryModuleTypes.AGGRO_TRACKER.get());
        if (optional.isPresent()) {
            Object2DoubleMap attackers = (Object2DoubleMap)optional.get();
            attackers.mergeDouble((Object)attacker, (double)damage, Double::sum);
            LivingEntity target = SliderAi.getStrongestAttacker(slider, (Object2DoubleMap<LivingEntity>)attackers);
            brain.m_21936_(MemoryModuleType.f_26326_);
            brain.m_21879_(MemoryModuleType.f_26372_, (Object)target);
        }
    }

    private static LivingEntity getStrongestAttacker(Slider slider, Object2DoubleMap<LivingEntity> attackers) {
        Map.Entry entry = attackers.object2DoubleEntrySet().stream().filter(entityEntry -> Sensor.m_148312_((LivingEntity)slider, (LivingEntity)((LivingEntity)entityEntry.getKey()))).max(Comparator.comparingDouble(Map.Entry::getValue)).orElse(null);
        if (entry == null) {
            return null;
        }
        return (LivingEntity)entry.getKey();
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Slider slider) {
        return slider.isAwake() && !slider.m_21224_() ? slider.m_6274_().m_21952_(MemoryModuleType.f_148206_) : Optional.empty();
    }

    @Nullable
    public static Vec3 getTargetPoint(Brain<?> brain) {
        Optional pos = brain.m_21952_((MemoryModuleType)AetherMemoryModuleTypes.TARGET_POSITION.get());
        if (pos.isPresent()) {
            return (Vec3)pos.get();
        }
        Optional target = brain.m_21952_(MemoryModuleType.f_26372_);
        return target.map(Entity::m_20182_).orElse(null);
    }

    public static Direction calculateDirection(double x, double y, double z) {
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double absZ = Math.abs(z);
        if (absY > absX && absY > absZ) {
            return y > 0.0 ? Direction.UP : Direction.DOWN;
        }
        if (absX > absZ) {
            return x > 0.0 ? Direction.EAST : Direction.WEST;
        }
        return z > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    public static AABB calculateAdjacentBox(AABB box, Direction direction) {
        double minX = box.f_82288_;
        double minY = box.f_82289_;
        double minZ = box.f_82290_;
        double maxX = box.f_82291_;
        double maxY = box.f_82292_;
        double maxZ = box.f_82293_;
        if (direction == Direction.UP) {
            minY = maxY;
            maxY += 1.0;
        } else if (direction == Direction.DOWN) {
            maxY = minY;
            minY -= 1.0;
        } else if (direction == Direction.NORTH) {
            maxZ = minZ;
            minZ -= 1.0;
        } else if (direction == Direction.SOUTH) {
            minZ = maxZ;
            maxZ += 1.0;
        } else if (direction == Direction.EAST) {
            minX = maxX;
            maxX += 1.0;
        } else {
            maxX = minX;
            minX -= 1.0;
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

