/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss.slider;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.api.BossNameGenerator;
import com.aetherteam.aether.api.BossRoomTracker;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.BossMob;
import com.aetherteam.aether.entity.ai.controller.BlankMoveControl;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.SliderAi;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.BossInfoPacket;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class Slider
extends PathfinderMob
implements BossMob<Slider>,
Enemy,
IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Boolean> DATA_AWAKE_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Component> DATA_BOSS_NAME_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    public static final EntityDataAccessor<Float> DATA_HURT_ANGLE_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_HURT_ANGLE_X_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_HURT_ANGLE_Z_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private BossRoomTracker<Slider> bronzeDungeon;
    private final ServerBossEvent bossFight = new ServerBossEvent(this.getBossName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private int chatCooldown;

    public Slider(EntityType<? extends Slider> entityType, Level level) {
        super(entityType, level);
        this.bossFight.m_8321_(false);
        this.f_21364_ = 50;
        this.m_19915_(0.0f, 0.0f);
        this.f_21342_ = new BlankMoveControl((Mob)this);
        this.m_21530_();
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return SliderAi.makeBrain(dynamic);
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor pLevel, @Nonnull DifficultyInstance pDifficulty, @Nonnull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.alignSpawnPos();
        SpawnGroupData data = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setBossName((Component)BossNameGenerator.generateSliderName());
        return data;
    }

    protected void alignSpawnPos() {
        this.m_6027_(Mth.m_14107_((double)this.m_20185_()), this.m_20186_(), Mth.m_14107_((double)this.m_20189_()));
    }

    public static AttributeSupplier.Builder createSliderAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_AWAKE_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_BOSS_NAME_ID, (Object)Component.m_237113_((String)"Slider"));
        this.f_19804_.m_135372_(DATA_HURT_ANGLE_ID, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_HURT_ANGLE_X_ID, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_HURT_ANGLE_Z_ID, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8119_();
        if (!this.isAwake() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            this.m_6710_(null);
        }
        this.evaporate();
        if (this.getChatCooldown() > 0) {
            --this.chatCooldown;
        }
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
        this.trackDungeon();
        Brain brain = this.m_6274_();
        brain.m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        SliderAi.updateActivity(this);
        SliderAi.tick(this);
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            super.m_6469_(source, amount);
        } else {
            Entity entity2 = source.m_7640_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                if (this.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
                    if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((Entity)attacker)) {
                        if (attacker.m_21205_().m_204117_(AetherTags.Items.SLIDER_DAMAGING_ITEMS)) {
                            if (super.m_6469_(source, amount) && this.m_21223_() > 0.0f) {
                                if (!this.isBossFight()) {
                                    this.start();
                                }
                                this.m_20256_(this.m_20184_().m_82490_(0.75));
                                double a = Math.abs(this.m_20182_().m_7096_() - attacker.m_20182_().m_7096_());
                                double c = Math.abs(this.m_20182_().m_7094_() - attacker.m_20182_().m_7094_());
                                if (a > c) {
                                    this.setHurtAngleZ(1.0f);
                                    this.setHurtAngleX(0.0f);
                                    if (this.m_20182_().m_7096_() > attacker.m_20182_().m_7096_()) {
                                        this.setHurtAngleZ(-1.0f);
                                    }
                                } else {
                                    this.setHurtAngleX(1.0f);
                                    this.setHurtAngleZ(0.0f);
                                    if (this.m_20182_().m_7094_() > attacker.m_20182_().m_7094_()) {
                                        this.setHurtAngleX(-1.0f);
                                    }
                                }
                                this.setHurtAngle(0.7f - this.m_21223_() / 875.0f);
                                attacker.m_21205_().m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
                                SliderAi.wasHurtBy(this, attacker, amount);
                                return true;
                            }
                        } else if (!this.f_19853_.f_46443_ && attacker instanceof Player) {
                            player = (Player)attacker;
                            if (this.getChatCooldown() <= 0) {
                                this.displayInvalidToolMessage(player);
                                this.setChatCooldown(15);
                                return false;
                            }
                        }
                    } else if (!this.f_19853_.f_46443_ && attacker instanceof Player) {
                        player = (Player)attacker;
                        if (this.getChatCooldown() <= 0) {
                            this.displayTooFarMessage(player);
                            this.setChatCooldown(15);
                            return false;
                        }
                    }
                }
            }
        }
        return false;
    }

    public void displayInvalidToolMessage(Player player) {
        player.m_213846_((Component)Component.m_237115_((String)"gui.aether.slider.message.attack.invalid"));
    }

    public void m_6667_(@Nonnull DamageSource damageSource) {
        this.m_20256_(Vec3.f_82478_);
        this.explode();
        if (this.f_19853_ instanceof ServerLevel) {
            this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(damageSource);
                this.tearDownRoom();
            }
        }
        super.m_6667_(damageSource);
    }

    private void start() {
        if (this.getAwakenSound() != null) {
            this.m_5496_(this.getAwakenSound(), 2.5f, 1.0f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        }
        this.setAwake(true);
        this.setBossFight(true);
        if (this.getDungeon() != null) {
            this.closeRoom();
        }
    }

    private void evaporate() {
        AABB entity = this.m_20191_();
        BlockPos min = BlockPos.m_274561_((double)(entity.f_82288_ - 1.0), (double)(entity.f_82289_ - 1.0), (double)(entity.f_82290_ - 1.0));
        BlockPos max = BlockPos.m_274561_((double)(Math.ceil(entity.f_82291_ - 1.0) + 1.0), (double)(Math.ceil(entity.f_82292_ - 1.0) + 1.0), (double)(Math.ceil(entity.f_82293_ - 1.0) + 1.0));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            if (this.f_19853_.m_8055_(pos).m_60734_() instanceof LiquidBlock) {
                this.f_19853_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                this.evaporateEffects(pos);
                continue;
            }
            if (this.f_19853_.m_6425_(pos).m_76178_() || !this.f_19853_.m_8055_(pos).m_61138_((Property)BlockStateProperties.f_61362_)) continue;
            this.f_19853_.m_46597_(pos, (BlockState)this.f_19853_.m_8055_(pos).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            this.evaporateEffects(pos);
        }
    }

    private void evaporateEffects(BlockPos pos) {
        this.blockDestroySmoke(pos);
        this.f_19853_.m_5594_(null, pos, (SoundEvent)AetherSoundEvents.WATER_EVAPORATE.get(), SoundSource.BLOCKS, 0.5f, 2.6f + (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.8f);
    }

    private void stop() {
        this.m_20256_(Vec3.f_82478_);
    }

    @Override
    public void reset() {
        this.stop();
        this.setAwake(false);
        this.setBossFight(false);
        this.m_6710_(null);
        this.m_21153_(this.m_21233_());
        if (this.getDungeon() != null) {
            this.m_146884_(this.getDungeon().originCoordinates());
            this.openRoom();
        }
    }

    @Override
    @Nullable
    public BlockState convertBlock(BlockState state) {
        if (state.m_60713_((Block)AetherBlocks.LOCKED_CARVED_STONE.get())) {
            return ((Block)AetherBlocks.CARVED_STONE.get()).m_49966_();
        }
        if (state.m_60713_((Block)AetherBlocks.LOCKED_SENTRY_STONE.get())) {
            return ((Block)AetherBlocks.SENTRY_STONE.get()).m_49966_();
        }
        if (state.m_60713_((Block)AetherBlocks.BOSS_DOORWAY_CARVED_STONE.get())) {
            return Blocks.f_50016_.m_49966_();
        }
        if (state.m_60713_((Block)AetherBlocks.TREASURE_DOORWAY_CARVED_STONE.get())) {
            return (BlockState)((TrapDoorBlock)AetherBlocks.SKYROOT_TRAPDOOR.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        }
        return null;
    }

    private void explode() {
        for (int i = 0; i < (this.m_21223_() <= 0.0f ? 16 : 48); ++i) {
            double x = this.m_20182_().m_7096_() + (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 1.5;
            double y = this.m_20191_().f_82289_ + 1.75 + (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 1.5;
            double z = this.m_20182_().m_7094_() + (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 1.5;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void blockDestroySmoke(BlockPos pos) {
        double a = (double)pos.m_123341_() + 0.5 + (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.375;
        double b = (double)pos.m_123342_() + 0.5 + (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.375;
        double c = (double)pos.m_123343_() + 0.5 + (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.375;
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, a, b, c, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void m_6457_(@Nonnull ServerPlayer player) {
        super.m_6457_(player);
        AetherPacketHandler.sendToPlayer(new BossInfoPacket.Display(this.bossFight.m_18860_()), player);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((Player)player)) {
            this.bossFight.m_6543_(player);
        }
    }

    public void m_6452_(@Nonnull ServerPlayer player) {
        super.m_6452_(player);
        AetherPacketHandler.sendToPlayer(new BossInfoPacket.Remove(this.bossFight.m_18860_()), player);
        this.bossFight.m_6539_(player);
    }

    @Override
    public void onDungeonPlayerAdded(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6543_(serverPlayer);
        }
    }

    @Override
    public void onDungeonPlayerRemoved(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6539_(serverPlayer);
        }
    }

    public boolean isAwake() {
        return (Boolean)this.f_19804_.m_135370_(DATA_AWAKE_ID);
    }

    public void setAwake(boolean ready) {
        this.f_19804_.m_135381_(DATA_AWAKE_ID, (Object)ready);
    }

    @Override
    public Component getBossName() {
        return (Component)this.f_19804_.m_135370_(DATA_BOSS_NAME_ID);
    }

    @Override
    public void setBossName(Component component) {
        this.f_19804_.m_135381_(DATA_BOSS_NAME_ID, (Object)component);
        this.bossFight.m_6456_(component);
    }

    public float getHurtAngleX() {
        return ((Float)this.f_19804_.m_135370_(DATA_HURT_ANGLE_X_ID)).floatValue();
    }

    public void setHurtAngleX(float hurtAngleX) {
        this.f_19804_.m_135381_(DATA_HURT_ANGLE_X_ID, (Object)Float.valueOf(hurtAngleX));
    }

    public float getHurtAngleZ() {
        return ((Float)this.f_19804_.m_135370_(DATA_HURT_ANGLE_Z_ID)).floatValue();
    }

    public void setHurtAngleZ(float hurtAngleZ) {
        this.f_19804_.m_135381_(DATA_HURT_ANGLE_Z_ID, (Object)Float.valueOf(hurtAngleZ));
    }

    public float getHurtAngle() {
        return ((Float)this.f_19804_.m_135370_(DATA_HURT_ANGLE_ID)).floatValue();
    }

    public void setHurtAngle(float hurtAngle) {
        this.f_19804_.m_135381_(DATA_HURT_ANGLE_ID, (Object)Float.valueOf(hurtAngle));
    }

    @Override
    public BossRoomTracker<Slider> getDungeon() {
        return this.bronzeDungeon;
    }

    @Override
    public void setDungeon(BossRoomTracker<Slider> dungeon) {
        this.bronzeDungeon = dungeon;
    }

    @Override
    public int getDeathScore() {
        return this.f_20897_;
    }

    @Override
    public boolean isBossFight() {
        return this.bossFight.m_8323_();
    }

    @Override
    public void setBossFight(boolean isFighting) {
        this.bossFight.m_8321_(isFighting);
    }

    public boolean isCritical() {
        return this.m_21223_() <= 100.0f;
    }

    public int calculateMoveDelay() {
        return this.isCritical() ? 1 + this.f_19796_.m_188503_(10) : 2 + this.f_19796_.m_188503_(14);
    }

    protected float getVelocityIncrease() {
        return this.isCritical() ? 0.045f - this.m_21223_() / 10000.0f : 0.035f - this.m_21223_() / 30000.0f;
    }

    protected float getMaxVelocity() {
        return 2.5f;
    }

    protected SoundEvent getAwakenSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_AWAKEN.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_AMBIENT.get();
    }

    public SoundEvent getCollideSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_COLLIDE.get();
    }

    public SoundEvent getMoveSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_MOVE.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_DEATH.get();
    }

    @Nonnull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.setBossName(name);
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_();
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public boolean m_6128_() {
        return true;
    }

    public float m_146908_() {
        return 0.0f;
    }

    protected boolean m_7341_(@Nonnull Entity vehicle) {
        return false;
    }

    public boolean m_5829_() {
        return !this.isAwake();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_147223_() {
        return true;
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_146890_() {
        return false;
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        this.addBossSaveData(tag);
        tag.m_128379_("Awake", this.isAwake());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        this.readBossSaveData(tag);
        if (tag.m_128441_("Awake")) {
            this.setAwake(tag.m_128471_("Awake"));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.addBossSaveData(tag);
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag tag = additionalData.m_130260_();
        if (tag != null) {
            this.readBossSaveData(tag);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getChatCooldown() {
        return this.chatCooldown;
    }

    public void setChatCooldown(int cooldown) {
        this.chatCooldown = cooldown;
    }
}

