/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss.slider;

import com.aetherteam.aether.entity.ai.brain.memory.AetherMemoryModuleTypes;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.Slider;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.SliderAi;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class Move
extends Behavior<Slider> {
    private float velocity;

    public Move() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DELAY.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DIRECTION.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)AetherMemoryModuleTypes.TARGET_POSITION.get()), (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.REGISTERED));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Slider slider) {
        return slider.isAwake() && !slider.m_21224_();
    }

    protected boolean canStillUse(ServerLevel level, Slider slider, long gameTime) {
        if (!slider.isAwake() || slider.m_21224_()) {
            return false;
        }
        if (slider.m_6274_().m_21874_((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DELAY.get())) {
            return false;
        }
        return !slider.f_19862_ && !slider.f_19863_;
    }

    protected void start(ServerLevel level, Slider slider, long pGameTime) {
        slider.m_6274_().m_21936_((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DIRECTION.get());
        slider.m_5496_(slider.getMoveSound(), 2.5f, 1.0f / (slider.m_217043_().m_188501_() * 0.2f + 0.9f));
    }

    protected void tick(ServerLevel level, Slider slider, long gameTime) {
        Brain brain = slider.m_6274_();
        Vec3 targetPoint = SliderAi.getTargetPoint(brain);
        if (targetPoint == null) {
            this.m_22562_(level, (LivingEntity)slider, gameTime);
            return;
        }
        Direction moveDir = Move.getMoveDirection(slider, targetPoint);
        if (Move.axisDistance(targetPoint.f_82479_ - slider.m_20185_(), targetPoint.f_82480_ - slider.m_20186_(), targetPoint.f_82481_ - slider.m_20189_(), moveDir) <= 0.0) {
            this.m_22562_(level, (LivingEntity)slider, gameTime);
            return;
        }
        if (this.velocity < slider.getMaxVelocity()) {
            this.velocity = Math.min(slider.getMaxVelocity(), this.velocity + slider.getVelocityIncrease());
        }
        Vec3 movement = new Vec3((double)((float)moveDir.m_122429_() * this.velocity), (double)((float)moveDir.m_122430_() * this.velocity), (double)((float)moveDir.m_122431_() * this.velocity));
        slider.m_20256_(movement);
    }

    protected void stop(ServerLevel level, Slider slider, long gameTime) {
        slider.m_6274_().m_21882_((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DELAY.get(), (Object)Unit.INSTANCE, (long)slider.calculateMoveDelay());
        slider.m_6274_().m_21936_((MemoryModuleType)AetherMemoryModuleTypes.TARGET_POSITION.get());
        this.velocity = 0.0f;
        slider.m_20256_(Vec3.f_82478_);
    }

    private static Direction getMoveDirection(Slider slider, Vec3 targetPoint) {
        Direction moveDir;
        Brain brain = slider.m_6274_();
        Optional optionalDir = brain.m_21952_((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DIRECTION.get());
        if (optionalDir.isEmpty()) {
            double x = targetPoint.f_82479_ - slider.m_20185_();
            double y = targetPoint.f_82480_ - slider.m_20186_();
            double z = targetPoint.f_82481_ - slider.m_20189_();
            moveDir = SliderAi.calculateDirection(x, y, z);
            brain.m_21879_((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DIRECTION.get(), (Object)moveDir);
        } else {
            moveDir = (Direction)optionalDir.get();
        }
        return moveDir;
    }

    private static double axisDistance(double x, double y, double z, Direction direction) {
        return x * (double)direction.m_122429_() + y * (double)direction.m_122430_() + z * (double)direction.m_122431_();
    }
}

