/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss.slider;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.entity.ai.brain.memory.AetherMemoryModuleTypes;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.Slider;
import com.aetherteam.aether.entity.monster.dungeon.boss.slider.SliderAi;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AvoidObstacles
extends Behavior<Slider> {
    public AvoidObstacles() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DIRECTION.get()), (Object)MemoryStatus.REGISTERED));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Slider slider) {
        if (!slider.isAwake() || slider.m_21224_() || slider.m_6274_().m_147341_((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DELAY.get()) != 1L) {
            return false;
        }
        Brain brain = slider.m_6274_();
        Direction direction = brain.m_21952_((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DIRECTION.get()).orElse(Direction.UP);
        return direction.m_122434_() != Direction.Axis.Y;
    }

    protected void start(ServerLevel level, Slider slider, long gameTime) {
        Brain brain = slider.m_6274_();
        Vec3 targetPos = SliderAi.getTargetPoint(brain);
        if (targetPos == null) {
            return;
        }
        Direction direction = SliderAi.calculateDirection(targetPos.f_82479_ - slider.m_20185_(), targetPos.f_82480_ - slider.m_20186_(), targetPos.f_82481_ - slider.m_20189_());
        AABB collisionBox = SliderAi.calculateAdjacentBox(slider.m_20191_(), direction);
        boolean isTouchingWall = false;
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)collisionBox.f_82288_), (int)Mth.m_14107_((double)collisionBox.f_82289_), (int)Mth.m_14107_((double)collisionBox.f_82290_), (int)Mth.m_14165_((double)(collisionBox.f_82291_ - 1.0)), (int)Mth.m_14165_((double)(collisionBox.f_82292_ - 1.0)), (int)Mth.m_14165_((double)(collisionBox.f_82293_ - 1.0)))) {
            if (!slider.f_19853_.m_8055_(pos).m_204336_(AetherTags.Blocks.SLIDER_UNBREAKABLE)) continue;
            isTouchingWall = true;
            break;
        }
        if (isTouchingWall) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int y = Mth.m_14107_((double)collisionBox.f_82289_);
            while (isTouchingWall) {
                ++y;
                isTouchingWall = false;
                int x = Mth.m_14107_((double)collisionBox.f_82288_);
                while ((double)x < collisionBox.f_82291_) {
                    int z = Mth.m_14107_((double)collisionBox.f_82290_);
                    while ((double)z < collisionBox.f_82293_) {
                        if (slider.f_19853_.m_8055_((BlockPos)pos.m_122178_(x, y, z)).m_204336_(AetherTags.Blocks.SLIDER_UNBREAKABLE)) {
                            isTouchingWall = true;
                        }
                        ++z;
                    }
                    ++x;
                }
            }
            Vec3 currentPos = slider.m_20182_();
            brain.m_21879_((MemoryModuleType)AetherMemoryModuleTypes.TARGET_POSITION.get(), (Object)new Vec3(currentPos.f_82479_, (double)y, currentPos.f_82481_));
            brain.m_21879_((MemoryModuleType)AetherMemoryModuleTypes.MOVE_DIRECTION.get(), (Object)Direction.UP);
        }
    }
}

