/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss;

import com.aetherteam.aether.api.BossNameGenerator;
import com.aetherteam.aether.api.BossRoomTracker;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.gui.screen.ValkyrieQueenDialogueScreen;
import com.aetherteam.aether.data.resources.registries.AetherStructures;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.BossMob;
import com.aetherteam.aether.entity.NpcDialogue;
import com.aetherteam.aether.entity.ai.AetherBlockPathTypes;
import com.aetherteam.aether.entity.ai.goal.NpcDialogueGoal;
import com.aetherteam.aether.entity.monster.dungeon.AbstractValkyrie;
import com.aetherteam.aether.entity.projectile.crystal.ThunderCrystal;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.BossInfoPacket;
import com.aetherteam.aether.network.packet.client.OpenNpcDialoguePacket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class ValkyrieQueen
extends AbstractValkyrie
implements BossMob<ValkyrieQueen>,
NpcDialogue,
IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Boolean> DATA_IS_READY = SynchedEntityData.m_135353_(ValkyrieQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Component> DATA_BOSS_NAME = SynchedEntityData.m_135353_(ValkyrieQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    @Nullable
    private Player tradingPlayer;
    private BossRoomTracker<ValkyrieQueen> dungeon;
    private AABB dungeonBounds;
    private final ServerBossEvent bossFight = new ServerBossEvent(this.getBossName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public ValkyrieQueen(EntityType<? extends ValkyrieQueen> type, Level level) {
        super(type, level);
        this.bossFight.m_8321_(false);
        this.f_21364_ = 50;
        this.m_21441_(AetherBlockPathTypes.BOSS_DOORWAY, -1.0f);
        this.m_21530_();
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnGroupData, compoundTag);
        this.setBossName((Component)BossNameGenerator.generateValkyrieName());
        if (compoundTag != null && compoundTag.m_128441_("Dungeon")) {
            StructureManager manager = level.m_6018_().m_215010_();
            manager.m_220521_().m_6632_(Registries.f_256944_).ifPresent(registry -> {
                StructureStart start;
                Structure temple = (Structure)registry.m_6246_(AetherStructures.SILVER_DUNGEON);
                if (temple != null && (start = manager.m_220494_(this.m_20183_(), temple)) != StructureStart.f_73561_) {
                    BoundingBox box = start.m_73601_();
                    AABB dungeonBounds = new AABB((double)box.m_162395_(), (double)box.m_162396_(), (double)box.m_162398_(), (double)(box.m_162399_() + 1), (double)(box.m_162400_() + 1), (double)(box.m_162401_() + 1));
                    this.setDungeonBounds(dungeonBounds);
                }
            });
        }
        return data;
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new NpcDialogueGoal<ValkyrieQueen>(this));
        this.f_21345_.m_25352_(1, (Goal)new GetUnstuckGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ThunderCrystalAttackGoal((Mob)this, 450, 28.0f));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> this.isBossFight()));
    }

    @Nonnull
    public static AttributeSupplier.Builder createQueenAttributes() {
        return AbstractValkyrie.createAttributes().m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22281_, 13.5).m_22268_(Attributes.f_22276_, 500.0);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_READY, (Object)false);
        this.f_19804_.m_135372_(DATA_BOSS_NAME, (Object)Component.m_237113_((String)"Valkyrie Queen"));
    }

    @Override
    public void m_8024_() {
        super.m_8024_();
        this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
        this.trackDungeon();
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && !this.isBossFight() && !this.f_19853_.f_46443_) {
            if (!this.isReady()) {
                this.m_21391_((Entity)player, 180.0f, 180.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!this.isTrading()) {
                        AetherPacketHandler.sendToPlayer(new OpenNpcDialoguePacket(this.m_19879_()), serverPlayer);
                        this.setTradingPlayer((Player)serverPlayer);
                    }
                }
            } else {
                this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.queen.dialog.ready"));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        Entity entity;
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (this.isReady() && (entity = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (this.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
                if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((Entity)attacker)) {
                    if (super.m_6469_(source, amount) && this.m_21223_() > 0.0f) {
                        if (!this.f_19853_.m_5776_() && !this.isBossFight()) {
                            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.queen.dialog.fight"));
                            this.setBossFight(true);
                            if (this.getDungeon() != null) {
                                this.closeRoom();
                            }
                        }
                        return true;
                    }
                } else if (!this.f_19853_.m_5776_() && attacker instanceof Player) {
                    Player player = (Player)attacker;
                    this.displayTooFarMessage(player);
                    return false;
                }
            }
        }
        return false;
    }

    public boolean m_7327_(@Nonnull Entity pEntity) {
        ServerPlayer player;
        boolean result = super.m_7327_(pEntity);
        if (pEntity instanceof ServerPlayer && (player = (ServerPlayer)pEntity).m_21223_() <= 0.0f) {
            this.chatItUp((Player)player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.playerdeath"));
        }
        return result;
    }

    public void m_6667_(@Nonnull DamageSource pCause) {
        if (!this.f_19853_.f_46443_) {
            this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
            this.chatWithNearby((Component)Component.m_237115_((String)"gui.aether.queen.dialog.defeated"));
            this.spawnExplosionParticles();
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(pCause);
                this.tearDownRoom();
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    public void tearDownRoom() {
        for (BlockPos pos : BlockPos.m_121976_((int)((int)this.dungeonBounds.f_82288_), (int)((int)this.dungeonBounds.f_82289_), (int)((int)this.dungeonBounds.f_82290_), (int)((int)this.dungeonBounds.f_82291_), (int)((int)this.dungeonBounds.f_82292_), (int)((int)this.dungeonBounds.f_82293_))) {
            BlockState state = this.f_19853_.m_8055_(pos);
            BlockState newState = this.convertBlock(state);
            if (newState == null) continue;
            this.f_19853_.m_7731_(pos, newState, 3);
        }
    }

    @Override
    protected boolean teleportAroundTarget(Entity target) {
        Vec2 targetVec = new Vec2(this.f_19796_.m_188501_() - 0.5f, this.f_19796_.m_188501_() - 0.5f).m_165902_();
        double x = target.m_20185_() + (double)(targetVec.f_82470_ * 7.0f);
        double y = target.m_20186_();
        double z = target.m_20189_() + (double)(targetVec.f_82471_ * 7.0f);
        if (this.dungeon != null) {
            AABB room = this.dungeon.roomBounds();
            x = Mth.m_14008_((double)x, (double)(room.f_82288_ + 1.0), (double)(room.f_82291_ - 1.0));
            y = Mth.m_14008_((double)y, (double)(room.f_82289_ + 1.0), (double)(room.f_82292_ - 1.0));
            z = Mth.m_14008_((double)z, (double)(room.f_82290_ + 1.0), (double)(room.f_82293_ - 1.0));
        }
        return this.teleport(x, y, z);
    }

    protected boolean teleportUnstuck(Entity target) {
        return this.teleport(target.m_20185_(), target.m_20186_(), target.m_20189_());
    }

    public void readyUp() {
        MutableComponent message = Component.m_237115_((String)"gui.aether.queen.dialog.begin");
        this.chatWithNearby((Component)message);
        this.setReady(true);
    }

    @Override
    protected void chatItUp(Player player, Component message) {
        player.m_213846_((Component)Component.m_237113_((String)"[").m_7220_((Component)this.getBossName().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_("]: ").m_7220_(message));
    }

    protected void chatWithNearby(Component message) {
        AABB room = this.dungeon == null ? this.m_20191_().m_82400_(16.0) : this.dungeon.roomBounds();
        this.f_19853_.m_45955_(NON_COMBAT, (LivingEntity)this, room).forEach(player -> this.chatItUp((Player)player, message));
    }

    public void m_6457_(@Nonnull ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        AetherPacketHandler.sendToPlayer(new BossInfoPacket.Display(this.bossFight.m_18860_()), pPlayer);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((Player)pPlayer)) {
            this.bossFight.m_6543_(pPlayer);
        }
    }

    public void m_6452_(@Nonnull ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        AetherPacketHandler.sendToPlayer(new BossInfoPacket.Remove(this.bossFight.m_18860_()), pPlayer);
        this.bossFight.m_6539_(pPlayer);
    }

    @Override
    public void onDungeonPlayerAdded(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6543_(serverPlayer);
        }
    }

    @Override
    public void onDungeonPlayerRemoved(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6539_(serverPlayer);
        }
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.setBossName(pName);
    }

    public boolean isReady() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_READY);
    }

    public void setReady(boolean ready) {
        this.f_19804_.m_135381_(DATA_IS_READY, (Object)ready);
    }

    @Override
    public Component getBossName() {
        return (Component)this.f_19804_.m_135370_(DATA_BOSS_NAME);
    }

    @Override
    public void setBossName(Component component) {
        this.f_19804_.m_135381_(DATA_BOSS_NAME, (Object)component);
        this.bossFight.m_6456_(component);
    }

    @Override
    public boolean isBossFight() {
        return this.bossFight.m_8323_();
    }

    @Override
    public void setBossFight(boolean isFighting) {
        this.bossFight.m_8321_(isFighting);
    }

    @Override
    public BossRoomTracker<ValkyrieQueen> getDungeon() {
        return this.dungeon;
    }

    @Override
    public void setDungeon(BossRoomTracker<ValkyrieQueen> dungeon) {
        this.dungeon = dungeon;
        if (this.dungeonBounds == null) {
            this.dungeonBounds = dungeon.roomBounds();
        }
    }

    public void setDungeonBounds(AABB dungeonBounds) {
        this.dungeonBounds = dungeonBounds;
    }

    @Override
    public int getDeathScore() {
        return this.f_20897_;
    }

    @Override
    public void reset() {
        this.setBossFight(false);
        this.m_6710_(null);
        this.m_21153_(this.m_21233_());
        if (this.getDungeon() != null) {
            this.openRoom();
        }
    }

    @Override
    @Nullable
    public BlockState convertBlock(BlockState state) {
        if (state.m_60713_((Block)AetherBlocks.LOCKED_ANGELIC_STONE.get()) || state.m_60713_((Block)AetherBlocks.TRAPPED_ANGELIC_STONE.get())) {
            return ((Block)AetherBlocks.ANGELIC_STONE.get()).m_49966_();
        }
        if (state.m_60713_((Block)AetherBlocks.LOCKED_LIGHT_ANGELIC_STONE.get()) || state.m_60713_((Block)AetherBlocks.TRAPPED_LIGHT_ANGELIC_STONE.get())) {
            return ((Block)AetherBlocks.LIGHT_ANGELIC_STONE.get()).m_49966_();
        }
        if (state.m_60713_((Block)AetherBlocks.BOSS_DOORWAY_ANGELIC_STONE.get())) {
            return Blocks.f_50016_.m_49966_();
        }
        if (state.m_60713_((Block)AetherBlocks.TREASURE_DOORWAY_ANGELIC_STONE.get())) {
            return (BlockState)((TrapDoorBlock)AetherBlocks.SKYROOT_TRAPDOOR.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        }
        return null;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource pDamageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_DEATH.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openDialogueScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new ValkyrieQueenDialogueScreen(this));
    }

    @Override
    public void handleNpcInteraction(Player player, byte interactionID) {
        block0 : switch (interactionID) {
            case 0: {
                this.chatItUp(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.answer"));
                break;
            }
            case 1: {
                if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
                    this.chatItUp(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.peaceful"));
                    break;
                }
                if (player.m_150109_().m_18947_((Item)AetherItems.VICTORY_MEDAL.get()) >= 10) {
                    this.readyUp();
                    int count = 10;
                    for (ItemStack item : player.f_36095_.m_38927_()) {
                        if (item.m_150930_((Item)AetherItems.VICTORY_MEDAL.get())) {
                            if (item.m_41613_() > count) {
                                item.m_41774_(count);
                                break block0;
                            }
                            count -= item.m_41613_();
                            item.m_41764_(0);
                        }
                        if (count > 0) continue;
                        break block0;
                    }
                    break;
                }
                this.chatItUp(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.no_medals"));
                break;
            }
            case 2: {
                this.chatItUp(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.deny_fight"));
                break;
            }
            default: {
                this.chatItUp(player, (Component)Component.m_237115_((String)"gui.aether.queen.dialog.goodbye"));
            }
        }
        this.setTradingPlayer(null);
    }

    @Override
    @Nullable
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    @Override
    public void setTradingPlayer(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        this.addBossSaveData(tag);
        if (this.dungeonBounds != null) {
            tag.m_128347_("DungeonBoundsMinX", this.dungeonBounds.f_82288_);
            tag.m_128347_("DungeonBoundsMinY", this.dungeonBounds.f_82289_);
            tag.m_128347_("DungeonBoundsMinZ", this.dungeonBounds.f_82290_);
            tag.m_128347_("DungeonBoundsMaxX", this.dungeonBounds.f_82291_);
            tag.m_128347_("DungeonBoundsMaxY", this.dungeonBounds.f_82292_);
            tag.m_128347_("DungeonBoundsMaxZ", this.dungeonBounds.f_82293_);
        }
        tag.m_128379_("Ready", this.isReady());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        this.readBossSaveData(tag);
        if (tag.m_128441_("DungeonBoundsMinX")) {
            double minX = tag.m_128459_("DungeonBoundsMinX");
            double minY = tag.m_128459_("DungeonBoundsMinY");
            double minZ = tag.m_128459_("DungeonBoundsMinZ");
            double maxX = tag.m_128459_("DungeonBoundsMaxX");
            double maxY = tag.m_128459_("DungeonBoundsMaxY");
            double maxZ = tag.m_128459_("DungeonBoundsMaxZ");
            this.dungeonBounds = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        }
        if (tag.m_128441_("Ready")) {
            this.setReady(tag.m_128471_("Ready"));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.addBossSaveData(tag);
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag tag = additionalData.m_130260_();
        if (tag != null) {
            this.readBossSaveData(tag);
        }
    }

    public void m_6043_() {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static class GetUnstuckGoal
    extends Goal {
        private final ValkyrieQueen valkyrie;
        protected int stuckTimer;

        public GetUnstuckGoal(ValkyrieQueen valkyrie) {
            this.valkyrie = valkyrie;
        }

        public boolean m_8036_() {
            LivingEntity target = this.valkyrie.m_5448_();
            if (target == null) {
                return false;
            }
            if (target.m_20186_() > this.valkyrie.m_20186_()) {
                if (this.stuckTimer++ >= 75) {
                    this.stuckTimer = 0;
                    return true;
                }
            } else {
                this.stuckTimer = 0;
            }
            return false;
        }

        public void m_8056_() {
            this.valkyrie.teleportUnstuck((Entity)this.valkyrie.m_5448_());
        }
    }

    public static class ThunderCrystalAttackGoal
    extends Goal {
        private final Mob mob;
        @Nullable
        private LivingEntity target;
        private final int attackInterval;
        private int attackTime = 0;
        private final float attackRadius;

        public ThunderCrystalAttackGoal(Mob mob, int attackInterval, float attackRadius) {
            this.mob = mob;
            this.attackInterval = attackInterval;
            this.attackRadius = attackRadius;
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null && target.m_6084_()) {
                this.target = target;
                return this.mob.f_19853_.m_46791_() != Difficulty.PEACEFUL;
            }
            return false;
        }

        public void m_8037_() {
            double distance = this.mob.m_20270_((Entity)this.target);
            if (distance < (double)this.attackRadius && ++this.attackTime >= this.attackInterval) {
                ThunderCrystal thunderCrystal = new ThunderCrystal((EntityType<? extends ThunderCrystal>)((EntityType)AetherEntityTypes.THUNDER_CRYSTAL.get()), this.mob.f_19853_, (Entity)this.mob, (Entity)this.target);
                this.mob.f_19853_.m_7967_((Entity)thunderCrystal);
                this.attackTime = this.mob.m_217043_().m_188503_(40);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

