/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.SentryExplosionParticlePacket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;

public class Sentry
extends Slime {
    public static final EntityDataAccessor<Boolean> DATA_AWAKE_ID = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float timeSpotted = 0.0f;

    public Sentry(EntityType<? extends Sentry> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new KeepOnJumpingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> Math.abs(entity.m_20186_() - this.m_20186_()) <= 4.0));
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.6).m_22266_(Attributes.f_22281_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_AWAKE_ID, (Object)false);
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.m_7839_(1, true);
        this.m_21559_(false);
        return spawnData;
    }

    public void m_8119_() {
        if (this.f_19853_.m_5788_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 8.0, EntitySelector.f_20408_) != null) {
            if (!this.isAwake()) {
                if (this.timeSpotted >= 24.0f) {
                    this.setAwake(true);
                }
                this.timeSpotted += 1.0f;
            }
        } else {
            this.setAwake(false);
        }
        super.m_8119_();
    }

    protected void m_6135_() {
        if (this.isAwake()) {
            super.m_6135_();
        }
    }

    public void m_7334_(@Nonnull Entity entity) {
        super.m_7334_(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof Sentry)) {
                this.explodeAt(livingEntity);
            }
        }
    }

    public void m_6123_(@Nonnull Player player) {
        if (EntitySelector.f_20406_.test(player)) {
            this.explodeAt((LivingEntity)player);
        }
    }

    protected void explodeAt(LivingEntity livingEntity) {
        if (this.m_20280_((Entity)livingEntity) < 1.5 && this.isAwake() && this.m_142582_((Entity)livingEntity) && livingEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f) && this.f_19797_ > 20 && this.m_6084_()) {
            livingEntity.m_5997_(0.3, 0.4, 0.3);
            this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.MOB);
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 0.2f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) + 1.0f);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                AetherPacketHandler.sendToNear(new SentryExplosionParticlePacket(this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0, (ResourceKey<Level>)level2.m_46472_());
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.5);
            }
            this.m_19970_((LivingEntity)this, (Entity)livingEntity);
            this.m_146870_();
        }
    }

    public void m_142687_(@Nonnull Entity.RemovalReason reason) {
        this.m_142467_(reason);
        if (reason == Entity.RemovalReason.KILLED) {
            this.m_146850_(GameEvent.f_223707_);
        }
        this.invalidateCaps();
    }

    public boolean isAwake() {
        return (Boolean)this.f_19804_.m_135370_(DATA_AWAKE_ID);
    }

    public void setAwake(boolean awake) {
        this.f_19804_.m_135381_(DATA_AWAKE_ID, (Object)awake);
    }

    public void m_7839_(int size, boolean resetHealth) {
    }

    @Nonnull
    protected ParticleOptions m_6300_() {
        return new BlockParticleOption(ParticleTypes.f_123794_, ((Block)AetherBlocks.SENTRY_STONE.get()).m_49966_());
    }

    @Nonnull
    protected ResourceLocation m_7582_() {
        return this.m_6095_().m_20677_();
    }

    @Nonnull
    public EntityType<? extends Sentry> m_6095_() {
        return super.m_6095_();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_SENTRY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SENTRY_DEATH.get();
    }

    @Nonnull
    protected SoundEvent m_7905_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SENTRY_JUMP.get();
    }

    @Nonnull
    protected SoundEvent m_7903_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SENTRY_JUMP.get();
    }

    @Nonnull
    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.758f);
    }

    protected boolean m_8028_() {
        return true;
    }

    public static class FloatGoal
    extends Slime.SlimeFloatGoal {
        private final Sentry sentry;

        public FloatGoal(Sentry sentryIn) {
            super((Slime)sentryIn);
            this.sentry = sentryIn;
        }

        public boolean m_8036_() {
            return this.sentry.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.sentry.isAwake() && super.m_8045_();
        }
    }

    public static class AttackGoal
    extends Slime.SlimeAttackGoal {
        private final Sentry sentry;

        public AttackGoal(Sentry sentryIn) {
            super((Slime)sentryIn);
            this.sentry = sentryIn;
        }

        public boolean m_8036_() {
            return this.sentry.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.sentry.isAwake() && super.m_8045_();
        }
    }

    public static class RandomDirectionGoal
    extends Slime.SlimeRandomDirectionGoal {
        private final Sentry sentry;

        public RandomDirectionGoal(Sentry sentryIn) {
            super((Slime)sentryIn);
            this.sentry = sentryIn;
        }

        public boolean m_8036_() {
            return this.sentry.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.sentry.isAwake() && super.m_8045_();
        }
    }

    public static class KeepOnJumpingGoal
    extends Slime.SlimeKeepOnJumpingGoal {
        private final Sentry sentry;

        public KeepOnJumpingGoal(Sentry sentryIn) {
            super((Slime)sentryIn);
            this.sentry = sentryIn;
        }

        public boolean m_8036_() {
            return this.sentry.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.sentry.isAwake() && super.m_8045_();
        }
    }
}

