/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.projectile.ZephyrSnowball;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Zephyr
extends FlyingMob
implements Enemy {
    public static final EntityDataAccessor<Integer> DATA_ATTACK_CHARGE_ID = SynchedEntityData.m_135353_(Zephyr.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int scale;
    public int scaleAdd;
    public float tailRot;
    public float tailRotAdd;

    public Zephyr(EntityType<? extends Zephyr> type, Level level) {
        super(type, level);
        this.f_21342_ = new MoveHelperController(this);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SnowballAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return FlyingMob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ATTACK_CHARGE_ID, (Object)0);
    }

    public static boolean checkZephyrSpawnRules(EntityType<? extends Zephyr> zephyr, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && Mob.m_217057_(zephyr, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && (reason != MobSpawnType.NATURAL || random.m_188503_(11) == 0) && level.m_45527_(pos);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20186_() < (double)(this.f_19853_.m_141937_() - 2) || this.m_20186_() > (double)this.f_19853_.m_151558_()) {
            this.m_146870_();
        }
        this.scale += this.scaleAdd;
        this.tailRot += this.tailRotAdd;
        if (this.getAttackCharge() > 0 && this.scale < 40) {
            this.scaleAdd = 1;
        } else {
            this.scaleAdd = 0;
            this.scale = 0;
        }
        this.tailRotAdd = 0.015f;
        if (this.tailRot >= (float)Math.PI * 2) {
            this.tailRot -= (float)Math.PI * 2;
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }

    public int getAttackCharge() {
        return (Integer)this.f_19804_.m_135370_(DATA_ATTACK_CHARGE_ID);
    }

    public void setAttackCharge(int attackTimer) {
        this.f_19804_.m_135381_(DATA_ATTACK_CHARGE_ID, (Object)Math.max(attackTimer, 0));
    }

    protected float m_6121_() {
        return 3.0f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_DEATH.get();
    }

    protected boolean m_8028_() {
        return true;
    }

    protected static class MoveHelperController
    extends MoveControl {
        private final Zephyr parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(Zephyr zephyr) {
            super((Mob)zephyr);
            this.parentEntity = zephyr;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.m_217043_().m_188503_(5) + 2;
                Vec3 vec3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vec3d.m_82553_();
                if (this.isNotColliding(vec3d = vec3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vec3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean isNotColliding(Vec3 pos, int distance) {
            AABB axisalignedbb = this.parentEntity.m_20191_();
            for (int i = 1; i < distance; ++i) {
                if (this.parentEntity.f_19853_.m_45756_((Entity)this.parentEntity, axisalignedbb = axisalignedbb.m_82383_(pos))) continue;
                return false;
            }
            return true;
        }
    }

    protected static class RandomFlyGoal
    extends Goal {
        private final Zephyr parentEntity;

        public RandomFlyGoal(Zephyr entity) {
            this.parentEntity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl moveControl = this.parentEntity.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d0 = moveControl.m_25000_() - this.parentEntity.m_20185_();
            double d3 = d0 * d0 + (d1 = moveControl.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = moveControl.m_25002_() - this.parentEntity.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.parentEntity.m_217043_();
            double d0 = this.parentEntity.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    protected static class LookAroundGoal
    extends Goal {
        private final Zephyr parentEntity;

        public LookAroundGoal(Zephyr zephyr) {
            this.parentEntity = zephyr;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.parentEntity.m_5448_() == null) {
                Vec3 vec3d = this.parentEntity.m_20184_();
                this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_)) * 57.295776f);
                this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
            } else {
                LivingEntity livingEntity = this.parentEntity.m_5448_();
                if (livingEntity.m_20280_((Entity)this.parentEntity) < 4096.0) {
                    double x = livingEntity.m_20185_() - this.parentEntity.m_20185_();
                    double z = livingEntity.m_20189_() - this.parentEntity.m_20189_();
                    this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)x, (double)z)) * 57.295776f);
                    this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                }
            }
        }
    }

    protected static class SnowballAttackGoal
    extends Goal {
        private final Zephyr parentEntity;
        public int attackTimer;

        public SnowballAttackGoal(Zephyr zephyr) {
            this.parentEntity = zephyr;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8041_() {
            this.parentEntity.setAttackCharge(0);
        }

        public void m_8037_() {
            LivingEntity target = this.parentEntity.m_5448_();
            if (target.m_20280_((Entity)this.parentEntity) < 1600.0 && this.parentEntity.m_142582_((Entity)target)) {
                Level level = this.parentEntity.f_19853_;
                ++this.attackTimer;
                if (this.attackTimer == 10) {
                    this.parentEntity.m_5496_(this.parentEntity.m_7515_(), 3.0f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f + 1.0f);
                } else if (this.attackTimer == 20) {
                    Vec3 look = this.parentEntity.m_20252_(1.0f);
                    double accelX = target.m_20185_() - (this.parentEntity.m_20185_() + look.f_82479_ * 4.0);
                    double accelY = target.m_20227_(0.5) - (0.5 + this.parentEntity.m_20227_(0.5));
                    double accelZ = target.m_20189_() - (this.parentEntity.m_20189_() + look.f_82481_ * 4.0);
                    this.parentEntity.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_SHOOT.get(), 3.0f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f + 1.0f);
                    ZephyrSnowball snowball = new ZephyrSnowball(level, (LivingEntity)this.parentEntity, accelX, accelY, accelZ);
                    snowball.m_6034_(this.parentEntity.m_20185_() + look.f_82479_ * 4.0, this.parentEntity.m_20227_(0.5) + 0.5, this.parentEntity.m_20189_() + look.f_82481_ * 4.0);
                    level.m_7967_((Entity)snowball);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.setAttackCharge(this.attackTimer);
        }
    }
}

