/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.MountableMob;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.SwetAttackPacket;
import com.aetherteam.aether.network.packet.client.SwetDeathParticlePacket;
import com.aetherteam.aether.util.EquipmentUtil;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class Swet
extends Slime
implements MountableMob {
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_JUMPED_ID = SynchedEntityData.m_135353_(Swet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_MOUNT_JUMPING_ID = SynchedEntityData.m_135353_(Swet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_MID_JUMP_ID = SynchedEntityData.m_135353_(Swet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DEAD_IN_WATER_ID = SynchedEntityData.m_135353_(Swet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_WATER_DAMAGE_SCALE_ID = SynchedEntityData.m_135353_(Swet.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public boolean f_33583_;
    public int jumpTimer;
    public float swetHeight = 1.0f;
    public float oSwetHeight = 1.0f;
    public float swetWidth = 1.0f;
    public float oSwetWidth = 1.0f;

    public Swet(EntityType<? extends Swet> type, Level level) {
        super(type, level);
        this.f_21342_ = new MoveHelperController(this);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ConsumeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HuntGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomFacingGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new HopGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, target -> !this.isFriendlyTowardEntity((LivingEntity)target) && !(target.m_20201_() instanceof Swet)));
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 14.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PLAYER_JUMPED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_MOUNT_JUMPING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_MID_JUMP_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_DEAD_IN_WATER_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_WATER_DAMAGE_SCALE_ID, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> dataAccessor) {
        if (DATA_WATER_DAMAGE_SCALE_ID.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public static boolean checkSwetSpawnRules(EntityType<? extends Swet> swet, LevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && level.m_8055_(pos.m_7495_()).m_204336_(AetherTags.Blocks.SWET_SPAWNABLE_ON) && level.m_45524_(pos, 0) > 8;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_5448_() != null && (this.hasPrey() || this.isFriendlyTowardEntity(this.m_5448_()) || this.m_5448_().m_20201_() instanceof Swet)) {
            this.m_6710_(null);
        }
    }

    public void m_8119_() {
        if (this.m_20069_()) {
            this.dissolveSwetInWater();
        }
        if (this.getDeadInWater() && !(this.getWaterDamageScale() >= 1.0f)) {
            this.setWaterDamageScale(this.getWaterDamageScale() + 0.02f);
        }
        this.tick((Mob)this);
        this.riderTick((Mob)this);
        super.m_8119_();
        if (!this.hasPrey()) {
            double d = (float)this.m_20185_() + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.3f;
            double d1 = (float)this.m_20186_() + this.m_20206_();
            double d2 = (float)this.m_20189_() + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.3f;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, d, d1 - 0.25, d2, 0.0, 0.0, 0.0);
        }
        if (!this.m_21525_()) {
            this.setMidJump(!this.f_19861_);
            if (this.f_19853_.f_46443_) {
                this.oSwetHeight = this.swetHeight;
                this.oSwetWidth = this.swetWidth;
                this.jumpTimer = this.getMidJump() ? ++this.jumpTimer : 0;
                if (this.f_19861_) {
                    this.swetHeight = this.swetHeight < 1.0f ? this.swetHeight + 0.25f : 1.0f;
                    this.swetWidth = this.swetWidth > 1.0f ? this.swetWidth - 0.25f : 1.0f;
                } else {
                    this.swetHeight = 1.425f;
                    this.swetWidth = 0.875f;
                    if (this.getJumpTimer() > 3) {
                        float scale = Math.min(this.getJumpTimer(), 10);
                        this.swetHeight -= 0.05f * scale;
                        this.swetWidth += 0.05f * scale;
                    }
                }
            }
            this.f_33583_ = this.f_19861_;
        }
        if (this.isFriendly()) {
            this.m_183634_();
        }
    }

    protected boolean spawnCustomParticles() {
        return true;
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingEntity;
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity && this.isFriendlyTowardEntity(livingEntity = (LivingEntity)entity)) {
            return livingEntity;
        }
        return null;
    }

    public void m_7023_(@Nonnull Vec3 motion) {
        this.travel((Mob)this, motion);
        if (this.m_6084_()) {
            LivingEntity entity = this.m_6688_();
            if (this.m_20160_() && entity != null) {
                if (this.f_19861_ && !this.getPlayerJumped() && (this.m_20184_().f_82479_ != 0.0 || this.m_20184_().f_82481_ != 0.0)) {
                    this.m_20334_(this.m_20184_().m_7096_(), 0.42f, this.m_20184_().f_82481_);
                }
                this.m_183634_();
            }
        }
    }

    @Override
    public void travelWithInput(Vec3 motion) {
        super.m_7023_(motion);
    }

    @Nonnull
    public InteractionResult m_6071_(Player player, @Nonnull InteractionHand hand) {
        if (!this.f_19853_.f_46443_ && !this.hasPrey() && this.isFriendlyTowardEntity((LivingEntity)player)) {
            this.capturePrey((LivingEntity)player);
        }
        return InteractionResult.PASS;
    }

    public void capturePrey(LivingEntity livingEntity) {
        this.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_SWET_ATTACK.get(), 0.5f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.f_19860_ = this.m_146909_();
        this.m_146926_(livingEntity.m_146909_());
        this.f_19859_ = this.m_146908_();
        this.m_146922_(livingEntity.m_146908_());
        this.m_20256_(livingEntity.m_20184_());
        this.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_() + 0.01, livingEntity.m_20189_());
        livingEntity.m_7998_((Entity)this, true);
        this.m_146926_(this.f_19796_.m_188501_() * 360.0f);
    }

    public boolean hasPrey() {
        return this.m_146895_() != null;
    }

    public boolean isFriendlyTowardEntity(LivingEntity entity) {
        return EquipmentUtil.hasSwetCape(entity);
    }

    public void dissolveSwetInWater() {
        this.dissolveSwet();
        if (!this.getDeadInWater()) {
            this.setDeadInWater(true);
        }
    }

    public void dissolveSwetNormally() {
        this.dissolveSwet();
        this.m_146870_();
    }

    public void dissolveSwet() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            AetherPacketHandler.sendToNear(new SwetDeathParticlePacket(this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0, (ResourceKey<Level>)level2.m_46472_());
        }
    }

    protected void m_6153_() {
        if (this.getDeadInWater()) {
            if (this.getWaterDamageScale() >= 1.0f && !this.f_19853_.m_5776_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        } else {
            super.m_6153_();
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.m_142467_(pReason);
        this.invalidateCaps();
    }

    public boolean m_21224_() {
        return super.m_21224_() || this.getDeadInWater();
    }

    public boolean isFriendly() {
        return this.m_6688_() != null;
    }

    public int m_7549_() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    public void setMidJump(boolean flag) {
        this.f_19804_.m_135381_(DATA_MID_JUMP_ID, (Object)flag);
    }

    public boolean getMidJump() {
        return (Boolean)this.f_19804_.m_135370_(DATA_MID_JUMP_ID);
    }

    public void setDeadInWater(boolean flag) {
        this.f_19804_.m_135381_(DATA_DEAD_IN_WATER_ID, (Object)flag);
    }

    public boolean getDeadInWater() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DEAD_IN_WATER_ID);
    }

    public void setWaterDamageScale(float scale) {
        float i = Mth.m_14036_((float)scale, (float)0.0f, (float)1.0f);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22276_);
        if (attributeInstance != null) {
            attributeInstance.m_22100_(attributeInstance.m_22115_() * (double)(1.0f - i));
            if (attributeInstance.m_22115_() < (double)this.m_21223_()) {
                this.m_21153_(this.m_21233_());
            }
        }
        this.f_19804_.m_135381_(DATA_WATER_DAMAGE_SCALE_ID, (Object)Float.valueOf(i));
    }

    public float getWaterDamageScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_WATER_DAMAGE_SCALE_ID)).floatValue();
    }

    public int getJumpTimer() {
        return this.jumpTimer;
    }

    public float m_6118_() {
        return 0.5f;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_SWET_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SWET_DEATH.get();
    }

    protected SoundEvent m_7905_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SWET_SQUISH.get();
    }

    public double m_6048_() {
        return 1.4;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Nonnull
    public Vec3 m_7688_(@Nonnull LivingEntity livingEntity) {
        if (this.isFriendlyTowardEntity(livingEntity)) {
            return super.m_7688_(livingEntity);
        }
        return this.m_20182_();
    }

    protected boolean m_8028_() {
        return true;
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("WaterDamageScale", this.getWaterDamageScale());
        tag.m_128379_("DeadInWater", this.getDeadInWater());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("WaterDamageScale")) {
            this.setWaterDamageScale(tag.m_128457_("WaterDamageScale"));
        }
        if (tag.m_128441_("DeadInWater")) {
            this.setDeadInWater(tag.m_128471_("DeadInWater"));
        }
    }

    @Override
    public float getSteeringSpeed() {
        return 0.084f;
    }

    public float m_274460_() {
        return this.m_6688_() != null ? this.getSteeringSpeed() * 0.25f : 0.02f;
    }

    @Override
    public double getMountJumpStrength() {
        return 1.2;
    }

    @Override
    public double jumpFactor() {
        return this.m_20098_();
    }

    @Override
    public boolean getPlayerJumped() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLAYER_JUMPED_ID);
    }

    @Override
    public void setPlayerJumped(boolean playerJumped) {
        this.f_19804_.m_135381_(DATA_PLAYER_JUMPED_ID, (Object)playerJumped);
    }

    @Override
    public boolean isMountJumping() {
        return (Boolean)this.f_19804_.m_135370_(DATA_MOUNT_JUMPING_ID);
    }

    @Override
    public void setMountJumping(boolean isMountJumping) {
        this.f_19804_.m_135381_(DATA_MOUNT_JUMPING_ID, (Object)isMountJumping);
    }

    public float m_6134_() {
        return super.m_6134_() - super.m_6134_() * this.getWaterDamageScale();
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose pose) {
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    @Override
    public boolean canJump() {
        return this.m_20096_() && this.isFriendly();
    }

    public int m_33632_() {
        return this.m_20160_() ? 2 : 1;
    }

    public void m_7839_(int size, boolean resetHealth) {
    }

    protected boolean m_7483_() {
        return false;
    }

    public static class MoveHelperController
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final Swet swet;
        private boolean isAggressive;
        private boolean canJump;

        public MoveHelperController(Swet swet) {
            super((Mob)swet);
            this.swet = swet;
            this.yRot = 180.0f * swet.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean isAggressiveIn) {
            this.yRot = yRotIn;
            this.isAggressive = isAggressiveIn;
        }

        public void setWantedMovement(double speed) {
            this.f_24978_ = speed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void setCanJump(boolean canJump) {
            this.canJump = canJump;
        }

        public void m_8126_() {
            if (this.swet.isFriendly()) {
                return;
            }
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.swet.m_7549_();
                        if (this.isAggressive) {
                            this.jumpDelay /= 6;
                        }
                        this.swet.m_21569_().m_24901_();
                        this.swet.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_SWET_JUMP.get(), 1.0f, ((this.swet.f_19796_.m_188501_() - this.swet.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f);
                    } else {
                        this.swet.f_20900_ = 0.0f;
                        this.swet.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    public static class ConsumeGoal
    extends Goal {
        private final Swet swet;
        private int jumps = 0;
        private float chosenDegrees = 0.0f;

        public ConsumeGoal(Swet swet) {
            this.swet = swet;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity passenger;
            Object e;
            return this.swet.hasPrey() && (e = this.swet.m_20197_().get(0)) instanceof LivingEntity && !this.swet.isFriendlyTowardEntity(passenger = (LivingEntity)e);
        }

        public void m_8037_() {
            if (this.jumps <= 3) {
                if (this.swet.f_19861_) {
                    AetherPacketHandler.sendToNear(new SwetAttackPacket(this.swet.m_19879_(), this.swet.m_20185_(), this.swet.m_20186_(), this.swet.m_20189_()), this.swet.m_20185_(), this.swet.m_20186_(), this.swet.m_20189_(), 50.0, (ResourceKey<Level>)this.swet.m_9236_().m_46472_());
                    this.swet.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_SWET_JUMP.get(), 1.0f, ((this.swet.m_217043_().m_188501_() - this.swet.m_217043_().m_188501_()) * 0.2f + 1.0f) * 0.8f);
                    this.chosenDegrees = this.swet.m_217043_().m_188503_(360);
                    if (this.jumps == 0) {
                        this.swet.m_20256_(this.swet.m_20184_().m_82520_(0.0, 0.6499999940395356, 0.0));
                    } else if (this.jumps == 1) {
                        this.swet.m_20256_(this.swet.m_20184_().m_82520_(0.0, 0.7499999880790711, 0.0));
                    } else if (this.jumps == 2) {
                        this.swet.m_20256_(this.swet.m_20184_().m_82520_(0.0, 1.55, 0.0));
                    } else {
                        ((Entity)this.swet.m_20197_().get(0)).m_8127_();
                        this.swet.dissolveSwetNormally();
                    }
                    if (!this.swet.getMidJump()) {
                        ++this.jumps;
                    }
                }
                if (!this.swet.f_33583_ && this.swet.getJumpTimer() < 6) {
                    if (this.jumps == 1) {
                        this.moveHorizontal(0.0f, 0.1f, this.chosenDegrees);
                    } else if (this.jumps == 2) {
                        this.moveHorizontal(0.0f, 0.15f, this.chosenDegrees);
                    } else if (this.jumps == 3) {
                        this.moveHorizontal(0.0f, 0.3f, this.chosenDegrees);
                    }
                }
            }
        }

        public void moveHorizontal(float strafe, float forward, float rotation) {
            float f = strafe * strafe + forward * forward;
            if ((f = Mth.m_14116_((float)f)) < 1.0f) {
                f = 1.0f;
            }
            float f1 = Mth.m_14031_((float)(rotation * ((float)Math.PI / 180)));
            float f2 = Mth.m_14089_((float)(rotation * ((float)Math.PI / 180)));
            this.swet.m_20334_((strafe *= f) * f2 - (forward *= f) * f1, this.swet.m_20184_().f_82480_, forward * f2 + strafe * f1);
        }
    }

    public static class HuntGoal
    extends Goal {
        private final Swet swet;

        public HuntGoal(Swet swet) {
            this.swet = swet;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            block3: {
                block2: {
                    LivingEntity target = this.swet.m_5448_();
                    if (this.swet.hasPrey() || target == null || !target.m_6084_() || this.swet.isFriendlyTowardEntity(target)) break block2;
                    if (!(target instanceof Player)) break block3;
                    Player player = (Player)target;
                    if (!player.m_150110_().f_35934_) break block3;
                }
                return false;
            }
            return this.swet.m_21566_() instanceof MoveHelperController;
        }

        public boolean m_8045_() {
            LivingEntity target = this.swet.m_5448_();
            if (this.swet.hasPrey() || target == null || !target.m_6084_()) {
                return false;
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                if (player.m_150110_().f_35934_) {
                    return false;
                }
            }
            return !this.swet.isFriendlyTowardEntity(target);
        }

        public void m_8037_() {
            LivingEntity target = this.swet.m_5448_();
            if (target != null) {
                this.swet.m_21391_((Entity)target, 10.0f, 10.0f);
                ((MoveHelperController)this.swet.m_21566_()).setDirection(this.swet.m_146908_(), true);
                if (this.swet.m_20191_().m_82381_(target.m_20191_())) {
                    this.swet.capturePrey(target);
                }
            }
        }
    }

    public static class RandomFacingGoal
    extends Goal {
        private final Swet swet;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public RandomFacingGoal(Swet swet) {
            this.swet = swet;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.swet.m_5448_() == null && (this.swet.f_19861_ || this.swet.isInFluidType() || this.swet.m_21023_(MobEffects.f_19620_)) && this.swet.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            MoveHelperController moveHelperController = (MoveHelperController)this.swet.m_21566_();
            float rot = moveHelperController.yRot;
            Vec3 offset = new Vec3(-Math.sin(rot * ((float)Math.PI / 180)) * 2.0, 0.0, Math.cos(rot * ((float)Math.PI / 180)) * 2.0);
            BlockPos pos = BlockPos.m_274446_((Position)this.swet.m_20182_().m_82549_(offset));
            if (this.swet.f_19853_.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) < pos.m_123342_() - this.swet.m_6056_()) {
                this.nextRandomizeTime = this.m_183277_(40 + this.swet.m_217043_().m_188503_(60));
                this.chosenDegrees += 180.0f;
                moveHelperController.setCanJump(false);
            } else {
                if (--this.nextRandomizeTime <= 0) {
                    this.nextRandomizeTime = this.m_183277_(40 + this.swet.m_217043_().m_188503_(60));
                    this.chosenDegrees = this.swet.m_217043_().m_188503_(360);
                }
                moveHelperController.setCanJump(true);
            }
            moveHelperController.setDirection(this.chosenDegrees, false);
        }
    }

    public static class HopGoal
    extends Goal {
        private final Swet swet;

        public HopGoal(Swet swetEntity) {
            this.swet = swetEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean m_8036_() {
            if (this.swet.m_20159_()) return false;
            MoveControl moveControl = this.swet.m_21566_();
            if (!(moveControl instanceof MoveHelperController)) return false;
            MoveHelperController moveHelperController = (MoveHelperController)moveControl;
            if (!moveHelperController.canJump) return false;
            return true;
        }

        public void m_8037_() {
            ((MoveHelperController)this.swet.m_21566_()).setWantedMovement(1.0);
        }
    }
}

