/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.projectile.PoisonNeedle;
import com.aetherteam.aether.item.AetherItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class AechorPlant
extends PathfinderMob
implements RangedAttackMob {
    public static final EntityDataAccessor<Integer> DATA_SIZE_ID = SynchedEntityData.m_135353_(AechorPlant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_POISON_REMAINING_ID = SynchedEntityData.m_135353_(AechorPlant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DATA_TARGETING_ENTITY_ID = SynchedEntityData.m_135353_(AechorPlant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float sinage;
    public float sinageAdd;

    public AechorPlant(EntityType<? extends AechorPlant> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SIZE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_POISON_REMAINING_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_TARGETING_ENTITY_ID, (Object)false);
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> dataAccessor) {
        if (DATA_SIZE_ID.equals(dataAccessor)) {
            this.m_20011_(this.m_142242_());
        }
        super.m_7350_(dataAccessor);
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.m_6034_(Math.floor(this.m_20185_()) + 0.5, this.m_20186_(), Math.floor(this.m_20189_()) + 0.5);
        this.setSize(this.f_19796_.m_188503_(4) + 1);
        this.setPoisonRemaining(2);
        this.sinage = this.f_19796_.m_188501_() * 6.0f;
        return super.m_6518_(level, difficulty, reason, spawnData, tag);
    }

    public static boolean checkAechorPlantSpawnRules(EntityType<? extends AechorPlant> aechorPlant, LevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && level.m_8055_(pos.m_7495_()).m_204336_(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_ON) && level.m_45524_(pos, 0) > 8 && (spawnReason != MobSpawnType.NATURAL || random.m_188503_(10) == 0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_204336_(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_ON)) {
            this.m_6074_();
        }
        if (!this.f_19853_.m_5776_()) {
            if (this.m_5448_() != null) {
                this.setTargetingEntity(true);
            } else if (this.m_5448_() == null && this.getTargetingEntity()) {
                this.setTargetingEntity(false);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.sinage += this.sinageAdd;
        this.sinageAdd = this.f_20916_ > 0 ? 0.45f : (this.getTargetingEntity() ? 0.3f : 0.15f);
        if (this.sinage >= (float)Math.PI * 2) {
            this.sinage -= (float)Math.PI * 2;
        }
    }

    protected void m_6135_() {
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)AetherItems.SKYROOT_BUCKET.get()) && this.getPoisonRemaining() > 0) {
            this.setPoisonRemaining(this.getPoisonRemaining() - 1);
            ItemStack itemStack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)((Item)AetherItems.SKYROOT_POISON_BUCKET.get()).m_7968_());
            player.m_21008_(hand, itemStack1);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7324_(@Nonnull Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.m_20365_(entity) && !entity.f_19794_ && !this.f_19794_ && (d2 = Mth.m_14005_((double)(d0 = entity.m_20185_() - this.m_20185_()), (double)(d1 = entity.m_20189_() - this.m_20189_()))) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!entity.m_20160_()) {
                entity.m_5997_(d0, 0.0, d1);
            }
        }
    }

    public boolean m_6469_(@Nonnull DamageSource damageSource, float amount) {
        if (this.f_20916_ == 0) {
            for (int i = 0; i < 8; ++i) {
                double d1 = this.m_20185_() + (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.5;
                double d2 = this.m_20186_() + 0.25 + (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.5;
                double d3 = this.m_20189_() + (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.5;
                double d4 = (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.5;
                double d5 = (double)(this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.5;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d1, d2, d3, d4, 0.25, d5);
            }
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        PoisonNeedle needle = new PoisonNeedle(this.f_19853_, (LivingEntity)this);
        double x = target.m_20185_() - this.m_20185_();
        double z = target.m_20189_() - this.m_20189_();
        double sqrt = Math.sqrt(x * x + z * z + 0.1);
        double y = 0.1 + sqrt * 0.5 + (this.m_20186_() - target.m_20186_()) * 0.25;
        double distance = 1.5 / sqrt;
        needle.m_6686_(x *= distance, y + 0.5, z *= distance, 0.285f + (float)y * 0.08f, 1.0f);
        this.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_AECHOR_PLANT_SHOOT.get(), 2.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)needle);
    }

    @Nonnull
    protected AABB m_142242_() {
        float width = 0.75f + (float)this.getSize() * 0.125f;
        float height = 0.5f + (float)this.getSize() * 0.075f;
        EntityDimensions newDimensions = EntityDimensions.m_20398_((float)width, (float)height);
        return newDimensions.m_20393_(this.m_20182_());
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(DATA_SIZE_ID);
    }

    public void setSize(int size) {
        this.f_19804_.m_135381_(DATA_SIZE_ID, (Object)size);
    }

    public int getPoisonRemaining() {
        return (Integer)this.f_19804_.m_135370_(DATA_POISON_REMAINING_ID);
    }

    public void setPoisonRemaining(int poisonRemaining) {
        this.f_19804_.m_135381_(DATA_POISON_REMAINING_ID, (Object)poisonRemaining);
    }

    public boolean getTargetingEntity() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TARGETING_ENTITY_ID);
    }

    public void setTargetingEntity(boolean targetingEntity) {
        this.f_19804_.m_135381_(DATA_TARGETING_ENTITY_ID, (Object)targetingEntity);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_AECHOR_PLANT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_AECHOR_PLANT_DEATH.get();
    }

    public boolean m_142582_(@Nonnull Entity entity) {
        return (double)this.m_20270_(entity) <= 8.0 && super.m_142582_(entity);
    }

    protected float m_6431_(@Nonnull Pose pose, @Nonnull EntityDimensions size) {
        return 0.5f;
    }

    public boolean m_6094_() {
        return false;
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_7301_(MobEffectInstance potionEffect) {
        return potionEffect.m_19544_() != AetherEffects.INEBRIATION.get() && super.m_7301_(potionEffect);
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Size", this.getSize());
        tag.m_128405_("Poison Remaining", this.getPoisonRemaining());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Size")) {
            this.setSize(tag.m_128451_("Size"));
        }
        if (tag.m_128441_("Poison Remaining")) {
            this.setPoisonRemaining(tag.m_128451_("Poison Remaining"));
        }
    }
}

