/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractWhirlwind
extends Mob {
    public static final EntityDataAccessor<Integer> DATA_COLOR_ID = SynchedEntityData.m_135353_(AbstractWhirlwind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int lifeLeft;
    public int actionTimer;
    public int stuckTick;
    public float movementAngle;
    public float movementCurve;
    protected boolean isPullingEntity = false;
    protected boolean isEvil = false;

    public AbstractWhirlwind(EntityType<? extends AbstractWhirlwind> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MoveGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.025).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLOR_ID, (Object)this.getDefaultColor());
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.setColorData(this.getDefaultColor());
        this.movementAngle = this.f_19796_.m_188501_() * 360.0f;
        this.movementCurve = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f;
        return super.m_6518_(level, difficulty, reason, spawnData, tag);
    }

    public static boolean checkWhirlwindSpawnRules(EntityType<? extends AbstractWhirlwind> whirlwind, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && level.m_45524_(pos, 0) > 12 && Mob.m_217057_(whirlwind, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public boolean m_6914_(@Nonnull LevelReader level) {
        if (level.m_45784_((Entity)this) && !level.m_46855_(this.m_20191_())) {
            return this.m_20186_() >= (double)(level.m_5736_() + 1);
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        --this.lifeLeft;
        if (!this.f_19853_.f_46443_ && (this.lifeLeft <= 0 || this.isInFluidType())) {
            this.m_146870_();
        }
    }

    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            if (this.f_19863_ && !this.f_201939_) {
                this.stuckTick += 4;
            } else if (this.stuckTick > 0) {
                --this.stuckTick;
            }
            if (this.m_5448_() != null) {
                ++this.actionTimer;
            }
            if (this.actionTimer >= 128) {
                this.handleDrops();
                this.actionTimer = 0;
            }
        } else {
            this.updateParticles();
        }
        super.m_8107_();
        List<Entity> entityList = this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82363_(2.5, 2.5, 2.5)).stream().filter(entity -> !entity.m_6095_().m_204039_(AetherTags.Entities.WHIRLWIND_UNAFFECTED)).toList();
        this.isPullingEntity = !entityList.isEmpty();
        for (Entity entity2 : entityList) {
            double d1;
            double x = (float)entity2.m_20185_();
            double y = (double)((float)entity2.m_20186_()) - entity2.m_6049_() * (double)0.6f;
            double z = (float)entity2.m_20189_();
            double distance = this.m_20270_(entity2);
            if (distance <= 1.5 + (d1 = y - this.m_20186_())) {
                entity2.m_20334_(entity2.m_20184_().f_82479_, (double)0.15f, entity2.m_20184_().f_82481_);
                entity2.m_183634_();
                if (d1 > 1.5) {
                    entity2.m_20334_(entity2.m_20184_().f_82479_, (double)-0.45f + d1 * (double)0.35f, entity2.m_20184_().f_82481_);
                    distance += d1 * 1.5;
                } else {
                    entity2.m_20334_(entity2.m_20184_().f_82479_, 0.125, entity2.m_20184_().f_82481_);
                }
                double d2 = Math.atan2(this.m_20185_() - x, this.m_20189_() - z) / 0.01745329424738884;
                entity2.m_20334_(-Math.cos(0.01745329424738884 * (d2 += 160.0)) * (distance + 0.25) * (double)0.1f, entity2.m_20184_().f_82480_, Math.sin(0.01745329424738884 * d2) * (distance + 0.25) * (double)0.1f);
                if (entity2 instanceof AbstractWhirlwind) {
                    entity2.m_146870_();
                }
            } else {
                double d3 = Math.atan2(this.m_20185_() - x, this.m_20189_() - z) / 0.01745329424738884;
                entity2.m_20256_(entity2.m_20184_().m_82520_(Math.sin(0.01745329424738884 * d3) * (double)0.01f, entity2.m_20184_().f_82480_, Math.cos(0.01745329424738884 * d3) * (double)0.01f));
            }
            if (this.f_19853_.m_46859_(this.m_20183_())) continue;
            this.lifeLeft -= 50;
        }
        if (this.stuckTick > 40) {
            this.lifeLeft = 0;
        }
    }

    protected void handleDrops() {
        if (this.f_19796_.m_188503_(4) == 0) {
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)this);
            LootTable lootTable = this.f_19853_.m_7654_().m_129898_().m_79217_(this.getLootLocation());
            ObjectArrayList list = lootTable.m_230922_(builder.m_78975_(LootContextParamSets.f_81413_));
            for (ItemStack itemstack : list) {
                this.f_19853_.m_5594_(null, this.m_20183_(), (SoundEvent)AetherSoundEvents.ENTITY_WHIRLWIND_DROP.get(), SoundSource.HOSTILE, 0.5f, 1.0f);
                this.m_5552_(itemstack, 1.0f);
            }
        }
    }

    public boolean m_6469_(@Nonnull DamageSource source, float damage) {
        return false;
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public abstract void updateParticles();

    public abstract ResourceLocation getLootLocation();

    public int getColorData() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR_ID);
    }

    public void setColorData(int color) {
        this.f_19804_.m_135381_(DATA_COLOR_ID, (Object)color);
    }

    public abstract int getDefaultColor();

    public boolean m_6147_() {
        return this.f_19862_;
    }

    public int m_5792_() {
        return 1;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected boolean m_7341_(@Nonnull Entity vehicle) {
        return false;
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("Movement Angle", this.movementAngle);
        tag.m_128350_("Movement Curve", this.movementCurve);
        tag.m_128405_("Life Left", this.lifeLeft);
        tag.m_128405_("Color", this.getColorData());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Movement Angle")) {
            this.movementAngle = tag.m_128457_("Movement Angle");
        }
        if (tag.m_128441_("Movement Curve")) {
            this.movementCurve = tag.m_128457_("Movement Curve");
        }
        if (tag.m_128441_("Life Left")) {
            this.lifeLeft = tag.m_128451_("Life Left");
        }
        if (tag.m_128441_("Color")) {
            this.setColorData(tag.m_128451_("Color"));
        }
    }

    protected static class MoveGoal
    extends Goal {
        private final AbstractWhirlwind whirlwind;
        protected float movementAngle;
        protected float movementCurve;

        public MoveGoal(AbstractWhirlwind entity) {
            this.whirlwind = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.movementAngle == 0.0f) {
                this.movementAngle = this.whirlwind.movementAngle;
                this.movementCurve = this.whirlwind.movementCurve;
            }
            if (!this.whirlwind.isEvil || this.whirlwind.m_5448_() == null) {
                BlockPos offset = BlockPos.m_274446_((Position)this.whirlwind.m_20182_().m_82549_(this.whirlwind.m_20184_()));
                this.movementAngle = this.whirlwind.f_19853_.m_6924_(Heightmap.Types.WORLD_SURFACE, offset.m_123341_(), offset.m_123343_()) < offset.m_123342_() - this.whirlwind.m_6056_() ? (this.movementAngle += 180.0f) : (this.movementAngle += this.movementCurve);
                this.whirlwind.m_20334_(Math.cos(this.movementAngle * ((float)Math.PI / 180)) * this.whirlwind.m_21051_(Attributes.f_22279_).m_22135_(), this.whirlwind.m_20184_().f_82480_, Math.sin(this.movementAngle * ((float)Math.PI / 180)) * this.whirlwind.m_21051_(Attributes.f_22279_).m_22135_());
            } else {
                this.whirlwind.m_20256_(Vec3.f_82478_);
            }
        }
    }
}

