/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.miscellaneous;

import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.ExplosionParticlePacket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;

public class Parachute
extends Entity {
    public Parachute(EntityType<? extends Parachute> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity passenger = this.m_6688_();
        if (passenger != null) {
            this.m_183634_();
            this.moveParachute(passenger);
            this.spawnExplosionParticle();
            if (this.m_20096_() || this.isInFluidType()) {
                this.m_20153_();
                this.die();
            }
        } else {
            this.die();
        }
    }

    public void moveParachute(LivingEntity passenger) {
        if (this.m_20160_()) {
            this.m_146922_(passenger.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(passenger.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            float f = passenger.f_20900_ * 0.5f;
            float f1 = passenger.f_20902_;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            Vec3 travelVec = new Vec3((double)f, (double)passenger.f_20901_, (double)f1);
            AttributeInstance gravity = passenger.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double d0 = gravity != null ? gravity.m_22135_() : 0.08;
            Vec3 movement = this.calculateMovement(travelVec);
            double d2 = movement.f_82480_;
            if (!this.m_20068_()) {
                d2 -= d0;
            }
            double fallSpeed = Math.max(d0 * -3.125, -0.25);
            this.m_20334_(movement.f_82479_ * (double)0.91f, Math.max(d2 *= 0.98, fallSpeed), movement.f_82481_ * (double)0.91f);
            if (passenger instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)passenger;
                ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_;
                serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                serverGamePacketListenerImplAccessor.aether$setAboveGroundVehicleTickCount(0);
            }
        }
    }

    public Vec3 calculateMovement(Vec3 vec3) {
        float speed = 0.03f;
        this.m_19920_(speed, vec3);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        return this.m_20184_();
    }

    public void spawnExplosionParticle() {
        if (!this.f_19853_.f_46443_) {
            AetherPacketHandler.sendToNear(new ExplosionParticlePacket(this.m_19879_(), 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0, (ResourceKey<Level>)this.f_19853_.m_46472_());
        }
    }

    public void die() {
        this.spawnExplosionParticle();
        if (!this.f_19853_.f_46443_) {
            this.m_6074_();
        }
    }

    protected boolean m_7341_(@Nonnull Entity entity) {
        return true;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double m_6048_() {
        return 1.35;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity rider = (LivingEntity)entity;
            return rider;
        }
        return null;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6051_() {
        return false;
    }

    protected void m_7380_(@Nonnull CompoundTag tag) {
    }

    protected void m_7378_(@Nonnull CompoundTag tag) {
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

