/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.miscellaneous;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.projectile.crystal.CloudCrystal;
import com.aetherteam.aether.util.EntityUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class CloudMinion
extends FlyingMob {
    private static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(CloudMinion.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_RIGHT_ID = SynchedEntityData.m_135353_(CloudMinion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_LIFESPAN_ID = SynchedEntityData.m_135353_(CloudMinion.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean shouldShoot;
    public double targetX;
    public double targetY;
    public double targetZ;

    public CloudMinion(EntityType<? extends FlyingMob> type, Level level) {
        super(type, level);
    }

    public CloudMinion(Level level, Player player, HumanoidArm armSide) {
        super((EntityType)AetherEntityTypes.CLOUD_MINION.get(), level);
        this.setOwner(player);
        this.setSide(armSide);
        this.setLifeSpan(3600);
        this.f_19794_ = true;
        this.setPositionFromOwner();
        this.m_6034_(this.targetX, this.targetY, this.targetZ);
        this.m_146926_(this.getOwner().m_146909_());
        this.m_146922_(this.getOwner().m_146908_());
    }

    @Nonnull
    public static AttributeSupplier.Builder createMobAttributes() {
        return FlyingMob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 10.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNER_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_IS_RIGHT_ID, (Object)true);
        this.f_19804_.m_135372_(DATA_LIFESPAN_ID, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.setLifeSpan(this.getLifeSpan() - 1);
        if (this.getLifeSpan() <= 0) {
            this.spawnExplosionParticles();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else if (this.getOwner() != null) {
            if (this.getOwner().m_6084_()) {
                this.setPositionFromOwner();
                this.setRotationFromOwner();
                if (this.atShoulder()) {
                    Vec3 motion = this.m_20184_();
                    this.m_20256_(motion.m_82542_(0.65, 0.65, 0.65));
                    if (this.shouldShoot()) {
                        float offset = this.getSide() == HumanoidArm.RIGHT ? 2.0f : -2.0f;
                        float rotation = Mth.m_14177_((float)(this.m_146908_() + offset));
                        CloudCrystal crystal = new CloudCrystal(this.f_19853_);
                        crystal.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        crystal.m_37251_((Entity)this, this.m_146909_(), rotation, 0.0f, 1.0f, 1.0f);
                        crystal.m_5602_((Entity)this.getOwner());
                        if (!this.f_19853_.f_46443_) {
                            this.f_19853_.m_7967_((Entity)crystal);
                        }
                        this.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_CLOUD_MINION_SHOOT.get(), 0.75f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                        this.setShouldShoot(false);
                    }
                } else {
                    this.approachOwner();
                }
            } else {
                this.spawnExplosionParticles();
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void setPositionFromOwner() {
        if (this.m_20270_((Entity)this.getOwner()) > 2.0f) {
            this.targetX = this.getOwner().m_20185_();
            this.targetY = this.getOwner().m_20186_() + 1.0;
            this.targetZ = this.getOwner().m_20189_();
        } else {
            double yaw = this.getOwner().m_146908_();
            yaw = this.getSide() == HumanoidArm.RIGHT ? (yaw -= 90.0) : (yaw += 90.0);
            this.targetX = this.getOwner().m_20185_() + Math.sin(yaw /= -57.29577951308232) * 1.05;
            this.targetY = this.getOwner().m_20186_() + 1.0;
            this.targetZ = this.getOwner().m_20189_() + Math.cos(yaw) * 1.05;
        }
    }

    public void setRotationFromOwner() {
        this.m_146922_(this.getOwner().m_146908_() + (this.getSide() == HumanoidArm.RIGHT ? 1.0f : -1.0f));
        this.m_146926_(this.getOwner().m_146909_());
        this.m_5616_(this.getOwner().m_6080_());
    }

    public boolean atShoulder() {
        double z;
        double y;
        double x = this.m_20185_() - this.targetX;
        return Math.sqrt(x * x + (y = this.m_20186_() - this.targetY) * y + (z = this.m_20189_() - this.targetZ) * z) < 0.4;
    }

    public void approachOwner() {
        double x = this.targetX - this.m_20185_();
        double y = this.targetY - this.m_20186_();
        double z = this.targetZ - this.m_20189_();
        double sqrt = Math.sqrt(x * x + y * y + z * z) * 3.25;
        Vec3 motion = this.m_20184_();
        double motionX = (motion.m_7096_() + x / sqrt) / 2.0;
        double motionY = (motion.m_7098_() + y / sqrt) / 2.0;
        double motionZ = (motion.m_7094_() + z / sqrt) / 2.0;
        this.m_20334_(motionX, motionY, motionZ);
    }

    private void spawnExplosionParticles() {
        if (this.f_19853_.f_46443_) {
            EntityUtil.spawnSummoningExplosionParticles((Entity)this);
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)20);
        }
    }

    protected void m_6138_() {
    }

    protected boolean m_7341_(Entity vehicle) {
        return false;
    }

    public boolean m_6469_(@Nonnull DamageSource source, float damage) {
        return false;
    }

    public Player getOwner() {
        return (Player)this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(DATA_OWNER_ID)).intValue());
    }

    public void setOwner(Player entity) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)entity.m_19879_());
    }

    public HumanoidArm getSide() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_RIGHT_ID) != false ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
    }

    public void setSide(HumanoidArm armSide) {
        this.f_19804_.m_135381_(DATA_IS_RIGHT_ID, (Object)(armSide == HumanoidArm.RIGHT ? 1 : 0));
    }

    public int getLifeSpan() {
        return (Integer)this.f_19804_.m_135370_(DATA_LIFESPAN_ID);
    }

    public void setLifeSpan(int lifespan) {
        this.f_19804_.m_135381_(DATA_LIFESPAN_ID, (Object)lifespan);
    }

    public boolean shouldShoot() {
        return this.shouldShoot;
    }

    public void setShouldShoot(boolean shouldShoot) {
        this.shouldShoot = shouldShoot;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

