/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.ai.brain.sensing;

import com.aetherteam.aether.entity.BossMob;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class InDungeonPlayerSensor<T extends Mob>
extends Sensor<T> {
    private static final TargetingConditions TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = TargetingConditions.m_148353_().m_26883_(16.0).m_26893_().m_148355_();
    private static final TargetingConditions ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = TargetingConditions.m_148352_().m_26883_(16.0).m_26893_().m_148355_();

    protected void doTick(ServerLevel level, T entity) {
        List targets = level.m_6907_().stream().filter(EntitySelector.f_20408_).filter(target -> ((BossMob)entity).getDungeon() != null ? ((BossMob)entity).getDungeon().isPlayerTracked((Player)target) : entity.m_19950_((Entity)target, 16.0)).sorted(Comparator.comparingDouble(arg_0 -> entity.m_20280_(arg_0))).collect(Collectors.toList());
        Brain brain = entity.m_6274_();
        brain.m_21879_(MemoryModuleType.f_26367_, targets);
        List<Player> nearestVisiblePlayers = targets.stream().filter(target -> InDungeonPlayerSensor.isEntityTargetable((LivingEntity)entity, (LivingEntity)target)).toList();
        brain.m_21879_(MemoryModuleType.f_26368_, nearestVisiblePlayers.isEmpty() ? null : nearestVisiblePlayers.get(0));
        Optional<Player> nearestPlayer = nearestVisiblePlayers.stream().filter(target -> InDungeonPlayerSensor.isEntityAttackable((LivingEntity)entity, (LivingEntity)target)).findFirst();
        brain.m_21886_(MemoryModuleType.f_148206_, nearestPlayer);
    }

    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)MemoryModuleType.f_26367_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_);
    }

    public static boolean isEntityTargetable(LivingEntity pLivingEntity, LivingEntity pTarget) {
        return TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.m_26885_(pLivingEntity, pTarget);
    }

    public static boolean isEntityAttackable(LivingEntity pAttacker, LivingEntity pTarget) {
        return ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.m_26885_(pAttacker, pTarget);
    }
}

