/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity;

import com.aetherteam.aether.api.BossRoomTracker;
import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface BossMob<T extends Mob> {
    public static final TargetingConditions NON_COMBAT = TargetingConditions.m_148353_();

    private T self() {
        return (T)((Mob)this);
    }

    public Component getBossName();

    public void setBossName(Component var1);

    public boolean isBossFight();

    public void setBossFight(boolean var1);

    public BossRoomTracker<T> getDungeon();

    public void setDungeon(BossRoomTracker<T> var1);

    public int getDeathScore();

    default public void trackDungeon() {
        if (this.getDungeon() != null) {
            this.getDungeon().trackPlayers();
            if (this.isBossFight() && (this.getDungeon().dungeonPlayers().isEmpty() || !this.getDungeon().isBossWithinRoom())) {
                this.reset();
            }
        }
    }

    default public void displayTooFarMessage(Player player) {
        player.m_213846_((Component)Component.m_237115_((String)"gui.aether.boss.message.far"));
    }

    default public void onDungeonPlayerAdded(@Nullable Player player) {
    }

    default public void onDungeonPlayerRemoved(@Nullable Player player) {
    }

    public void reset();

    default public void tearDownRoom() {
        this.getDungeon().modifyRoom(this::convertBlock);
    }

    default public void closeRoom() {
        this.getDungeon().modifyRoom(state -> {
            if (state.m_60734_() instanceof DoorwayBlock) {
                return (BlockState)state.m_61124_((Property)DoorwayBlock.INVISIBLE, (Comparable)Boolean.valueOf(false));
            }
            return null;
        });
    }

    default public void openRoom() {
        this.getDungeon().modifyRoom(state -> {
            if (state.m_60734_() instanceof DoorwayBlock) {
                return (BlockState)state.m_61124_((Property)DoorwayBlock.INVISIBLE, (Comparable)Boolean.valueOf(true));
            }
            return null;
        });
    }

    @Nullable
    public BlockState convertBlock(BlockState var1);

    default public void addBossSaveData(CompoundTag tag) {
        tag.m_128359_("BossName", Component.Serializer.m_130703_((Component)this.getBossName()));
        tag.m_128379_("BossFight", this.isBossFight());
        if (this.getDungeon() != null) {
            tag.m_128365_("Dungeon", (Tag)this.getDungeon().addAdditionalSaveData());
        }
    }

    default public void readBossSaveData(CompoundTag tag) {
        Tag tag2;
        MutableComponent name;
        if (tag.m_128441_("BossName") && (name = Component.Serializer.m_130701_((String)tag.m_128461_("BossName"))) != null) {
            this.setBossName((Component)name);
        }
        if (tag.m_128441_("BossFight")) {
            this.setBossFight(tag.m_128471_("BossFight"));
        }
        if (tag.m_128441_("Dungeon") && (tag2 = tag.m_128423_("Dungeon")) instanceof CompoundTag) {
            CompoundTag dungeonTag = (CompoundTag)tag2;
            this.setDungeon(BossRoomTracker.readAdditionalSaveData(dungeonTag, this.self()));
        }
    }
}

