/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.builders;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.registries.AetherNoises;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class AetherNoiseBuilders {
    private static final SurfaceRules.RuleSource GRASS_BLOCK = SurfaceRules.m_189390_((BlockState)((BlockState)((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))));
    private static final SurfaceRules.RuleSource DIRT = SurfaceRules.m_189390_((BlockState)((BlockState)((Block)AetherBlocks.AETHER_DIRT.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))));

    public static NoiseGeneratorSettings skylandsNoiseSettings(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noise) {
        BlockState holystone = (BlockState)((Block)AetherBlocks.HOLYSTONE.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true));
        return new NoiseGeneratorSettings(new NoiseSettings(0, 128, 2, 1), holystone, Blocks.f_49990_.m_49966_(), AetherNoiseBuilders.makeNoiseRouter(densityFunctions, noise), AetherNoiseBuilders.aetherSurfaceRules(), List.of(), -64, false, false, false, false);
    }

    private static SurfaceRules.RuleSource aetherSurfaceRules() {
        SurfaceRules.RuleSource surface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)surface), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)DIRT)});
    }

    private static NoiseRouter makeNoiseRouter(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noise) {
        return AetherNoiseBuilders.createNoiseRouter(densityFunctions, noise, AetherNoiseBuilders.buildFinalDensity(densityFunctions, noise));
    }

    private static DensityFunction buildFinalDensity(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noise) {
        DensityFunction density = AetherNoiseBuilders.getFunction(densityFunctions, (ResourceKey<DensityFunction>)ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation("aether", "base_3d_noise_aether")));
        density = DensityFunctions.m_208293_((DensityFunction)density, (DensityFunction)DensityFunctions.m_208264_((double)-0.13));
        density = AetherNoiseBuilders.slide(density, 0, 128, 72, 0, -0.2, 8, 40, -0.1);
        density = DensityFunctions.m_208293_((DensityFunction)density, (DensityFunction)DensityFunctions.m_208264_((double)-0.05));
        density = DensityFunctions.m_208389_((DensityFunction)density);
        density = DensityFunctions.m_208281_((DensityFunction)density);
        density = density.m_208234_();
        return density;
    }

    private static DensityFunction slide(DensityFunction density, int minY, int maxY, int fromYTop, int toYTop, double offset1, int fromYBottom, int toYBottom, double offset2) {
        DensityFunction topSlide = DensityFunctions.m_208266_((int)(minY + maxY - fromYTop), (int)(minY + maxY - toYTop), (double)1.0, (double)0.0);
        density = DensityFunctions.m_224030_((DensityFunction)topSlide, (double)offset1, (DensityFunction)density);
        DensityFunction bottomSlide = DensityFunctions.m_208266_((int)(minY + fromYBottom), (int)(minY + toYBottom), (double)0.0, (double)1.0);
        return DensityFunctions.m_224030_((DensityFunction)bottomSlide, (double)offset2, (DensityFunction)density);
    }

    private static NoiseRouter createNoiseRouter(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noise, DensityFunction finalDensity) {
        DensityFunction shiftX = AetherNoiseBuilders.getFunction(densityFunctions, (ResourceKey<DensityFunction>)ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation("shift_x")));
        DensityFunction shiftZ = AetherNoiseBuilders.getFunction(densityFunctions, (ResourceKey<DensityFunction>)ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation("shift_z")));
        DensityFunction temperature = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)noise.m_255043_(AetherNoises.TEMPERATURE));
        DensityFunction vegetation = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)noise.m_255043_(AetherNoises.VEGETATION));
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), temperature, vegetation, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), finalDensity, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> densityFunctions, ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder((Holder)densityFunctions.m_255043_(key));
    }
}

