/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.providers;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AetherItemModelProvider
extends ItemModelProvider {
    public AetherItemModelProvider(PackOutput output, String id, ExistingFileHelper helper) {
        super(output, id, helper);
    }

    public String blockName(Block block) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (location != null) {
            return location.m_135815_();
        }
        throw new IllegalStateException("Unknown block: " + block.toString());
    }

    public String itemName(Item item) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)item);
        if (location != null) {
            return location.m_135815_();
        }
        throw new IllegalStateException("Unknown item: " + item.toString());
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected ResourceLocation texture(String name, String location) {
        return this.modLoc("block/" + location + name);
    }

    public void item(Item item, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)));
    }

    public void handheldItem(Item item, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)));
    }

    public void lanceItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 45.0f).translation(0.0f, 1.0f, -5.0f).scale(0.85f, 0.85f, 0.85f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -45.0f).translation(0.0f, 1.0f, -5.0f).scale(0.85f, 0.85f, 0.85f).end().end();
    }

    public void nameableWeapon(Item item, String location, String renamedVariant) {
        ((ItemModelBuilder)this.withExistingParent(renamedVariant, this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + renamedVariant));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).override().predicate(new ResourceLocation("aether", "named"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + renamedVariant))).end();
    }

    public void dartShooterItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 45.0f).translation(0.0f, 1.5f, -1.0f).scale(0.85f, 0.85f, 0.85f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -45.0f).translation(0.0f, 1.5f, -1.0f).scale(0.85f, 0.85f, 0.85f).end().end();
    }

    public void bowItem(Item item, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item) + "_pulling_0", this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item) + "_pulling_0"));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item) + "_pulling_1", this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item) + "_pulling_1"));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item) + "_pulling_2", this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item) + "_pulling_2"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).override().predicate(new ResourceLocation("pulling"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item) + "_pulling_0"))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.65f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item) + "_pulling_1"))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.9f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item) + "_pulling_2"))).end();
    }

    public void dyedItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).texture("layer1", this.modLoc("item/" + location + this.itemName(item) + "_overlay"));
    }

    public void rotatedItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).transforms().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(90.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(90.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().end();
    }

    public void moaEggItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + "moa_egg"))).texture("layer1", this.modLoc("item/" + location + "moa_egg_spot"));
    }

    public void portalItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).texture("layer1", this.modLoc("item/" + location + this.itemName(item) + "_inside"));
    }

    public void eggItem(Item item) {
        this.withExistingParent(this.itemName(item), this.mcLoc("item/template_spawn_egg"));
    }

    public void itemBlock(Block block) {
        this.withExistingParent(this.blockName(block), this.texture(this.blockName(block)));
    }

    public void itemBlock(Block block, String suffix) {
        this.withExistingParent(this.blockName(block), this.texture(this.blockName(block) + suffix));
    }

    public void pane(Block block, Block glass, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(glass), location))).renderType(new ResourceLocation("translucent"));
    }

    public void itemTorch(Block block, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(block), location));
    }

    public void itemBlockFlat(Block block, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(block), location));
    }

    public void itemLockedDungeonBlock(Block block, Block baseBlock) {
        this.itemOverlayDungeonBlock(block, baseBlock, "lock");
    }

    public void itemTrappedDungeonBlock(Block block, Block baseBlock) {
        this.itemOverlayDungeonBlock(block, baseBlock, "exclamation");
    }

    public void itemBossDoorwayDungeonBlock(Block block, Block baseBlock) {
        this.itemOverlayDungeonBlock(block, baseBlock, "door");
    }

    public void itemTreasureDoorwayDungeonBlock(Block block, Block baseBlock) {
        this.itemOverlayDungeonBlock(block, baseBlock, "treasure");
    }

    public void itemOverlayDungeonBlock(Block block, Block baseBlock, String overlay) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/cube"))).texture("overlay", this.texture(overlay, "dungeon/"))).texture("face", this.texture(this.blockName(baseBlock), "dungeon/"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, builder) -> builder.texture("#face").cullface(direction).end()).end()).element().from(0.0f, 0.0f, -0.1f).to(16.0f, 16.0f, -0.1f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 6.9f).end().face(Direction.NORTH).texture("#overlay").emissivity(15, 15).end().end()).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.GROUND).rotation(90.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ItemDisplayContext.GUI).rotation(30.0f, 135.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ItemDisplayContext.FIXED).scale(0.5f, 0.5f, 0.5f).end().end();
    }

    public void lookalikeBlock(Block block, ResourceLocation lookalike) {
        this.withExistingParent(this.blockName(block), lookalike);
    }

    public void itemFence(Block block, Block baseBlock, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/fence_inventory"))).texture("texture", this.texture(this.blockName(baseBlock), location));
    }

    public void itemButton(Block block, Block baseBlock, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/button_inventory"))).texture("texture", this.texture(this.blockName(baseBlock), location));
    }

    public void itemWallBlock(Block block, Block baseBlock, String location) {
        this.wallInventory(this.blockName(block), this.texture(this.blockName(baseBlock), location));
    }

    public void translucentItemWallBlock(Block block, Block baseBlock, String location) {
        this.singleTexture(this.blockName(block), new ResourceLocation("aether", "block/template_translucent_wall_inventory"), "wall", this.texture(this.blockName(baseBlock), location));
    }
}

