/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.providers;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.construction.AetherFarmBlock;
import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import com.aetherteam.aether.block.miscellaneous.AetherFrostedIceBlock;
import com.aetherteam.aether.block.miscellaneous.UnstableObsidianBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AetherBlockStateProvider
extends BlockStateProvider {
    public AetherBlockStateProvider(PackOutput output, String id, ExistingFileHelper helper) {
        super(output, id, helper);
    }

    public String name(Block block) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (location != null) {
            return location.m_135815_();
        }
        throw new IllegalStateException("Unknown block: " + block.toString());
    }

    public ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public ResourceLocation texture(String name, String location) {
        return this.modLoc("block/" + location + name);
    }

    public ResourceLocation texture(String name, String location, String suffix) {
        return this.modLoc("block/" + location + name + suffix);
    }

    public ResourceLocation extend(ResourceLocation location, String suffix) {
        return new ResourceLocation(location.m_135827_(), location.m_135815_() + suffix);
    }

    public void block(Block block, String location) {
        this.simpleBlock(block, this.cubeAll(block, location));
    }

    public void portal(Block block) {
        ModelBuilder portal_ew = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_ew", this.mcLoc("block/nether_portal_ew"))).texture("particle", this.modLoc("block/miscellaneous/" + this.name(block)))).texture("portal", this.modLoc("block/miscellaneous/" + this.name(block)))).renderType(new ResourceLocation("translucent"));
        ModelBuilder portal_ns = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_ns", this.mcLoc("block/nether_portal_ns"))).texture("particle", this.modLoc("block/miscellaneous/" + this.name(block)))).texture("portal", this.modLoc("block/miscellaneous/" + this.name(block)))).renderType(new ResourceLocation("translucent"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> AetherBlockStateProvider.lambda$portal$0((ModelFile)portal_ew, (ModelFile)portal_ns, arg_0));
    }

    public void grass(Block block, Block dirtBlock) {
        ModelFile grass = this.grassBlock(block, dirtBlock);
        ModelFile grassSnowed = this.cubeBottomTop(this.name(block) + "_snow", this.extend(this.texture(this.name(block), "natural/"), "_snow"), this.texture(this.name(dirtBlock), "natural/"), this.extend(this.texture(this.name(block), "natural/"), "_top"));
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            boolean snowy = (Boolean)state.m_61143_((Property)SnowyDirtBlock.f_56637_);
            return ConfiguredModel.allYRotations((ModelFile)(snowy ? grassSnowed : grass), (int)0, (boolean)false);
        }, new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void enchantedGrass(Block block, Block grassBlock, Block dirtBlock) {
        ModelFile grass = this.grassBlock(block, dirtBlock);
        ModelFile grassSnowed = this.cubeBottomTop(this.name(grassBlock) + "_snow", this.extend(this.texture(this.name(grassBlock), "natural/"), "_snow"), this.texture(this.name(dirtBlock), "natural/"), this.extend(this.texture(this.name(block), "natural/"), "_top"));
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            boolean snowy = (Boolean)state.m_61143_((Property)SnowyDirtBlock.f_56637_);
            return ConfiguredModel.allYRotations((ModelFile)(snowy ? grassSnowed : grass), (int)0, (boolean)false);
        }, new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public ModelFile grassBlock(Block block, Block dirtBlock) {
        return this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "natural/"), "_side"), this.texture(this.name(dirtBlock), "natural/"), this.extend(this.texture(this.name(block), "natural/"), "_top"));
    }

    public void dirtPath(Block block, Block dirtBlock) {
        ModelBuilder path = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/dirt_path"))).texture("particle", this.modLoc("block/natural/" + this.name(dirtBlock)))).texture("top", this.modLoc("block/construction/" + this.name(block) + "_top"))).texture("side", this.modLoc("block/construction/" + this.name(block) + "_side"))).texture("bottom", this.modLoc("block/natural/" + this.name(dirtBlock)));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$dirtPath$3((ModelFile)path, arg_0), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void farmland(Block block, Block dirtBlock) {
        ModelBuilder farmland = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/template_farmland"))).texture("dirt", this.modLoc("block/natural/" + this.name(dirtBlock)))).texture("top", this.modLoc("block/construction/" + this.name(block)));
        ModelBuilder moist = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_moist", this.mcLoc("block/template_farmland"))).texture("dirt", this.modLoc("block/natural/" + this.name(dirtBlock)))).texture("top", this.modLoc("block/construction/" + this.name(block) + "_moist"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$farmland$4((ModelFile)farmland, (ModelFile)moist, arg_0), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void randomBlockDoubleDrops(Block block, String location) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.allYRotations((ModelFile)this.cubeAll(block, location), (int)0, (boolean)false), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void blockDoubleDrops(Block block, String location) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cubeAll(block, location)).build(), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void translucentBlock(Block block, String location) {
        this.simpleBlock(block, this.cubeAllTranslucent(block, location));
    }

    public void log(RotatedPillarBlock block) {
        this.axisBlock(block, this.texture(this.name((Block)block), "natural/"), this.extend(this.texture(this.name((Block)block), "natural/"), "_top"));
    }

    public void enchantedLog(RotatedPillarBlock block, RotatedPillarBlock baseBlock) {
        this.axisBlock(block, this.texture(this.name((Block)block), "natural/"), this.extend(this.texture(this.name((Block)baseBlock), "natural/"), "_top"));
    }

    public void wood(RotatedPillarBlock block, RotatedPillarBlock baseBlock) {
        this.axisBlock(block, this.texture(this.name((Block)baseBlock), "natural/"), this.texture(this.name((Block)baseBlock), "natural/"));
    }

    public void pane(IronBarsBlock block, GlassBlock glass, String location) {
        this.paneBlockWithRenderType(block, this.texture(this.name((Block)glass), location), this.extend(this.texture(this.name((Block)block), location), "_top"), ResourceLocation.m_135820_((String)"translucent"));
    }

    public void altar(Block block) {
        ModelFile altar = this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "utility/"), "_side"), this.extend(this.texture(this.name(block), "utility/"), "_bottom"), this.extend(this.texture(this.name(block), "utility/"), "_bottom"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(altar)});
    }

    public void freezer(Block block) {
        ModelFile freezer = this.utility(block);
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(freezer)});
    }

    public void incubator(Block block) {
        ModelFile incubator = this.utility(block);
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(incubator)});
    }

    public ModelFile utility(Block block) {
        return this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "utility/"), "_side"), this.extend(this.texture("altar", "utility/"), "_bottom"), this.extend(this.texture(this.name(block), "utility/"), "_top"));
    }

    public void torchBlock(Block block, Block wall) {
        ModelBuilder torch = ((BlockModelBuilder)this.models().torch(this.name(block), this.texture(this.name(block), "utility/"))).renderType(new ResourceLocation("cutout"));
        ModelBuilder wallTorch = ((BlockModelBuilder)this.models().torchWall(this.name(wall), this.texture(this.name(block), "utility/"))).renderType(new ResourceLocation("cutout"));
        this.simpleBlock(block, (ModelFile)torch);
        this.getVariantBuilder(wall).forAllStates(arg_0 -> AetherBlockStateProvider.lambda$torchBlock$7((ModelFile)wallTorch, arg_0));
    }

    public void signBlock(StandingSignBlock signBlock, WallSignBlock wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name((Block)signBlock), texture);
        this.signBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void crossBlock(Block block, String location) {
        this.crossBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(block), this.texture(this.name(block), location))).renderType(new ResourceLocation("cutout")));
    }

    public void crossBlock(Block block, ModelFile model) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    public void berryBush(Block block, Block stem) {
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(this.bush(block, stem))});
    }

    public ModelFile bush(Block block, Block stem) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/block"))).texture("particle", this.texture(this.name(block), "natural/"))).texture("bush", this.texture(this.name(block), "natural/"))).texture("stem", this.texture(this.name(stem), "natural/"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).shade(true).allFaces((direction, builder) -> builder.texture("#bush").end()).end()).element().from(0.8f, 0.0f, 8.0f).to(15.2f, 16.0f, 8.0f).rotation().origin(8.0f, 8.0f, 8.0f).axis(Direction.Axis.Y).angle(45.0f).rescale(true).end().shade(true).face(Direction.NORTH).texture("#stem").end().face(Direction.SOUTH).texture("#stem").end().end()).element().from(8.0f, 0.0f, 0.8f).to(8.0f, 16.0f, 15.2f).rotation().origin(8.0f, 8.0f, 8.0f).axis(Direction.Axis.Y).angle(45.0f).rescale(true).end().shade(true).face(Direction.WEST).texture("#stem").end().face(Direction.EAST).texture("#stem").end().end()).renderType(new ResourceLocation("cutout"));
    }

    public BlockModelBuilder pottedStemModel(Block block, Block stem, String location) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/block"))).texture("particle", this.mcLoc("block/flower_pot"))).texture("stem", this.modLoc("block/" + location + this.name(stem)))).texture("dirt", this.mcLoc("block/dirt"))).texture("flowerpot", this.mcLoc("block/flower_pot"))).element().from(5.0f, 0.0f, 5.0f).to(6.0f, 6.0f, 11.0f).face(Direction.NORTH).uvs(10.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.EAST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(5.0f, 10.0f, 6.0f, 16.0f).texture("#flowerpot").end().face(Direction.WEST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(5.0f, 5.0f, 6.0f, 11.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(5.0f, 5.0f, 6.0f, 11.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(10.0f, 0.0f, 5.0f).to(11.0f, 6.0f, 11.0f).face(Direction.NORTH).uvs(5.0f, 10.0f, 6.0f, 16.0f).texture("#flowerpot").end().face(Direction.EAST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(10.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.WEST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(10.0f, 5.0f, 11.0f, 11.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(10.0f, 5.0f, 11.0f, 11.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(6.0f, 0.0f, 5.0f).to(10.0f, 6.0f, 6.0f).face(Direction.NORTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(6.0f, 5.0f, 10.0f, 6.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(6.0f, 10.0f, 10.0f, 11.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(6.0f, 0.0f, 10.0f).to(10.0f, 6.0f, 11.0f).face(Direction.NORTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(6.0f, 10.0f, 10.0f, 11.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(6.0f, 5.0f, 10.0f, 6.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(6.0f, 0.0f, 6.0f).to(10.0f, 4.0f, 10.0f).face(Direction.UP).uvs(6.0f, 6.0f, 10.0f, 10.0f).texture("#dirt").end().face(Direction.DOWN).uvs(6.0f, 12.0f, 10.0f, 16.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(1.0f, 4.0f, 8.0f).to(15.0f, 16.0f, 8.0f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 8.0f).end().face(Direction.NORTH).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#stem").end().face(Direction.SOUTH).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#stem").end().end()).element().from(8.0f, 4.0f, 1.0f).to(8.0f, 16.0f, 15.0f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 8.0f).end().face(Direction.EAST).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#stem").end().face(Direction.WEST).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#stem").end().end();
    }

    public void pottedStem(Block stem, String location) {
        ModelBuilder pot = this.pottedStemModel(stem, stem, location).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(stem).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pot)});
    }

    public void pottedBush(Block bush, Block stem, String location) {
        ModelBuilder pot = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.pottedStemModel(bush, stem, location).texture("stem", this.modLoc("block/" + location + this.name(stem)))).texture("bush", this.modLoc("block/" + location + this.name(bush)))).element().from(3.0f, 6.0f, 3.0f).to(13.0f, 16.0f, 13.0f).face(Direction.NORTH).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.EAST).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.SOUTH).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.WEST).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.UP).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.DOWN).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().end()).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(bush).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pot)});
    }

    public void pottedPlant(Block block, Block flower, String location) {
        ModelBuilder pot = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/flower_pot_cross"))).texture("plant", this.modLoc("block/" + location + this.name(flower)))).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pot)});
    }

    public void saplingBlock(Block block, String location) {
        ModelBuilder sapling = ((BlockModelBuilder)this.models().cross(this.name(block), this.texture(this.name(block), location))).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$saplingBlock$10((ModelFile)sapling, arg_0), new Property[]{SaplingBlock.f_55973_});
    }

    public void dungeonBlock(Block block, Block baseBlock) {
        ConfiguredModel dungeonBlock = new ConfiguredModel((ModelFile)this.models().cubeAll(this.name(baseBlock), this.texture(this.name(baseBlock), "dungeon/")));
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{dungeonBlock});
    }

    public void invisibleBlock(Block block, Block baseBlock) {
        ModelBuilder visible = this.models().cubeAll(this.name(baseBlock), this.texture(this.name(baseBlock), "dungeon/"));
        ModelBuilder invisible = this.models().getBuilder(this.name(block));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$invisibleBlock$11((ModelFile)visible, (ModelFile)invisible, arg_0), new Property[0]);
    }

    public void chestMimic(Block block, Block dummyBlock) {
        ModelBuilder chest = this.models().cubeAll(this.name(block), this.mcLoc("block/" + this.name(dummyBlock)));
        this.chest(block, (ModelFile)chest);
    }

    public void treasureChest(Block block, Block dummyBlock) {
        ModelBuilder chest = this.models().cubeAll(this.name(block), this.texture(this.name(dummyBlock), "dungeon/"));
        this.chest(block, (ModelFile)chest);
    }

    public void chest(Block block, ModelFile chest) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(chest).build(), new Property[]{ChestBlock.f_51479_, ChestBlock.f_51480_});
    }

    public void pillar(RotatedPillarBlock block) {
        this.axisBlock(block, this.extend(this.texture(this.name((Block)block), "dungeon/"), "_side"), this.extend(this.texture(this.name((Block)block), "dungeon/"), "_top"));
    }

    public void pillarTop(RotatedPillarBlock block) {
        this.axisBlock(block, this.texture("pillar_carved", "dungeon/"), this.texture(this.name((Block)block), "dungeon/"));
    }

    public void present(Block block) {
        ModelFile present = this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "miscellaneous/"), "_side"), this.extend(this.texture(this.name(block), "miscellaneous/"), "_top"), this.extend(this.texture(this.name(block), "miscellaneous/"), "_top"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(present)});
    }

    public void fence(FenceBlock block, Block baseBlock, String location) {
        this.fenceBlock(block, this.texture(this.name(baseBlock), location));
        this.fenceColumn((CrossCollisionBlock)block, this.name(baseBlock), location);
    }

    public void fenceColumn(CrossCollisionBlock block, String side, String location) {
        String baseName = this.name((Block)block);
        this.fourWayBlock(block, (ModelFile)this.models().fencePost(baseName + "_post", this.texture(side, location)), (ModelFile)this.models().fenceSide(baseName + "_side", this.texture(side, location)));
    }

    public void fenceGateBlock(FenceGateBlock block, Block baseBlock, String location) {
        this.fenceGateBlockInternal(block, this.name((Block)block), this.texture(this.name(baseBlock), location));
    }

    public void fenceGateBlockInternal(FenceGateBlock block, String baseName, ResourceLocation texture) {
        ModelBuilder gate = this.models().fenceGate(baseName, texture);
        ModelBuilder gateOpen = this.models().fenceGateOpen(baseName + "_open", texture);
        ModelBuilder gateWall = this.models().fenceGateWall(baseName + "_wall", texture);
        ModelBuilder gateWallOpen = this.models().fenceGateWallOpen(baseName + "_wall_open", texture);
        this.fenceGateBlock(block, (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    public void doorBlock(DoorBlock block, ResourceLocation bottom, ResourceLocation top) {
        this.doorBlockWithRenderType(block, bottom, top, "cutout");
    }

    public void trapdoorBlock(TrapDoorBlock block, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlockWithRenderType(block, texture, orientable, "cutout");
    }

    public void buttonBlock(ButtonBlock block, ResourceLocation texture) {
        ModelBuilder button = this.models().button(this.name((Block)block), texture);
        ModelBuilder buttonPressed = this.models().buttonPressed(this.name((Block)block) + "_pressed", texture);
        this.buttonBlock(block, (ModelFile)button, (ModelFile)buttonPressed);
    }

    public void pressurePlateBlock(PressurePlateBlock block, ResourceLocation texture) {
        ModelBuilder pressurePlate = this.models().pressurePlate(this.name((Block)block), texture);
        ModelBuilder pressurePlateDown = this.models().pressurePlateDown(this.name((Block)block) + "_down", texture);
        this.pressurePlateBlock(block, (ModelFile)pressurePlate, (ModelFile)pressurePlateDown);
    }

    public void wallBlock(WallBlock block, Block baseBlock, String location) {
        this.wallBlockInternal(block, this.name((Block)block), this.texture(this.name(baseBlock), location));
    }

    public void wallBlockInternal(WallBlock block, String baseName, ResourceLocation texture) {
        this.wallBlock(block, (ModelFile)this.models().wallPost(baseName + "_post", texture), (ModelFile)this.models().wallSide(baseName + "_side", texture), (ModelFile)this.models().wallSideTall(baseName + "_side_tall", texture));
    }

    public void stairs(StairBlock block, Block baseBlock, String location) {
        this.stairsBlock(block, this.texture(this.name(baseBlock), location));
    }

    public void slab(SlabBlock block, Block baseBlock, String location) {
        this.slabBlock(block, this.texture(this.name(baseBlock)), this.texture(this.name(baseBlock), location));
    }

    public void translucentSlab(Block block, Block baseBlock, String location) {
        ResourceLocation texture = this.texture(this.name(baseBlock), location);
        this.translucentSlabBlock(block, (ModelFile)((BlockModelBuilder)this.models().slab(this.name(block), texture, texture, texture)).renderType(new ResourceLocation("translucent")), (ModelFile)((BlockModelBuilder)this.models().slabTop(this.name(block) + "_top", texture, texture, texture)).renderType(new ResourceLocation("translucent")), (ModelFile)this.models().getExistingFile(this.texture(this.name(baseBlock))));
    }

    public void translucentSlabBlock(Block block, ModelFile bottom, ModelFile top, ModelFile doubleSlab) {
        this.getVariantBuilder(block).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel(bottom)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel(top)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel(doubleSlab)});
    }

    public void sunAltar(Block block) {
        ModelFile sunAltar = this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "utility/"), "_side"), this.texture("hellfire_stone", "dungeon/"), this.extend(this.texture(this.name(block), "utility/"), "_top"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(sunAltar)});
    }

    public void bookshelf(Block block, Block endBlock) {
        ModelBuilder bookshelf = this.models().cubeColumn(this.name(block), this.texture(this.name(block), "construction/"), this.texture(this.name(endBlock), "construction/"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bookshelf)});
    }

    public void bed(Block block, Block dummyBlock) {
        ModelBuilder head = this.models().cubeAll(this.name(block) + "_head", this.texture(this.name(dummyBlock), "construction/"));
        ModelBuilder foot = this.models().cubeAll(this.name(block) + "_foot", this.texture(this.name(dummyBlock), "construction/"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$bed$13((ModelFile)head, (ModelFile)foot, arg_0), new Property[]{BedBlock.f_49441_});
    }

    public void frostedIce(Block block, Block base) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)AetherFrostedIceBlock.f_53561_);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_" + age, this.mcLoc("block/" + this.name(base) + "_" + age))).renderType(new ResourceLocation("translucent"))).build();
        });
    }

    public void unstableObsidian(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)UnstableObsidianBlock.AGE);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_" + age, this.texture(this.name(block) + "_" + age, "miscellaneous/"))).build();
        });
    }

    public ModelFile cubeAll(Block block, String location) {
        return this.models().cubeAll(this.name(block), this.texture(this.name(block), location));
    }

    public ModelFile cubeAllTranslucent(Block block, String location) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.texture(this.name(block), location))).renderType(new ResourceLocation("translucent"));
    }

    public ModelFile cubeBottomTop(String block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return this.models().cubeBottomTop(block, side, bottom, top);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$bed$13(ModelFile head, ModelFile foot, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BedPart part = (BedPart)state.m_61143_((Property)BlockStateProperties.f_61391_);
        return ConfiguredModel.builder().modelFile(part == BedPart.HEAD ? head : foot).rotationY(((int)dir.m_122435_() + 180) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$invisibleBlock$11(ModelFile visible, ModelFile invisible, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)DoorwayBlock.INVISIBLE)).booleanValue()) {
            return ConfiguredModel.builder().modelFile(visible).build();
        }
        return ConfiguredModel.builder().modelFile(invisible).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$saplingBlock$10(ModelFile sapling, BlockState state) {
        return ConfiguredModel.builder().modelFile(sapling).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$7(ModelFile wallTorch, BlockState state) {
        return ConfiguredModel.builder().modelFile(wallTorch).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$farmland$4(ModelFile farmland, ModelFile moist, BlockState state) {
        int moisture = (Integer)state.m_61143_((Property)AetherFarmBlock.f_53243_);
        return ConfiguredModel.builder().modelFile(moisture < 7 ? farmland : moist).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$dirtPath$3(ModelFile path, BlockState state) {
        return ConfiguredModel.allYRotations((ModelFile)path, (int)0, (boolean)false);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$portal$0(ModelFile portal_ew, ModelFile portal_ns, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)NetherPortalBlock.f_54904_);
        return ConfiguredModel.builder().modelFile(axis == Direction.Axis.Z ? portal_ew : portal_ns).build();
    }
}

