/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.command;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.client.HealthResetPacket;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PlayerCapabilityCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"aether").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"life_shards").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).suggests((context, builder) -> {
            PlayerList playerlist = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_();
            return SharedSuggestionProvider.m_82981_(playerlist.m_11314_().stream().map(player -> player.m_36316_().getName()), (SuggestionsBuilder)builder);
        }).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)10)).executes(context -> PlayerCapabilityCommand.setLifeShards((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))))));
    }

    private static int setLifeShards(CommandSourceStack source, Collection<GameProfile> gameProfiles, int value) {
        ServerLevel level = source.m_81372_();
        PlayerList playerList = source.m_81377_().m_6846_();
        for (GameProfile gameProfile : gameProfiles) {
            ServerPlayer player = playerList.m_11259_(gameProfile.getId());
            if (player == null) continue;
            AetherPlayer.get((Player)player).ifPresent(aetherPlayer -> {
                aetherPlayer.setLifeShardCount(value);
                AttributeInstance attribute = player.m_21051_(Attributes.f_22276_);
                if (attribute != null) {
                    attribute.m_22130_(aetherPlayer.getLifeShardHealthAttributeModifier());
                }
                player.m_21153_(player.m_21233_());
                AetherPacketHandler.sendToNear(new HealthResetPacket(player.m_19879_(), value), player.m_20185_(), player.m_20186_(), player.m_20189_(), 5.0, (ResourceKey<Level>)level.m_46472_());
                source.m_81354_((Component)Component.m_237110_((String)"commands.aether.capability.player.life_shards.set", (Object[])new Object[]{player.m_5446_(), value}), true);
            });
        }
        return 1;
    }
}

