/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.player.layer;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.model.ValkyrieWingsModel;
import com.aetherteam.aether.util.EquipmentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerWingsLayer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation VALKYRIE_TEXTURE = new ResourceLocation("aether", "textures/entity/mobs/valkyrie/valkyrie.png");
    private final ValkyrieWingsModel<Player> wings;

    public PlayerWingsLayer(RenderLayerParent<T, M> entityRenderer, EntityModelSet modelSet) {
        super(entityRenderer);
        this.wings = new ValkyrieWingsModel(modelSet.m_171103_(AetherModelLayers.VALKYRIE_ARMOR_WINGS));
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, @Nonnull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (EquipmentUtil.hasFullValkyrieSet(entity)) {
            AetherPlayer.get(entity).ifPresent(aetherPlayer -> {
                if (!Minecraft.m_91087_().m_91104_()) {
                    this.handleWingRotation((AetherPlayer)aetherPlayer, partialTicks);
                }
                this.setupWingRotation(entity, aetherPlayer.getWingRotation() * ((float)Math.PI / 180));
                VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)VALKYRIE_TEXTURE));
                this.wings.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            });
        }
    }

    private void handleWingRotation(AetherPlayer aetherPlayer, float partialTicks) {
        if (EquipmentUtil.hasFullValkyrieSet((LivingEntity)aetherPlayer.getPlayer())) {
            if (!(aetherPlayer.getPlayer().m_20096_() || aetherPlayer.getPlayer().isInFluidType() || aetherPlayer.getPlayer().m_20202_() == null || aetherPlayer.getPlayer().m_20202_().m_20096_())) {
                aetherPlayer.setWingRotation(Mth.m_14177_((float)Mth.m_14179_((float)partialTicks, (float)aetherPlayer.getWingRotation(), (float)(aetherPlayer.getWingRotation() + 10.742959f))));
            } else {
                aetherPlayer.setWingRotation(Mth.m_14177_((float)Mth.m_14179_((float)partialTicks, (float)aetherPlayer.getWingRotation(), (float)(aetherPlayer.getWingRotation() + 2.1485918f))));
            }
        } else {
            aetherPlayer.setWingRotation(0.0f);
        }
    }

    public void setupWingRotation(@Nonnull T entity, float sinage) {
        this.wings.rightWing.f_104204_ = 0.4f;
        this.wings.rightWing.f_104205_ = 0.125f;
        this.wings.leftWing.f_104204_ = -0.4f;
        this.wings.leftWing.f_104205_ = -0.125f;
        if (entity.m_6047_()) {
            this.wings.rightWing.f_104203_ = 0.45f;
            this.wings.rightWing.f_104201_ = 3.33f;
            this.wings.rightWing.f_104202_ = 3.388f;
            this.wings.leftWing.f_104203_ = 0.45f;
            this.wings.leftWing.f_104201_ = 3.33f;
            this.wings.leftWing.f_104202_ = 3.388f;
        } else {
            this.wings.rightWing.f_104203_ = 0.0f;
            this.wings.leftWing.f_104203_ = 0.0f;
        }
        this.wings.rightWing.f_104204_ -= (float)Math.sin(sinage) / 6.0f;
        this.wings.rightWing.f_104205_ = this.wings.rightWing.f_104205_ - (float)Math.cos(sinage) / (entity.m_20096_() || entity.isInFluidType() ? 8.0f : 3.0f);
        this.wings.leftWing.f_104204_ += (float)Math.sin(sinage) / 6.0f;
        this.wings.leftWing.f_104205_ = this.wings.leftWing.f_104205_ + (float)Math.cos(sinage) / (entity.m_20096_() || entity.isInFluidType() ? 8.0f : 3.0f);
    }
}

