/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.player.layer;

import com.aetherteam.aether.api.AetherPlayerRankings;
import com.aetherteam.aether.capability.rankings.AetherRankings;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.model.HaloModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Triple;

public class PlayerHaloLayer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation PLAYER_HALO_LOCATION = new ResourceLocation("aether", "textures/models/perks/halo.png");
    private static final ResourceLocation PLAYER_HALO_GRAYSCALE_LOCATION = new ResourceLocation("aether", "textures/models/perks/halo_grayscale.png");
    private final HaloModel<Player> playerHalo;

    public PlayerHaloLayer(RenderLayerParent<T, M> renderer, EntityModelSet modelSet) {
        super(renderer);
        this.playerHalo = new HaloModel(modelSet.m_171103_(AetherModelLayers.PLAYER_HALO));
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, @Nonnull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractClientPlayer = (AbstractClientPlayer)entity;
            AetherRankings.get((Player)abstractClientPlayer).ifPresent(aetherRankings -> {
                if (AetherPlayerRankings.hasHalo(abstractClientPlayer.m_20148_()) && aetherRankings.isHaloEnabled() && !abstractClientPlayer.m_20145_()) {
                    this.playerHalo.halo.f_104204_ = ((PlayerModel)this.m_117386_()).f_102808_.f_104204_;
                    this.playerHalo.halo.f_104203_ = ((PlayerModel)this.m_117386_()).f_102808_.f_104203_;
                    this.playerHalo.m_6973_((Player)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    Triple<Float, Float, Float> color = aetherRankings.getHaloColor();
                    if (color != null) {
                        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)PLAYER_HALO_GRAYSCALE_LOCATION));
                        this.playerHalo.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, ((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f);
                    } else {
                        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)PLAYER_HALO_LOCATION));
                        this.playerHalo.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
            });
        }
    }
}

