/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.level;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.mixin.mixins.client.accessor.LevelRendererAccessor;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AetherSkyRenderEffects
extends DimensionSpecialEffects {
    private static final ResourceLocation CLOUDS_LOCATION = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation MOON_LOCATION = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    private final float[] sunriseCol = new float[4];
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private Vec3 prevCloudColor = Vec3.f_82478_;

    public AetherSkyRenderEffects() {
        super(9.5f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        if (((Boolean)AetherConfig.CLIENT.colder_lightmap.get()).booleanValue()) {
            Vector3f vector3f = new Vector3f(skyDarken, skyDarken, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            Vector3f vector3f1 = new Vector3f();
            float f9 = LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)pixelX) * skyLight;
            float f10 = f9 * (f9 * f9 * 0.6f + 0.4f);
            vector3f1.set(f10, f10, f10);
            boolean flag = level.m_104583_().m_108884_();
            if (flag) {
                vector3f1.lerp((Vector3fc)new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                AetherSkyRenderEffects.clampColor(vector3f1);
            } else {
                Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).mul(blockLight);
                vector3f1.add((Vector3fc)vector3f2);
                vector3f1.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                if (Minecraft.m_91087_().f_91063_.m_109131_(partialTicks) > 0.0f) {
                    float darken = Minecraft.m_91087_().f_91063_.m_109131_(partialTicks);
                    Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f1).mul(0.7f, 0.6f, 0.6f);
                    vector3f1.lerp((Vector3fc)vector3f3, darken);
                }
            }
            colors.set((Vector3fc)vector3f1);
        }
    }

    public float[] m_7518_(float timeOfDay, float partialTicks) {
        if (((Boolean)AetherConfig.CLIENT.green_sunset.get()).booleanValue()) {
            float f1 = Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) - 0.0f;
            if (f1 >= -0.4f && f1 <= 0.4f) {
                float f3 = (f1 + 0.0f) / 0.4f * 0.5f + 0.5f;
                float f4 = 1.0f - (1.0f - Mth.m_14031_((float)(f3 * (float)Math.PI))) * 0.99f;
                f4 *= f4;
                this.sunriseCol[0] = f3 * 0.5f + 0.0f;
                this.sunriseCol[1] = f3 * f3 * 0.3f + 0.3f;
                this.sunriseCol[2] = f3 * f3 * 0.5f + 0.3f;
                this.sunriseCol[3] = f4;
                return this.sunriseCol;
            }
            return null;
        }
        float f1 = Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) - 0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 + 0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - Mth.m_14031_((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.sunriseCol[0] = f3 * 0.3f + 0.65f;
            this.sunriseCol[1] = f3 * f3 * 0.7f + 0.25f;
            this.sunriseCol[2] = f3 * f3 * 0.0f + 0.4f;
            this.sunriseCol[3] = f4;
            return this.sunriseCol;
        }
        return null;
    }

    public Vec3 m_5927_(Vec3 color, float p_230494_2_) {
        return color.m_82542_((double)(p_230494_2_ * 0.94f + 0.06f), (double)(p_230494_2_ * 0.94f + 0.06f), (double)(p_230494_2_ * 0.91f + 0.09f));
    }

    public boolean m_5781_(int x, int z) {
        return false;
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
        float f = level.m_104583_().m_108871_();
        if (!Float.isNaN(f)) {
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69482_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_69458_((boolean)true);
            double d1 = ((float)ticks + partialTick) * 0.03f;
            double d2 = (camX + d1) / 12.0;
            double d3 = f - (float)camY + 0.33f;
            double d4 = camZ / 12.0 + (double)0.33f;
            d2 -= (double)(Mth.m_14107_((double)(d2 / 2048.0)) * 2048);
            d4 -= (double)(Mth.m_14107_((double)(d4 / 2048.0)) * 2048);
            float f3 = (float)(d2 - (double)Mth.m_14107_((double)d2));
            float f4 = (float)(d3 / 4.0 - (double)Mth.m_14107_((double)(d3 / 4.0))) * 4.0f;
            float f5 = (float)(d4 - (double)Mth.m_14107_((double)d4));
            Vec3 vec3 = this.getCloudColor(level, partialTick);
            int i = (int)Math.floor(d2);
            int j = (int)Math.floor(d3 / 4.0);
            int k = (int)Math.floor(d4);
            if (i != this.prevCloudX || j != this.prevCloudY || k != this.prevCloudZ || Minecraft.m_91087_().f_91066_.m_92174_() != ((LevelRendererAccessor)levelRenderer).aether$getPrevCloudsType() || this.prevCloudColor.m_82557_(vec3) > 2.0E-4) {
                this.prevCloudX = i;
                this.prevCloudY = j;
                this.prevCloudZ = k;
                this.prevCloudColor = vec3;
                ((LevelRendererAccessor)levelRenderer).aether$setPrevCloudsType(Minecraft.m_91087_().f_91066_.m_92174_());
                ((LevelRendererAccessor)levelRenderer).aether$setGenerateClouds(true);
            }
            if (((LevelRendererAccessor)levelRenderer).aether$isGenerateClouds()) {
                ((LevelRendererAccessor)levelRenderer).aether$setGenerateClouds(false);
                BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                if (((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer() != null) {
                    ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().close();
                }
                ((LevelRendererAccessor)levelRenderer).aether$setCloudBuffer(new VertexBuffer());
                BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = ((LevelRendererAccessor)levelRenderer).callBuildClouds(bufferbuilder, d2, d3, d4, vec3);
                ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().m_85921_();
                ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().m_231221_(bufferbuilder$renderedbuffer);
                VertexBuffer.m_85931_();
            }
            RenderSystem.m_157427_(GameRenderer::m_172838_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CLOUDS_LOCATION);
            FogRenderer.m_109036_();
            poseStack.m_85836_();
            poseStack.m_85841_(12.0f, 1.0f, 12.0f);
            poseStack.m_252880_(-f3, f4, -f5);
            if (((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer() != null) {
                int l;
                ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().m_85921_();
                for (int i1 = l = ((LevelRendererAccessor)levelRenderer).aether$getPrevCloudsType() == CloudStatus.FANCY ? 0 : 1; i1 < 2; ++i1) {
                    if (i1 == 0) {
                        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    ShaderInstance shaderinstance = RenderSystem.m_157196_();
                    ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
                }
                VertexBuffer.m_85931_();
            }
            poseStack.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
        }
        return true;
    }

    public Vec3 getCloudColor(ClientLevel world, float partialTick) {
        float f = world.m_46942_(partialTick);
        float f1 = Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = world.m_46722_(partialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.725f;
            float f7 = 1.0f - f5 * 0.8f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f9 = world.m_46661_(partialTick);
        if (f9 > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.5f;
            float f8 = 1.0f - f9 * 0.7f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        return new Vec3((double)f2, (double)f3, (double)f4);
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
        Vec3 vec3 = this.getSkyColor(level, camera.m_90583_(), partialTick);
        float f = (float)vec3.f_82479_;
        float f1 = (float)vec3.f_82480_;
        float f2 = (float)vec3.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.m_157196_();
        ((LevelRendererAccessor)levelRenderer).aether$getSkyBuffer().m_85921_();
        ((LevelRendererAccessor)levelRenderer).aether$getSkyBuffer().m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.m_69478_();
        float[] sunRiseRGBA = level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick);
        if (sunRiseRGBA != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float f3 = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f3));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float f4 = sunRiseRGBA[0];
            float f5 = sunRiseRGBA[1];
            float f6 = sunRiseRGBA[2];
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, sunRiseRGBA[3]).m_5752_();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = Mth.m_14031_((float)f7);
                float f9 = Mth.m_14089_((float)f7);
                bufferbuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * sunRiseRGBA[3]).m_85950_(sunRiseRGBA[0], sunRiseRGBA[1], sunRiseRGBA[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            poseStack.m_85849_();
        }
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.m_85836_();
        this.drawCelestialBodies(partialTick, poseStack, level, bufferbuilder);
        float f10 = level.m_104811_(partialTick);
        if (f10 > 0.0f) {
            RenderSystem.m_157429_((float)f10, (float)f10, (float)f10, (float)f10);
            FogRenderer.m_109017_();
            ((LevelRendererAccessor)levelRenderer).aether$getStarBuffer().m_85921_();
            ((LevelRendererAccessor)levelRenderer).aether$getStarBuffer().m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            setupFog.run();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        RenderSystem.m_69458_((boolean)true);
        return true;
    }

    public Vec3 getSkyColor(ClientLevel world, Vec3 pPos, float pPartialTick) {
        float f9;
        float f = world.m_46942_(pPartialTick);
        Vec3 vec3 = pPos.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        BiomeManager biomemanager = world.m_7062_();
        Vec3 vec31 = CubicSampler.m_130038_((Vec3)vec3, (p_194161_, p_194162_, p_194163_) -> Vec3.m_82501_((int)((Biome)biomemanager.m_204210_(p_194161_, p_194162_, p_194163_).m_203334_()).m_47463_()));
        float f1 = Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        float f2 = (float)vec31.f_82479_ * f1;
        float f3 = (float)vec31.f_82480_ * f1;
        float f4 = (float)vec31.f_82481_ * f1;
        float f5 = world.m_46722_(pPartialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.61f;
            float f7 = 1.0f - f5 * 0.2f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        if ((f9 = world.m_46661_(pPartialTick)) > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.48f;
            float f8 = 1.0f - f9 * 0.21f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        if (!((Boolean)Minecraft.m_91087_().f_91066_.m_231935_().m_231551_()).booleanValue() && world.m_104819_() > 0) {
            float f11 = (float)world.m_104819_() - pPartialTick;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f2 = f2 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f3 = f3 * (1.0f - f11) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + 1.0f * f11;
        }
        return new Vec3((double)f2, (double)f3, (double)f4);
    }

    private void drawCelestialBodies(float pPartialTick, PoseStack pPoseStack, ClientLevel world, BufferBuilder bufferbuilder) {
        float moonOpacity;
        float sunOpacity;
        long dayTime = world.m_46468_() % 72000L;
        if (dayTime > 71400L) {
            sunOpacity = Math.min((float)(dayTime -= 71400L) * 0.0016666667f, 1.0f);
            moonOpacity = Math.max(1.0f - (float)dayTime * 0.0016666667f, 0.0f);
        } else if (dayTime > 38400L) {
            sunOpacity = Math.max(1.0f - (float)(dayTime -= 38400L) * 0.0016666667f, 0.0f);
            moonOpacity = Math.min((float)dayTime * 0.0016666667f, 1.0f);
        } else {
            sunOpacity = 1.0f;
            moonOpacity = 0.0f;
        }
        sunOpacity -= world.m_46722_(pPartialTick);
        moonOpacity -= world.m_46722_(pPartialTick);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(world.m_46942_(pPartialTick) * 360.0f));
        Matrix4f matrix4f1 = pPoseStack.m_85850_().m_252922_();
        float celestialOffset = 30.0f;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)sunOpacity);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_LOCATION);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -celestialOffset, 100.0f, -celestialOffset).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, celestialOffset, 100.0f, -celestialOffset).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, celestialOffset, 100.0f, celestialOffset).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -celestialOffset, 100.0f, celestialOffset).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)moonOpacity);
        celestialOffset = 20.0f;
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOON_LOCATION);
        int moonPhase = world.m_46941_();
        int textureX = moonPhase % 4;
        int textureY = moonPhase / 4 % 2;
        float uLeft = (float)textureX / 4.0f;
        float vDown = (float)textureY / 2.0f;
        float uRight = (float)(textureX + 1) / 4.0f;
        float vUp = (float)(textureY + 1) / 2.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -celestialOffset, -100.0f, celestialOffset).m_7421_(uRight, vUp).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, celestialOffset, -100.0f, celestialOffset).m_7421_(uLeft, vUp).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, celestialOffset, -100.0f, -celestialOffset).m_7421_(uLeft, vDown).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -celestialOffset, -100.0f, -celestialOffset).m_7421_(uRight, vDown).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    private static void clampColor(Vector3f vec) {
        vec.set(Mth.m_14036_((float)vec.x, (float)0.0f, (float)1.0f), Mth.m_14036_((float)vec.y, (float)0.0f, (float)1.0f), Mth.m_14036_((float)vec.z, (float)0.0f, (float)1.0f));
    }
}

