/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.monster.Zephyr;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ZephyrModel
extends EntityModel<Zephyr> {
    public ModelPart rightFace;
    public ModelPart leftFace;
    public ModelPart mouth;
    public ModelPart body;
    public ModelPart bodyRightSideFront;
    public ModelPart bodyRightSideBack;
    public ModelPart bodyLeftSideFront;
    public ModelPart bodyLeftSideBack;
    public ModelPart cloudButt;
    public ModelPart tailBase;
    public ModelPart tailMiddle;
    public ModelPart tailEnd;

    public ZephyrModel(ModelPart model) {
        this.rightFace = model.m_171324_("right_face");
        this.leftFace = model.m_171324_("left_face");
        this.mouth = model.m_171324_("mouth");
        this.body = model.m_171324_("body");
        this.bodyRightSideFront = model.m_171324_("body_right_side_front");
        this.bodyRightSideBack = model.m_171324_("body_right_side_back");
        this.bodyLeftSideFront = model.m_171324_("body_left_side_front");
        this.bodyLeftSideBack = model.m_171324_("body_left_side_back");
        this.cloudButt = model.m_171324_("cloud_butt");
        this.tailBase = model.m_171324_("tail_base");
        this.tailMiddle = this.tailBase.m_171324_("tail_middle");
        this.tailEnd = this.tailMiddle.m_171324_("tail_end");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("right_face", CubeListBuilder.m_171558_().m_171514_(67, 11).m_171481_(-7.0f, -1.0f, -9.0f, 4.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        partDefinition.m_171599_("left_face", CubeListBuilder.m_171558_().m_171514_(67, 11).m_171480_().m_171481_(3.0f, -1.0f, -9.0f, 4.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        partDefinition.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(66, 19).m_171480_().m_171481_(-3.0f, 1.0f, -8.0f, 6.0f, 3.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(27, 9).m_171481_(-6.0f, -4.0f, -7.0f, 12.0f, 9.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        partDefinition.m_171599_("body_right_side_front", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171480_().m_171481_(-2.0f, -3.0f, -3.0f, 2.0f, 6.0f, 6.0f), PartPose.m_171419_((float)-6.0f, (float)8.0f, (float)-4.0f));
        partDefinition.m_171599_("body_right_side_back", CubeListBuilder.m_171558_().m_171514_(25, 11).m_171480_().m_171481_(-2.0f, -3.3333f, -2.5f, 2.0f, 6.0f, 6.0f), PartPose.m_171419_((float)-5.5f, (float)9.0f, (float)2.0f));
        partDefinition.m_171599_("body_left_side_front", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(0.0f, -3.0f, -3.0f, 2.0f, 6.0f, 6.0f), PartPose.m_171419_((float)6.0f, (float)8.0f, (float)-4.0f));
        partDefinition.m_171599_("body_left_side_back", CubeListBuilder.m_171558_().m_171514_(25, 11).m_171481_(0.0f, -3.3333f, -2.5f, 2.0f, 6.0f, 6.0f), PartPose.m_171419_((float)5.5f, (float)9.0f, (float)2.0f));
        partDefinition.m_171599_("cloud_butt", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-6.0f, -3.0f, 0.0f, 8.0f, 6.0f, 2.0f), PartPose.m_171419_((float)2.0f, (float)8.0f, (float)7.0f));
        PartDefinition tailBase = partDefinition.m_171599_("tail_base", CubeListBuilder.m_171558_().m_171514_(96, 22).m_171481_(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)12.4f));
        PartDefinition tailMiddle = tailBase.m_171599_("tail_middle", CubeListBuilder.m_171558_().m_171514_(80, 24).m_171481_(-2.0f, -2.0f, -1.966667f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        tailMiddle.m_171599_("tail_end", CubeListBuilder.m_171558_().m_171514_(84, 18).m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)32);
    }

    public void setupAnim(@Nonnull Zephyr zephyr, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float motion = Mth.m_14031_((float)(limbSwing * 20.0f / 57.295776f)) * limbSwingAmount * 0.5f;
        this.rightFace.f_104201_ = 8.0f - motion;
        this.rightFace.f_104200_ = -motion * 0.5f;
        this.leftFace.f_104201_ = motion + 8.0f;
        this.leftFace.f_104200_ = motion * 0.5f;
        this.bodyRightSideFront.f_104201_ = 8.0f - motion * 0.5f;
        this.bodyRightSideBack.f_104201_ = 9.0f + motion * 0.5f;
        this.bodyLeftSideFront.f_104201_ = this.bodyRightSideFront.f_104201_;
        this.bodyLeftSideBack.f_104201_ = this.bodyRightSideBack.f_104201_;
        this.tailBase.f_104200_ = Mth.m_14031_((float)(limbSwing * 20.0f / 57.295776f)) * limbSwingAmount * 0.75f;
        this.tailBase.f_104201_ = 8.0f - motion;
        this.tailBase.f_104204_ = Mth.m_14031_((float)(ageInTicks * 0.5f)) * limbSwingAmount * 0.75f;
        this.tailMiddle.f_104200_ = Mth.m_14031_((float)(limbSwing * 15.0f / 57.295776f)) * limbSwingAmount * 0.85f;
        this.tailMiddle.f_104201_ = motion * 1.25f;
        this.tailMiddle.f_104204_ = this.tailBase.f_104204_ + 0.25f;
        this.tailEnd.f_104200_ = Mth.m_14031_((float)(limbSwing * 10.0f / 57.295776f)) * limbSwingAmount * 0.95f;
        this.tailEnd.f_104201_ = -motion;
        this.tailEnd.f_104204_ = this.tailMiddle.f_104204_ + 0.35f;
    }

    public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer consumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.rightFace.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftFace.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.mouth.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bodyRightSideFront.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bodyRightSideBack.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bodyLeftSideFront.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bodyLeftSideBack.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.cloudButt.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tailBase.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

