/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.passive.Sheepuff;
import javax.annotation.Nonnull;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class SheepuffWoolModel
extends QuadrupedModel<Sheepuff> {
    private float headXRot;

    public SheepuffWoolModel(ModelPart root) {
        super(root, false, 8.0f, 4.0f, 2.0f, 2.0f, 24);
    }

    public static LayerDefinition createFurLayer(CubeDeformation cube, float height) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -4.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-8.0f));
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(28, 8).m_171488_(-4.0f, -10.0f + height, -7.0f, 8.0f, 16.0f, 6.0f, cube), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubeBuilder = CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f));
        partDefinition.m_171599_("right_hind_leg", cubeBuilder, PartPose.m_171419_((float)-3.0f, (float)12.0f, (float)7.0f));
        partDefinition.m_171599_("left_hind_leg", cubeBuilder, PartPose.m_171419_((float)3.0f, (float)12.0f, (float)7.0f));
        partDefinition.m_171599_("right_front_leg", cubeBuilder, PartPose.m_171419_((float)-3.0f, (float)12.0f, (float)-5.0f));
        partDefinition.m_171599_("left_front_leg", cubeBuilder, PartPose.m_171419_((float)3.0f, (float)12.0f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void prepareMobModel(@Nonnull Sheepuff sheepuff, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.m_6839_((Entity)sheepuff, limbSwing, limbSwingAmount, partialTicks);
        this.f_103492_.f_104201_ = 6.0f + sheepuff.getHeadEatPositionScale(partialTicks) * 9.0f;
        this.headXRot = sheepuff.getHeadEatAngleScale(partialTicks);
    }

    public void setupAnim(@Nonnull Sheepuff sheepuff, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((Entity)sheepuff, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.f_103492_.f_104203_ = this.headXRot;
    }
}

