/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.NotGrounded;
import com.aetherteam.aether.entity.WingedBird;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public abstract class BipedBirdModel<T extends Entity & NotGrounded>
extends EntityModel<T> {
    public ModelPart head;
    public ModelPart jaw;
    public ModelPart neck;
    public ModelPart body;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart rightWing;
    public ModelPart leftWing;
    public ModelPart rightTailFeather;
    public ModelPart middleTailFeather;
    public ModelPart leftTailFeather;

    public BipedBirdModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.neck = this.head.m_171324_("neck");
        this.body = root.m_171324_("body");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
        this.rightWing = this.body.m_171324_("right_wing");
        this.leftWing = this.body.m_171324_("left_wing");
        this.rightTailFeather = root.m_171324_("right_tail_feather");
        this.middleTailFeather = root.m_171324_("middle_tail_feather");
        this.leftTailFeather = root.m_171324_("left_tail_feather");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cube) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171496_(-2.0f, -4.0f, -6.0f, 4.0f, 4.0f, 8.0f, CubeDeformation.f_171458_, 0.5f, 0.5f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)-4.0f));
        head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(24, 13).m_171496_(-2.0f, -1.0f, -6.0f, 4.0f, 1.0f, 8.0f, new CubeDeformation(-0.1f), 0.5f, 0.5f), PartPose.f_171404_);
        head.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171496_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.f_171458_, 0.5f, 0.5f), PartPose.f_171404_);
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171496_(-3.0f, -3.0f, 0.0f, 6.0f, 8.0f, 5.0f, cube, 0.5f, 0.5f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171496_(-1.0f, -1.0f, -1.0f, 2.0f, 9.0f, 2.0f, CubeDeformation.f_171458_, 0.5f, 0.5f), PartPose.m_171419_((float)-2.0f, (float)16.0f, (float)1.0f));
        partDefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171496_(-1.0f, -1.0f, -1.0f, 2.0f, 9.0f, 2.0f, CubeDeformation.f_171458_, 0.5f, 0.5f), PartPose.m_171419_((float)2.0f, (float)16.0f, (float)1.0f));
        body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171496_(-1.0f, 0.0f, -2.0f, 1.0f, 8.0f, 4.0f, CubeDeformation.f_171458_, 0.5f, 0.5f), PartPose.m_171419_((float)-3.001f, (float)-3.0f, (float)3.0f));
        body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171496_(0.0f, 0.0f, -2.0f, 1.0f, 8.0f, 4.0f, CubeDeformation.f_171458_, 0.5f, 0.5f), PartPose.m_171419_((float)3.001f, (float)-3.0f, (float)3.0f));
        partDefinition.m_171599_("right_tail_feather", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171496_(-1.0f, -5.0f, 5.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(-0.3f), 0.5f, 0.5f), PartPose.m_171423_((float)0.0f, (float)17.5f, (float)1.0f, (float)0.25f, (float)-0.375f, (float)0.0f));
        partDefinition.m_171599_("middle_tail_feather", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171496_(-1.0f, -5.0f, 5.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(-0.3f), 0.5f, 0.5f), PartPose.m_171423_((float)0.0f, (float)17.5f, (float)1.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("left_tail_feather", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171496_(-1.0f, -5.0f, 5.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(-0.3f), 0.5f, 0.5f), PartPose.m_171423_((float)0.0f, (float)17.5f, (float)1.0f, (float)0.25f, (float)0.375f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public void m_6973_(@Nonnull T bipedBird, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.neck.f_104203_ = -this.head.f_104203_;
        if (!((NotGrounded)bipedBird).isEntityOnGround()) {
            this.rightWing.m_104227_(-3.001f, 0.0f, 4.0f);
            this.leftWing.m_104227_(3.001f, 0.0f, 4.0f);
            this.leftWing.f_104203_ = this.rightWing.f_104203_ = -1.5707964f;
            this.leftLeg.f_104203_ = this.rightLeg.f_104203_ = 0.6f;
            this.rightWing.f_104204_ = ageInTicks;
        } else {
            this.rightWing.m_104227_(-3.001f, -3.0f, 3.0f);
            this.leftWing.m_104227_(3.001f, -3.0f, 3.0f);
            this.rightWing.f_104203_ = 0.0f;
            this.leftWing.f_104203_ = 0.0f;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * 1.4f * limbSwingAmount;
            this.rightWing.f_104204_ = 0.0f;
        }
        this.leftWing.f_104204_ = -this.rightWing.f_104204_;
    }

    public float setupWingsAnimation(T bipedBird, float partialTicks) {
        float rotVal = Mth.m_14179_((float)partialTicks, (float)((WingedBird)bipedBird).getPrevWingRotation(), (float)((WingedBird)bipedBird).getWingRotation());
        float destVal = Mth.m_14179_((float)partialTicks, (float)((WingedBird)bipedBird).getPrevDestPos(), (float)((WingedBird)bipedBird).getDestPos());
        return (Mth.m_14031_((float)(rotVal * 0.225f)) + 1.0f) * destVal;
    }

    public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer consumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightTailFeather.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.middleTailFeather.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftTailFeather.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

