/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.layers;

import com.aetherteam.aether.client.renderer.entity.model.SheepuffModel;
import com.aetherteam.aether.client.renderer.entity.model.SheepuffWoolModel;
import com.aetherteam.aether.entity.passive.Sheepuff;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;

public class SheepuffWoolLayer
extends RenderLayer<Sheepuff, SheepuffModel> {
    private static final ResourceLocation SHEEPUFF_WOOL_TEXTURE = new ResourceLocation("aether", "textures/entity/mobs/sheepuff/sheepuff_wool.png");
    private final SheepuffWoolModel wool;
    private final SheepuffWoolModel puffed;

    public SheepuffWoolLayer(RenderLayerParent<Sheepuff, SheepuffModel> entityRenderer, SheepuffWoolModel woolModel, SheepuffWoolModel puffedModel) {
        super(entityRenderer);
        this.wool = woolModel;
        this.puffed = puffedModel;
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, Sheepuff sheepuff, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!sheepuff.isSheared()) {
            SheepuffWoolModel woolModel;
            SheepuffWoolModel sheepuffWoolModel = woolModel = sheepuff.getPuffed() ? this.puffed : this.wool;
            if (sheepuff.m_20145_()) {
                Minecraft minecraft = Minecraft.m_91087_();
                boolean flag = minecraft.m_91314_((Entity)sheepuff);
                if (flag) {
                    ((SheepuffModel)this.m_117386_()).m_102624_((EntityModel)woolModel);
                    woolModel.prepareMobModel(sheepuff, limbSwing, limbSwingAmount, partialTicks);
                    woolModel.setupAnim(sheepuff, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    VertexConsumer consumer = buffer.m_6299_(RenderType.m_110491_((ResourceLocation)SHEEPUFF_WOOL_TEXTURE));
                    woolModel.m_7695_(poseStack, consumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)sheepuff, (float)0.0f), 0.0f, 0.0f, 0.0f, 1.0f);
                }
            } else {
                float f2;
                float f1;
                float f;
                if (sheepuff.m_8077_() && sheepuff.m_7755_().getString().equals("jeb_")) {
                    int i1 = 25;
                    int i = sheepuff.f_19797_ / i1 + sheepuff.m_19879_();
                    int j = DyeColor.values().length;
                    int k = i % j;
                    int l = (i + 1) % j;
                    float f3 = ((float)(sheepuff.f_19797_ % i1) + partialTicks) / (float)i1;
                    float[] afloat1 = Sheepuff.getColorArray(DyeColor.m_41053_((int)k));
                    float[] afloat2 = Sheepuff.getColorArray(DyeColor.m_41053_((int)l));
                    f = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
                    f1 = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
                    f2 = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
                } else {
                    float[] afloat = Sheepuff.getColorArray(sheepuff.getColor());
                    f = afloat[0];
                    f1 = afloat[1];
                    f2 = afloat[2];
                }
                SheepuffWoolLayer.m_117359_((EntityModel)this.m_117386_(), (EntityModel)woolModel, (ResourceLocation)SHEEPUFF_WOOL_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)sheepuff, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)f, (float)f1, (float)f2);
            }
        }
    }
}

