/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity;

import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.layers.MoaSaddleLayer;
import com.aetherteam.aether.client.renderer.entity.model.MoaModel;
import com.aetherteam.aether.entity.passive.Moa;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;

public class MoaRenderer
extends MobRenderer<Moa, MoaModel> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("aether", "textures/entity/mobs/moa/white_moa.png");
    private static final ResourceLocation MOS_TEXTURE = new ResourceLocation("aether", "textures/entity/mobs/moa/mos.png");
    private static final ResourceLocation RAPTOR_TEXTURE = new ResourceLocation("aether", "textures/entity/mobs/moa/raptor.png");

    public MoaRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MoaModel(context.m_174023_(AetherModelLayers.MOA)), 0.7f);
        this.m_115326_(new MoaSaddleLayer((RenderLayerParent<Moa, MoaModel>)this, new MoaModel(context.m_174023_(AetherModelLayers.MOA_SADDLE))));
    }

    protected void scale(Moa moa, PoseStack poseStack, float partialTickTime) {
        float moaScale = moa.m_6162_() ? 1.0f : 1.8f;
        poseStack.m_85841_(moaScale, moaScale, moaScale);
        if (moa.isSitting()) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
        }
    }

    protected float getBob(@Nonnull Moa moa, float partialTicks) {
        return ((MoaModel)this.f_115290_).setupWingsAnimation(moa, partialTicks);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(Moa moa) {
        if (moa.m_8077_() && moa.m_7755_().getString().equals("Mos")) {
            return MOS_TEXTURE;
        }
        if (moa.m_8077_() && moa.m_7755_().getString().equals("Raptor__") && moa.getMoaType() == AetherMoaTypes.BLUE.get() || moa.getRider() != null && moa.getRider().equals(UUID.fromString("c3e6871e-8e60-490a-8a8d-2bbe35ad1604"))) {
            return RAPTOR_TEXTURE;
        }
        MoaType moaType = moa.getMoaType();
        return moaType == null ? DEFAULT_TEXTURE : moaType.getMoaTexture();
    }
}

